/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai;

import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotActivities;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.ai.behavior.charging.FindRechargeStation;
import com.daqem.irobot.entity.ai.behavior.charging.StayOnStationAndRecharge;
import com.daqem.irobot.entity.ai.behavior.core.GoToChargingActivity;
import com.daqem.irobot.entity.ai.behavior.core.GoToDropOffActivity;
import com.daqem.irobot.entity.ai.behavior.core.GoToRestActivity;
import com.daqem.irobot.entity.ai.behavior.core.PickUpItemsAround;
import com.daqem.irobot.entity.ai.behavior.dropoff.DepositItemsAtDropoff;
import com.daqem.irobot.entity.ai.behavior.dropoff.FindDropoffChest;
import com.daqem.irobot.entity.ai.behavior.farming.FindFarmableBlock;
import com.daqem.irobot.entity.ai.behavior.farming.HarvestAndReplantCrop;
import com.daqem.irobot.entity.ai.behavior.following.FollowAndProtectOwner;
import com.daqem.irobot.entity.ai.behavior.following.MeleeAttack;
import com.daqem.irobot.entity.ai.behavior.idle.GoToTaskActivity;
import com.daqem.irobot.entity.ai.behavior.mining.FindNextBlockToMine;
import com.daqem.irobot.entity.ai.behavior.mining.MineBlock;
import com.daqem.irobot.entity.ai.behavior.panic.RobotCalmDown;
import com.daqem.irobot.entity.ai.behavior.panic.RobotPanicTrigger;
import com.daqem.irobot.entity.ai.behavior.protecting.FindHostileMobInArea;
import com.daqem.irobot.entity.ai.behavior.protecting.StrollInArea;
import com.daqem.irobot.entity.ai.behavior.resting.GoToIdleActivity;
import com.daqem.irobot.entity.ai.behavior.woodcutting.CutDownTree;
import com.daqem.irobot.entity.ai.behavior.woodcutting.FindNextTreeToCut;
import com.daqem.irobot.entity.ai.behavior.woodcutting.ReplantTree;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class RobotBrainPackages {
    public static Brain.Provider<IRobotEntity> createBrainProvider() {
        return Brain.provider(IRobotEntity.MEMORY_TYPES, IRobotEntity.SENSOR_TYPES);
    }

    public static void registerBrainGoals(Brain<IRobotEntity> brain) {
        brain.addActivity(Activity.CORE, RobotBrainPackages.getCorePackage());
        brain.addActivityWithConditions((Activity)IRobotActivities.PROTECT.get(), RobotBrainPackages.getProtectingPackage(), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)MemoryStatus.VALUE_PRESENT)));
        brain.addActivityWithConditions((Activity)IRobotActivities.MINE.get(), RobotBrainPackages.getMiningPackage(), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)MemoryStatus.VALUE_PRESENT)));
        brain.addActivityWithConditions((Activity)IRobotActivities.CUT_WOOD.get(), RobotBrainPackages.getWoodcuttingPackage(), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)MemoryStatus.VALUE_PRESENT)));
        brain.addActivityWithConditions((Activity)IRobotActivities.FARM.get(), RobotBrainPackages.getFarmingPackage(), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)MemoryStatus.VALUE_PRESENT)));
        brain.addActivityWithConditions((Activity)IRobotActivities.FOLLOW.get(), RobotBrainPackages.getFollowingPackage(), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)MemoryStatus.VALUE_PRESENT)));
        brain.addActivity((Activity)IRobotActivities.DROPOFF.get(), RobotBrainPackages.getDropoffPackage());
        brain.addActivity((Activity)IRobotActivities.RECHARGE.get(), RobotBrainPackages.getRechargePackage());
        brain.addActivity(Activity.IDLE, RobotBrainPackages.getIdlePackage());
        brain.addActivity(Activity.PANIC, RobotBrainPackages.getPanicPackage());
        brain.addActivity(Activity.REST, RobotBrainPackages.getRestPackage());
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.setActiveActivityIfPossible(Activity.IDLE);
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getCorePackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GoToRestActivity())));
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getIdlePackage() {
        ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> behaviors = new ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>>(RobotBrainPackages.getDefaultPackage());
        behaviors.addAll(List.of(Pair.of((Object)0, (Object)((Object)new GoToTaskActivity())), Pair.of((Object)1, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), Pair.of((Object)3, (Object)((Object)new GoToDropOffActivity(robot -> robot.getInventory().hasItemsToDropOff())))));
        return ImmutableList.copyOf(behaviors);
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getProtectingPackage() {
        ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> behaviors = new ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>>(RobotBrainPackages.getDefaultPackage());
        behaviors.addAll(List.of(Pair.of((Object)0, (Object)StopAttackingIfTargetInvalid.create()), Pair.of((Object)1, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)0.75f)), Pair.of((Object)2, (Object)((Object)new MeleeAttack(5))), Pair.of((Object)3, (Object)((Object)new FindHostileMobInArea())), Pair.of((Object)4, (Object)((Object)new StrollInArea()))));
        return ImmutableList.copyOf(behaviors);
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getMiningPackage() {
        ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> behaviors = new ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>>(RobotBrainPackages.getDefaultPackage());
        behaviors.addAll(List.of(Pair.of((Object)2, (Object)((Object)new FindNextBlockToMine())), Pair.of((Object)3, (Object)((Object)new MineBlock()))));
        return ImmutableList.copyOf(behaviors);
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getWoodcuttingPackage() {
        ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> behaviors = new ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>>(RobotBrainPackages.getDefaultPackage());
        behaviors.addAll(List.of(Pair.of((Object)2, (Object)((Object)new ReplantTree())), Pair.of((Object)3, (Object)((Object)new FindNextTreeToCut())), Pair.of((Object)4, (Object)((Object)new CutDownTree()))));
        return ImmutableList.copyOf(behaviors);
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getFarmingPackage() {
        ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> behaviors = new ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>>(RobotBrainPackages.getDefaultPackage());
        behaviors.addAll(List.of(Pair.of((Object)1, (Object)((Object)new FindFarmableBlock())), Pair.of((Object)2, (Object)((Object)new HarvestAndReplantCrop()))));
        return ImmutableList.copyOf(behaviors);
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getFollowingPackage() {
        ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> behaviors = new ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>>(RobotBrainPackages.getDefaultPackage());
        behaviors.addAll(List.of(Pair.of((Object)0, (Object)StopAttackingIfTargetInvalid.create()), Pair.of((Object)1, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)0.75f)), Pair.of((Object)1, (Object)((Object)new MeleeAttack(5))), Pair.of((Object)2, (Object)((Object)new FollowAndProtectOwner()))));
        return ImmutableList.copyOf(behaviors);
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getRechargePackage() {
        ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> behaviors = new ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>>(RobotBrainPackages.getDefaultPackage());
        behaviors.addAll(List.of(Pair.of((Object)0, (Object)((Object)new FindRechargeStation())), Pair.of((Object)1, (Object)((Object)new StayOnStationAndRecharge()))));
        return ImmutableList.copyOf(behaviors);
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getDropoffPackage() {
        ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> behaviors = new ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>>(RobotBrainPackages.getDefaultPackage());
        behaviors.addAll(List.of(Pair.of((Object)0, (Object)((Object)new FindDropoffChest())), Pair.of((Object)1, (Object)((Object)new DepositItemsAtDropoff()))));
        return ImmutableList.copyOf(behaviors);
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getRestPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GoToIdleActivity())));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getPanicPackage() {
        float speed = 0.75f;
        ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> behaviors = new ArrayList<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>>(RobotBrainPackages.getDefaultPackage());
        behaviors.addAll(List.of(Pair.of((Object)0, (Object)((Object)new RobotCalmDown())), Pair.of((Object)1, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY, (float)speed, (int)6, (boolean)false)), Pair.of((Object)2, (Object)RandomStroll.stroll((float)speed, (int)2, (int)2))));
        return ImmutableList.copyOf(behaviors);
    }

    private static List<Pair<Integer, ? extends BehaviorControl<? super IRobotEntity>>> getDefaultPackage() {
        return List.of(Pair.of((Object)0, (Object)new Swim(0.8f)), Pair.of((Object)0, (Object)InteractWithDoor.create()), Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), Pair.of((Object)0, (Object)((Object)new RobotPanicTrigger())), Pair.of((Object)1, (Object)new MoveToTargetSink(){

            protected boolean checkExtraStartConditions(ServerLevel level, Mob owner) {
                IRobotEntity robot;
                return super.checkExtraStartConditions(level, owner) && owner instanceof IRobotEntity && (robot = (IRobotEntity)owner).getEnergy() > 0.0;
            }

            protected boolean canStillUse(ServerLevel level, Mob entity, long gameTime) {
                IRobotEntity robot;
                return super.canStillUse(level, entity, gameTime) && entity instanceof IRobotEntity && (robot = (IRobotEntity)entity).getEnergy() > 0.0;
            }
        }), Pair.of((Object)2, (Object)((Object)new GoToChargingActivity())), Pair.of((Object)3, (Object)((Object)new GoToDropOffActivity(robot -> robot.getInventory().isMainInventoryFull() && robot.getInventory().hasItemsToDropOff()))), Pair.of((Object)5, (Object)((Object)new PickUpItemsAround())));
    }
}

