/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.charging;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.block.IRobotBlocks;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.task.RobotTask;
import com.daqem.irobot.level.poi.IRobotPoiTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.Block;

public class StayOnStationAndRecharge
extends Behavior<IRobotEntity> {
    public StayOnStationAndRecharge() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, IRobotEntity robot) {
        return level.getBlockState(robot.blockPosition()).is((Block)IRobotBlocks.ROBOT_STATION.get());
    }

    protected boolean canStillUse(ServerLevel level, IRobotEntity robot, long gameTime) {
        boolean isAtRobotStation;
        boolean isNotFull;
        boolean bl = isNotFull = robot.getEnergy() < robot.getMaxEnergy();
        if (!isNotFull) {
            IRobot.LOGGER.info("StayOnStationAndRecharge is full");
        }
        if (!(isAtRobotStation = level.getBlockState(robot.blockPosition()).is((Block)IRobotBlocks.ROBOT_STATION.get()))) {
            IRobot.LOGGER.info("StayOnStationAndRecharge robot moved from station");
        }
        return isNotFull && isAtRobotStation;
    }

    protected void start(ServerLevel level, IRobotEntity entity, long gameTime) {
        BlockPos stationPos = entity.blockPosition();
        level.getPoiManager().take(poiTypeHolder -> poiTypeHolder.is(IRobotPoiTypes.ROBOT_STATION.getId()), (poiTypeHolder, blockPos) -> blockPos.equals((Object)stationPos), stationPos, 0);
        entity.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.STATION_POS.get(), (Object)new GlobalPos(level.dimension(), stationPos));
        entity.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.IS_CHARING.get(), (Object)true);
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }

    protected void stop(ServerLevel level, IRobotEntity robot, long gameTime) {
        robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.STATION_POS.get()).ifPresent(globalPos -> {
            if (level.getPoiManager().exists(globalPos.pos(), poiTypeHolder -> true)) {
                level.getPoiManager().release(globalPos.pos());
            }
        });
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.STATION_POS.get());
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.IS_CHARING.get());
        RobotTask previousTask = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()).orElse(null);
        if (previousTask == null) {
            robot.getBrain().setActiveActivityIfPossible(Activity.IDLE);
        } else {
            robot.getBrain().setActiveActivityIfPossible(previousTask.getActivity());
        }
    }
}

