/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.dropoff;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.level.poi.IRobotPoiTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FindDropoffChest
extends Behavior<IRobotEntity> {
    public FindDropoffChest() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected void start(ServerLevel level, IRobotEntity robot, long gameTime) {
        level.getPoiManager().findClosest(poiTypeHolder -> poiTypeHolder.is(IRobotPoiTypes.DROPOFF_CHEST.getId()), blockPos -> {
            BlockEntity patt0$temp = level.getBlockEntity(blockPos);
            if (!(patt0$temp instanceof Container)) return false;
            Container container = (Container)patt0$temp;
            if (!robot.getInventory().canAddItem(container)) return false;
            return true;
        }, robot.blockPosition(), ((Integer)IRobotConfig.POI_SEARCH_RANGE.get()).intValue(), PoiManager.Occupancy.ANY).ifPresentOrElse(poiPos -> {
            robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(poiPos, 0.5f, 1));
            robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.DROPOFF_TARGET_POS.get(), (Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)poiPos));
        }, () -> {
            LivingEntity patt0$temp = robot.getOwner();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                serverPlayer.sendSystemMessage((Component)IRobot.translatable("robot.error.cant_find_dropoff", robot.getDisplayName()));
            }
            robot.getBrain().setActiveActivityIfPossible(Activity.REST);
        });
    }
}

