/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.farming;

import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.task.RobotTask;
import com.daqem.irobot.util.CropUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class FindNextCropToFarm
extends Behavior<IRobotEntity> {
    public FindNextCropToFarm() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull IRobotEntity robot) {
        return robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()).orElse(null) == RobotTask.FARMING;
    }

    protected void start(@NotNull ServerLevel level, @NotNull IRobotEntity robot, long gameTime) {
        Optional startPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        Optional endPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        if (startPosOpt.isEmpty() || endPosOpt.isEmpty()) {
            return;
        }
        BlockPos startPos = ((GlobalPos)startPosOpt.get()).pos();
        BlockPos endPos = ((GlobalPos)endPosOpt.get()).pos();
        AABB searchArea = OutlineRenderer.createBoundingBox(startPos, endPos);
        this.findClosestMatureCrop(level, robot, searchArea).ifPresent(cropPos -> {
            robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get(), (Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)cropPos));
            robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(cropPos, 0.5f, 1));
        });
    }

    private Optional<BlockPos> findClosestMatureCrop(ServerLevel level, IRobotEntity robot, AABB searchArea) {
        BlockPos robotPos = robot.blockPosition();
        return BlockPos.betweenClosedStream((AABB)searchArea).map(BlockPos::immutable).filter(pos -> {
            BlockPos farmlandPos = pos.below();
            return level.getBlockState(farmlandPos).is(Blocks.FARMLAND) && CropUtils.isFarmableCrop(level.getBlockState(pos)) && CropUtils.isMature(level.getBlockState(pos));
        }).min(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)robotPos)));
    }
}

