/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.farming;

import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.item.module.ModuleItem;
import com.daqem.irobot.util.CropUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class HarvestAndReplantCrop
extends Behavior<IRobotEntity> {
    private int ticksSinceStarted;
    private BlockPos targetPos;

    public HarvestAndReplantCrop() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, IRobotEntity robot) {
        Optional farmPos = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get());
        boolean hasPos = farmPos.isPresent();
        if (hasPos) {
            boolean isCloseEnough = ((GlobalPos)farmPos.get()).pos().closerThan((Vec3i)robot.blockPosition(), 2.0);
            if (!isCloseEnough) {
                robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get());
            }
            return isCloseEnough;
        }
        return false;
    }

    protected void start(ServerLevel level, IRobotEntity robot, long gameTime) {
        this.ticksSinceStarted = 0;
        robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get()).ifPresent(globalPos -> {
            this.targetPos = globalPos.pos();
            robot.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.targetPos));
            robot.setFarming(true);
        });
    }

    protected void stop(ServerLevel level, IRobotEntity robot, long gameTime) {
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get());
        robot.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.targetPos = null;
        robot.setFarming(false);
    }

    protected void tick(ServerLevel level, IRobotEntity robot, long gameTime) {
        if (this.targetPos == null) {
            this.doStop(level, (LivingEntity)robot, gameTime);
            return;
        }
        ++this.ticksSinceStarted;
        if (this.ticksSinceStarted < (Integer)IRobotConfig.HARVEST_CROP_DELAY_TICKS.get()) {
            return;
        }
        BlockState cropState = level.getBlockState(this.targetPos);
        if (CropUtils.isMature(cropState)) {
            Optional<Item> seedItemOpt = CropUtils.getSeedFromCrop(cropState);
            robot.swing(InteractionHand.MAIN_HAND);
            level.destroyBlock(this.targetPos, true, (Entity)robot);
            robot.setEnergy(robot.getEnergy() - (Double)IRobotConfig.FARMING_ENERGY_COST_PER_HARVEST.get() * robot.getEnergyConsumptionModifier());
            if (robot.hasModule(ModuleItem.ModuleType.CROP_REPLANT)) {
                seedItemOpt.ifPresent(seedItem -> {
                    if (this.tryReplant(level, robot, this.targetPos, (Item)seedItem)) {
                        robot.swing(InteractionHand.MAIN_HAND);
                        robot.setEnergy(robot.getEnergy() - (Double)IRobotConfig.FARMING_ENERGY_COST_PER_REPLANT.get() * robot.getEnergyConsumptionModifier());
                    }
                });
            }
        } else if (cropState.isAir() && (level.getBlockState(this.targetPos.below()).is(Blocks.FARMLAND) || level.getBlockState(this.targetPos.below()).is(Blocks.SOUL_SAND)) && robot.hasModule(ModuleItem.ModuleType.CROP_REPLANT)) {
            Optional<Item> seedToPlant = this.findSeedInInventory(robot, level, this.targetPos);
            seedToPlant.ifPresent(seedItem -> {
                if (this.tryReplant(level, robot, this.targetPos, (Item)seedItem)) {
                    robot.swing(InteractionHand.MAIN_HAND);
                    robot.setEnergy(robot.getEnergy() - (Double)IRobotConfig.FARMING_ENERGY_COST_PER_REPLANT.get() * robot.getEnergyConsumptionModifier());
                }
            });
        }
        this.doStop(level, (LivingEntity)robot, gameTime);
    }

    private Optional<Item> findSeedInInventory(IRobotEntity robot, ServerLevel level, BlockPos plantPos) {
        for (int i = 0; i < robot.getInventory().getContainerSize(); ++i) {
            Item item;
            ItemStack stack = robot.getInventory().getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            if (!CropUtils.isPlantable(stack.getItem()) || !blockItem.getBlock().defaultBlockState().canSurvive((LevelReader)level, plantPos)) continue;
            return Optional.of(stack.getItem());
        }
        return Optional.empty();
    }

    private boolean tryReplant(ServerLevel level, IRobotEntity robot, BlockPos pos, Item seedItem) {
        BlockState seedState;
        if (!(seedItem instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)seedItem;
        int seedSlot = -1;
        for (int i = 0; i < robot.getInventory().getContainerSize(); ++i) {
            if (!robot.getInventory().getItem(i).is(seedItem)) continue;
            seedSlot = i;
            break;
        }
        if (seedSlot == -1) {
            return false;
        }
        if (level.getBlockState(pos).isAir() && (seedState = blockItem.getBlock().defaultBlockState()).canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, seedState, 3);
            robot.getInventory().getItem(seedSlot).shrink(1);
            return true;
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel level, IRobotEntity robot, long gameTime) {
        if (this.targetPos == null) {
            return false;
        }
        Optional farmPos = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get());
        if (farmPos.isEmpty() || !((GlobalPos)farmPos.get()).pos().equals((Object)this.targetPos)) {
            return false;
        }
        BlockState targetState = level.getBlockState(this.targetPos);
        BlockState groundState = level.getBlockState(this.targetPos.below());
        boolean isMatureCrop = CropUtils.isMature(targetState);
        boolean isEmptyFarmland = targetState.isAir() && (groundState.is(Blocks.FARMLAND) || groundState.is(Blocks.SOUL_SAND));
        return isMatureCrop || isEmptyFarmland;
    }
}

