/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.idle;

import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.item.data.TaskDataComponent;
import com.daqem.irobot.item.data.TaskMarkerDataComponent;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class GoToTaskActivity
extends Behavior<IRobotEntity> {
    public GoToTaskActivity() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, IRobotEntity owner) {
        return owner.hasTaskItem();
    }

    protected void start(ServerLevel level, IRobotEntity robot, long gameTime) {
        TaskDataComponent taskData = robot.getTaskItemData();
        TaskMarkerDataComponent markerData = robot.getTaskMarkerData();
        if (!(taskData == null || taskData.task().requiresArea() && markerData == null)) {
            robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get(), (Object)taskData.task());
            if (taskData.task().requiresArea()) {
                robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get(), (Object)markerData.firstPos());
                robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get(), (Object)markerData.secondPos());
            }
            robot.getBrain().setActiveActivityIfPossible(taskData.task().getActivity());
        }
    }
}

