/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.mining;

import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.task.RobotTask;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FindNextBlockToMine
extends Behavior<IRobotEntity> {
    private static final int SCAN_STEP_SIZE = 1;
    private static final int LANE_WIDTH = 3;

    public FindNextBlockToMine() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.MINE_TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, IRobotEntity robot) {
        return robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()).orElse(null) == RobotTask.MINING;
    }

    protected void start(ServerLevel level, IRobotEntity robot, long gameTime) {
        Optional<BlockPos> nearestBlock;
        Vec3 closestPoint;
        Optional startPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        Optional endPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        if (startPosOpt.isEmpty() || endPosOpt.isEmpty()) {
            return;
        }
        AABB miningArea = OutlineRenderer.createBoundingBox(((GlobalPos)startPosOpt.get()).pos(), ((GlobalPos)endPosOpt.get()).pos());
        if (!miningArea.inflate(1.0).contains(robot.position()) && !level.getBlockState(BlockPos.containing((Position)(closestPoint = this.getClosestPointInAABB(robot.position(), miningArea))).below()).isAir()) {
            robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(closestPoint, 0.5f, 0));
            return;
        }
        Direction miningDir = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINING_DIRECTION.get()).orElse(Direction.EAST);
        if (!robot.getBrain().hasMemoryValue((MemoryModuleType)IRobotMemoryModuleTypes.MINING_DIRECTION.get())) {
            robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINING_DIRECTION.get(), (Object)miningDir);
        }
        if (!robot.getBrain().hasMemoryValue((MemoryModuleType)IRobotMemoryModuleTypes.LANE_DIRECTION.get())) {
            robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.LANE_DIRECTION.get(), (Object)miningDir.getClockWise());
        }
        if ((nearestBlock = this.findNearestBlock(level, robot, miningArea)).isPresent()) {
            BlockPos targetPos = nearestBlock.get();
            robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINE_TARGET_POS.get(), (Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)targetPos));
            robot.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(targetPos));
            if (!robot.blockPosition().closerThan((Vec3i)targetPos, 2.0)) {
                robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(targetPos, 0.5f, 2));
            }
        } else {
            this.findNextMiningFace(level, robot, miningArea, gameTime);
        }
    }

    private Optional<BlockPos> findNearestBlock(ServerLevel level, IRobotEntity robot, AABB miningArea) {
        BlockPos robotBlockPos = robot.blockPosition();
        AABB aroundRobot = new AABB(robotBlockPos).inflate(3.0, 2.0, 3.0);
        AABB searchBox = aroundRobot.intersect(miningArea);
        HashMap<Integer, List> positions = new HashMap<Integer, List>();
        for (int y = Mth.floor((double)searchBox.minY); y <= Mth.floor((double)searchBox.maxY); ++y) {
            for (int x = Mth.floor((double)searchBox.minX); x <= Mth.floor((double)searchBox.maxX); ++x) {
                for (int z = Mth.floor((double)searchBox.minZ); z <= Mth.floor((double)searchBox.maxZ); ++z) {
                    positions.computeIfAbsent(y, k -> new ArrayList()).add(new BlockPos(x, y, z));
                }
            }
        }
        positions.values().forEach(list -> list.sort(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)robotBlockPos))));
        for (Integer y : positions.keySet().stream().sorted(Comparator.reverseOrder()).toList()) {
            for (BlockPos pos : (List)positions.get(y)) {
                if (level.getBlockState(pos).isAir() || level.isOutsideBuildHeight(pos)) continue;
                return Optional.of(pos);
            }
        }
        return Optional.empty();
    }

    private void findNextMiningFace(ServerLevel level, IRobotEntity robot, AABB miningArea, long gameTime) {
        Direction miningDir = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINING_DIRECTION.get()).orElse(Direction.EAST);
        BlockPos robotPos = robot.blockPosition();
        for (int i = 0; i < (int)Math.max(miningArea.getXsize(), miningArea.getZsize()); ++i) {
            BlockPos scanPos = robotPos.relative(miningDir, i);
            Optional<BlockPos> target = this.findWalkablePosNear(level, scanPos, miningArea);
            if (!target.isPresent()) continue;
            robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(target.get(), 0.5f, 0));
            return;
        }
        Optional laneDirOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.LANE_DIRECTION.get());
        if (laneDirOpt.isEmpty()) {
            this.finishMiningTask(robot);
            return;
        }
        Direction laneDir = (Direction)laneDirOpt.get();
        BlockPos nextLanePos = robotPos.relative(laneDir, 3);
        if (miningArea.contains(Vec3.atCenterOf((Vec3i)nextLanePos))) {
            Direction newMiningDir = miningDir.getOpposite();
            robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINING_DIRECTION.get(), (Object)newMiningDir);
            robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(nextLanePos, 0.5f, 0));
        } else {
            this.lastResortSearch(level, robot, miningArea);
        }
    }

    private Optional<BlockPos> findWalkablePosNear(ServerLevel level, BlockPos targetPos, AABB miningArea) {
        for (int y = Mth.floor((double)miningArea.maxY); y >= Mth.floor((double)miningArea.minY); --y) {
            BlockPos currentPos = new BlockPos(targetPos.getX(), y, targetPos.getZ());
            if (!miningArea.contains(Vec3.atCenterOf((Vec3i)currentPos)) || level.getBlockState(currentPos).isAir()) continue;
            BlockPos groundPos = currentPos.below();
            while (groundPos.getY() >= Mth.floor((double)miningArea.minY)) {
                if (level.getBlockState(groundPos).isSolidRender() && level.getBlockState(groundPos.above()).isAir()) {
                    return Optional.of(groundPos.above());
                }
                groundPos = groundPos.below();
            }
        }
        return Optional.empty();
    }

    private void lastResortSearch(ServerLevel level, IRobotEntity robot, AABB miningArea) {
        BlockPos robotPos = robot.blockPosition();
        AABB searchBox = new AABB(robotPos).inflate(50.0, 5.0, 50.0).intersect(miningArea);
        PathNavigation navigator = robot.getNavigation();
        for (int y = Mth.floor((double)searchBox.maxY); y >= Mth.floor((double)searchBox.minY); --y) {
            for (int x = Mth.floor((double)searchBox.minX); x <= Mth.floor((double)searchBox.maxX); ++x) {
                for (int z = Mth.floor((double)searchBox.minZ); z <= Mth.floor((double)searchBox.maxZ); ++z) {
                    Path path;
                    BlockPos walkToTarget;
                    BlockPos potentialTarget = new BlockPos(x, y, z);
                    if (level.getBlockState(potentialTarget).isAir() || !level.getBlockState(walkToTarget = potentialTarget.above()).isAir() || (path = navigator.createPath(walkToTarget, 1)) == null || !path.canReach()) continue;
                    robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(walkToTarget, 0.5f, 0));
                    return;
                }
            }
        }
        this.finishMiningTask(robot);
    }

    private void finishMiningTask(IRobotEntity robot) {
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINE_TARGET_POS.get());
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get());
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINING_DIRECTION.get());
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.LANE_DIRECTION.get());
        robot.getBrain().setActiveActivityIfPossible(Activity.IDLE);
    }

    private Vec3 getClosestPointInAABB(Vec3 point, AABB box) {
        double x = Mth.clamp((double)point.x, (double)box.minX, (double)box.maxX);
        double y = Mth.clamp((double)point.y, (double)box.minY, (double)box.maxY);
        double z = Mth.clamp((double)point.z, (double)box.minZ, (double)box.maxZ);
        return new Vec3(x, y, z);
    }
}

