/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.panic;

import com.daqem.irobot.entity.IRobotEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class RobotCalmDown
extends Behavior<IRobotEntity> {
    private static final int CALM_DOWN_DURATION = 100;
    private long calmDownStartedAt;

    public RobotCalmDown() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.HURT_BY, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected void start(ServerLevel level, IRobotEntity robot, long gameTime) {
        this.calmDownStartedAt = gameTime;
    }

    protected void tick(ServerLevel level, IRobotEntity robot, long gameTime) {
        if (gameTime - this.calmDownStartedAt >= 100L) {
            this.doStop(level, (LivingEntity)robot, gameTime);
        }
    }

    protected void stop(ServerLevel level, IRobotEntity robot, long gameTime) {
        robot.getBrain().eraseMemory(MemoryModuleType.HURT_BY);
        robot.getBrain().eraseMemory(MemoryModuleType.HURT_BY_ENTITY);
        if (robot.getBrain().isActive(Activity.PANIC)) {
            robot.getBrain().updateActivityFromSchedule(level.getDayTime(), level.getGameTime());
        }
    }

    protected boolean canStillUse(ServerLevel level, IRobotEntity robot, long gameTime) {
        return this.checkExtraStartConditions(level, (LivingEntity)robot) && robot.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
    }
}

