/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.panic;

import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotActivities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;

public class RobotPanicTrigger
extends Behavior<IRobotEntity> {
    public RobotPanicTrigger() {
        super((Map)ImmutableMap.of());
    }

    public static boolean isHurt(LivingEntity entity) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
    }

    private boolean isDoingCombatTask(IRobotEntity robot) {
        Optional activity = robot.getBrain().getActiveNonCoreActivity();
        if (activity.isEmpty()) {
            return false;
        }
        Activity currentActivity = (Activity)activity.get();
        return currentActivity.equals(IRobotActivities.PROTECT.get()) || currentActivity.equals(IRobotActivities.FOLLOW.get());
    }

    protected boolean checkExtraStartConditions(ServerLevel level, IRobotEntity owner) {
        return RobotPanicTrigger.isHurt((LivingEntity)owner) && !this.isDoingCombatTask(owner);
    }

    protected boolean canStillUse(ServerLevel level, IRobotEntity entity, long gameTime) {
        return RobotPanicTrigger.isHurt((LivingEntity)entity);
    }

    protected void start(ServerLevel level, IRobotEntity entity, long gameTime) {
        if (RobotPanicTrigger.isHurt((LivingEntity)entity)) {
            Brain<IRobotEntity> brain = entity.getBrain();
            if (!brain.isActive(Activity.PANIC)) {
                brain.eraseMemory(MemoryModuleType.PATH);
                brain.eraseMemory(MemoryModuleType.WALK_TARGET);
                brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
                brain.eraseMemory(MemoryModuleType.BREED_TARGET);
                brain.eraseMemory(MemoryModuleType.INTERACTION_TARGET);
            }
            brain.setActiveActivityIfPossible(Activity.PANIC);
        }
    }
}

