/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.protecting;

import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.phys.AABB;

public class FindHostileMobInArea
extends Behavior<IRobotEntity> {
    public FindHostileMobInArea() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected void start(ServerLevel level, IRobotEntity robot, long gameTime) {
        Optional startPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        Optional endPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        if (startPosOpt.isEmpty() || endPosOpt.isEmpty()) {
            return;
        }
        AABB protectionArea = OutlineRenderer.createBoundingBox(((GlobalPos)startPosOpt.get()).pos(), ((GlobalPos)endPosOpt.get()).pos());
        this.findNearestHostileMob(level, robot, protectionArea).ifPresent(target -> {
            Brain<IRobotEntity> brain = robot.getBrain();
            brain.setMemory(MemoryModuleType.ATTACK_TARGET, target);
        });
    }

    private Optional<LivingEntity> findNearestHostileMob(ServerLevel level, IRobotEntity robot, AABB protectionArea) {
        List hostilesInArea = level.getEntitiesOfClass(Monster.class, protectionArea, entity -> entity.isAlive() && robot.canAttack((LivingEntity)entity));
        if (hostilesInArea.isEmpty()) {
            return Optional.empty();
        }
        return hostilesInArea.stream().min(Comparator.comparingDouble(hostile -> hostile.distanceToSqr((Entity)robot))).map(monster -> monster);
    }
}

