/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.neoforge;

import com.daqem.irobot.block.entity.IRobotBlockEntities;
import com.daqem.irobot.client.IRobotClient;
import com.daqem.irobot.client.gui.robot.RobotScreen;
import com.daqem.irobot.client.gui.tasktable.TaskTableScreen;
import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.client.renderer.block.DropoffChestBlockEntityRenderer;
import com.daqem.irobot.client.renderer.block.RobotStationBlockEntityRenderer;
import com.daqem.irobot.client.renderer.block.TaskTableBlockEntityRenderer;
import com.daqem.irobot.menu.IRobotMenuTypes;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@Mod(value="irobot", dist={Dist.CLIENT})
@EventBusSubscriber
public class IRobotNeoForgeClient {
    public IRobotNeoForgeClient(IEventBus modEventBus, ModContainer modContainer) {
        IRobotClient.init();
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)IRobotBlockEntities.ROBOT_STATION.get(), RobotStationBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)IRobotBlockEntities.TASK_TABLE.get(), TaskTableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)IRobotBlockEntities.DROPOFF_CHEST.get(), DropoffChestBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)IRobotMenuTypes.ROBOT_MENU.get(), RobotScreen::new);
        event.register((MenuType)IRobotMenuTypes.TASK_TABLE_MENU.get(), TaskTableScreen::new);
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent.AfterParticles event) {
        OutlineRenderer.renderOutline(event.getPoseStack());
    }
}

