/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CropUtils {
    private static final Map<Block, Item> CROP_TO_SEED_MAP = new HashMap<Block, Item>();
    private static final Set<Item> PLANTABLE_ITEMS = new HashSet<Item>();

    public static boolean isFarmableCrop(BlockState blockState) {
        return blockState.getBlock() instanceof CropBlock || blockState.is(Blocks.NETHER_WART);
    }

    public static boolean isMature(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.isMaxAge(blockState);
        }
        if (blockState.is(Blocks.NETHER_WART)) {
            return (Integer)blockState.getValue((Property)NetherWartBlock.AGE) >= 3;
        }
        return false;
    }

    public static Optional<Item> getSeedFromCrop(BlockState cropState) {
        return Optional.ofNullable(CROP_TO_SEED_MAP.get(cropState.getBlock()));
    }

    public static boolean isPlantable(Item item) {
        return PLANTABLE_ITEMS.contains(item);
    }

    static {
        CROP_TO_SEED_MAP.put(Blocks.WHEAT, Items.WHEAT_SEEDS);
        CROP_TO_SEED_MAP.put(Blocks.CARROTS, Items.CARROT);
        CROP_TO_SEED_MAP.put(Blocks.POTATOES, Items.POTATO);
        CROP_TO_SEED_MAP.put(Blocks.BEETROOTS, Items.BEETROOT_SEEDS);
        CROP_TO_SEED_MAP.put(Blocks.NETHER_WART, Items.NETHER_WART);
        PLANTABLE_ITEMS.addAll(CROP_TO_SEED_MAP.values());
    }
}

