/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.farming;

import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.item.module.ModuleItem;
import com.daqem.irobot.util.CropUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_4538;

public class HarvestAndReplantCrop
extends class_4097<IRobotEntity> {
    private int ticksSinceStarted;
    private class_2338 targetPos;

    public HarvestAndReplantCrop() {
        super((Map)ImmutableMap.of((Object)((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get()), (Object)class_4141.field_18456, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    protected boolean checkExtraStartConditions(class_3218 level, IRobotEntity robot) {
        Optional farmPos = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get());
        boolean hasPos = farmPos.isPresent();
        if (hasPos) {
            boolean isCloseEnough = ((class_4208)farmPos.get()).comp_2208().method_19771((class_2382)robot.method_24515(), 2.0);
            if (!isCloseEnough) {
                robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get());
            }
            return isCloseEnough;
        }
        return false;
    }

    protected void start(class_3218 level, IRobotEntity robot, long gameTime) {
        this.ticksSinceStarted = 0;
        robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get()).ifPresent(globalPos -> {
            this.targetPos = globalPos.comp_2208();
            robot.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.targetPos));
            robot.setFarming(true);
        });
    }

    protected void stop(class_3218 level, IRobotEntity robot, long gameTime) {
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get());
        robot.method_18868().method_18875(class_4140.field_18446);
        this.targetPos = null;
        robot.setFarming(false);
    }

    protected void tick(class_3218 level, IRobotEntity robot, long gameTime) {
        if (this.targetPos == null) {
            this.method_18925(level, (class_1309)robot, gameTime);
            return;
        }
        ++this.ticksSinceStarted;
        if (this.ticksSinceStarted < (Integer)IRobotConfig.HARVEST_CROP_DELAY_TICKS.get()) {
            return;
        }
        class_2680 cropState = level.method_8320(this.targetPos);
        if (CropUtils.isMature(cropState)) {
            Optional<class_1792> seedItemOpt = CropUtils.getSeedFromCrop(cropState);
            robot.method_6104(class_1268.field_5808);
            level.method_8651(this.targetPos, true, (class_1297)robot);
            robot.setEnergy(robot.getEnergy() - (Double)IRobotConfig.FARMING_ENERGY_COST_PER_HARVEST.get() * robot.getEnergyConsumptionModifier());
            if (robot.hasModule(ModuleItem.ModuleType.CROP_REPLANT)) {
                seedItemOpt.ifPresent(seedItem -> {
                    if (this.tryReplant(level, robot, this.targetPos, (class_1792)seedItem)) {
                        robot.method_6104(class_1268.field_5808);
                        robot.setEnergy(robot.getEnergy() - (Double)IRobotConfig.FARMING_ENERGY_COST_PER_REPLANT.get() * robot.getEnergyConsumptionModifier());
                    }
                });
            }
        } else if (cropState.method_26215() && (level.method_8320(this.targetPos.method_10074()).method_27852(class_2246.field_10362) || level.method_8320(this.targetPos.method_10074()).method_27852(class_2246.field_10114)) && robot.hasModule(ModuleItem.ModuleType.CROP_REPLANT)) {
            Optional<class_1792> seedToPlant = this.findSeedInInventory(robot, level, this.targetPos);
            seedToPlant.ifPresent(seedItem -> {
                if (this.tryReplant(level, robot, this.targetPos, (class_1792)seedItem)) {
                    robot.method_6104(class_1268.field_5808);
                    robot.setEnergy(robot.getEnergy() - (Double)IRobotConfig.FARMING_ENERGY_COST_PER_REPLANT.get() * robot.getEnergyConsumptionModifier());
                }
            });
        }
        this.method_18925(level, (class_1309)robot, gameTime);
    }

    private Optional<class_1792> findSeedInInventory(IRobotEntity robot, class_3218 level, class_2338 plantPos) {
        for (int i = 0; i < robot.getInventory().method_5439(); ++i) {
            class_1792 class_17922;
            class_1799 stack = robot.getInventory().method_5438(i);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof class_1747)) continue;
            class_1747 blockItem = (class_1747)class_17922;
            if (!CropUtils.isPlantable(stack.method_7909()) || !blockItem.method_7711().method_9564().method_26184((class_4538)level, plantPos)) continue;
            return Optional.of(stack.method_7909());
        }
        return Optional.empty();
    }

    private boolean tryReplant(class_3218 level, IRobotEntity robot, class_2338 pos, class_1792 seedItem) {
        class_2680 seedState;
        if (!(seedItem instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)seedItem;
        int seedSlot = -1;
        for (int i = 0; i < robot.getInventory().method_5439(); ++i) {
            if (!robot.getInventory().method_5438(i).method_31574(seedItem)) continue;
            seedSlot = i;
            break;
        }
        if (seedSlot == -1) {
            return false;
        }
        if (level.method_8320(pos).method_26215() && (seedState = blockItem.method_7711().method_9564()).method_26184((class_4538)level, pos)) {
            level.method_8652(pos, seedState, 3);
            robot.getInventory().method_5438(seedSlot).method_7934(1);
            return true;
        }
        return false;
    }

    protected boolean canStillUse(class_3218 level, IRobotEntity robot, long gameTime) {
        if (this.targetPos == null) {
            return false;
        }
        Optional farmPos = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get());
        if (farmPos.isEmpty() || !((class_4208)farmPos.get()).comp_2208().equals((Object)this.targetPos)) {
            return false;
        }
        class_2680 targetState = level.method_8320(this.targetPos);
        class_2680 groundState = level.method_8320(this.targetPos.method_10074());
        boolean isMatureCrop = CropUtils.isMature(targetState);
        boolean isEmptyFarmland = targetState.method_26215() && (groundState.method_27852(class_2246.field_10362) || groundState.method_27852(class_2246.field_10114));
        return isMatureCrop || isEmptyFarmland;
    }
}

