/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.skilltree;

import com.daqem.uilib.api.skilltree.ISkillTree;
import com.daqem.uilib.api.skilltree.ISkillTreeItem;
import com.daqem.uilib.api.widget.skilltree.ISkillTreeItemWidget;
import com.daqem.uilib.gui.component.EmptyComponent;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_332;
import net.minecraft.class_8021;

public class SkillTreeMovingComponent
extends EmptyComponent {
    private final ISkillTree skillTree;
    private final List<ISkillTreeItemWidget> itemWidgets;
    private final Map<ISkillTreeItem, ISkillTreeItemWidget> itemWidgetsMap;

    public SkillTreeMovingComponent(ISkillTree skillTree) {
        super(0, 0, 0, 0);
        this.skillTree = skillTree;
        this.itemWidgets = skillTree.getItems().stream().map(item -> {
            ISkillTreeItemWidget itemWidget = item.createWidget();
            itemWidget.method_46421((int)((float)skillTree.getHorizontalMargin() + item.getX() * (float)(skillTree.getSkillTreeItemWidth() + skillTree.getHorizontalSpacing())));
            itemWidget.method_46419((int)((float)skillTree.getVerticalMargin() + item.getY() * (float)(skillTree.getSkillTreeItemHeight() + skillTree.getVerticalSpacing())));
            return itemWidget;
        }).toList();
        this.itemWidgetsMap = this.itemWidgets.stream().collect(Collectors.toMap(ISkillTreeItemWidget::getSkillTreeItem, item -> item));
        this.setWidth(this.itemWidgets.stream().mapToInt(class_8021::method_46426).max().orElse(0) + skillTree.getSkillTreeItemWidth() + skillTree.getHorizontalMargin());
        this.setHeight(this.itemWidgets.stream().mapToInt(class_8021::method_46427).max().orElse(0) + skillTree.getSkillTreeItemHeight() + skillTree.getVerticalMargin());
        this.addWidgets(this.itemWidgets);
    }

    public void setXOffset(int xOffset) {
        for (ISkillTreeItemWidget itemWidget : this.itemWidgets) {
            itemWidget.method_46421(itemWidget.method_46426() + xOffset);
        }
    }

    public void setYOffset(int yOffset) {
        for (ISkillTreeItemWidget itemWidget : this.itemWidgets) {
            itemWidget.method_46419(itemWidget.method_46427() + yOffset);
        }
    }

    @Override
    public void renderBase(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        this.renderConnections(guiGraphics);
        super.renderBase(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
    }

    public void renderTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
        for (ISkillTreeItemWidget itemWidget : this.itemWidgets) {
            if (!itemWidget.method_25405(mouseX, mouseY)) continue;
            itemWidget.renderTooltips(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderConnections(class_332 guiGraphics) {
        for (ISkillTreeItemWidget itemWidget : this.itemWidgets) {
            if (itemWidget.getSkillTreeItem() == this.skillTree.getRoot()) continue;
            ISkillTreeItemWidget parent = this.itemWidgetsMap.get(itemWidget.getSkillTreeItem().getParent());
            int parentX = parent.method_46426() + parent.method_25368() / 2;
            int parentY = parent.method_46427() + parent.method_25364() / 2;
            int childX = itemWidget.method_46426() + itemWidget.method_25368() / 2;
            int childY = itemWidget.method_46427() + itemWidget.method_25364() / 2;
            if (parentY == childY) {
                guiGraphics.method_51738(parentX, childX, parentY - 1, -16777216);
                guiGraphics.method_51738(parentX, childX, parentY + 1, -16777216);
                guiGraphics.method_51738(parentX, childX, parentY, -1);
                continue;
            }
            int midX = (parentX + childX) / 2;
            guiGraphics.method_25294(parentX, parentY - 1, midX, parentY + 2, -16777216);
            guiGraphics.method_25294(midX - 1, parentY, midX + 2, childY, -16777216);
            guiGraphics.method_25294(midX - 1, childY - 1, childX + 1, childY + 2, -16777216);
            guiGraphics.method_51738(parentX, midX, parentY, -1);
            guiGraphics.method_51742(midX, parentY, childY, -1);
            guiGraphics.method_51738(midX, childX, childY, -1);
        }
    }
}

