/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.text.multiline;

import com.daqem.uilib.gui.component.text.AbstractTextComponent;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5225;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMultiLineTextComponent
extends AbstractTextComponent {
    private int maxWidth;
    private List<class_5481> lines;

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, class_2561 text) {
        super(x, y, 0, 0, text);
        this.maxWidth = maxWidth;
        this.updateSize();
    }

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, class_2561 text, int color) {
        super(x, y, 0, 0, text, color);
        this.maxWidth = maxWidth;
        this.updateSize();
    }

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, class_2561 text, boolean preformSizeUpdate) {
        super(x, y, 0, 0, text);
        this.maxWidth = maxWidth;
        if (preformSizeUpdate) {
            this.updateSize();
        }
    }

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, class_2561 text, int color, boolean preformSizeUpdate) {
        super(x, y, 0, 0, text, color);
        this.maxWidth = maxWidth;
        if (preformSizeUpdate) {
            this.updateSize();
        }
    }

    public List<class_5481> getLines() {
        return this.lines;
    }

    public void setLines(List<class_5481> lines) {
        this.lines = lines;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.updateSize();
    }

    protected void updateSize() {
        this.lines = class_2477.method_10517().method_30933(AbstractMultiLineTextComponent.findOptimalLines(this.getFont(), this.getText(), this.maxWidth));
        this.setWidth(this.lines.stream().mapToInt(arg_0 -> ((class_327)this.getFont()).method_30880(arg_0)).max().orElse(0));
        Objects.requireNonNull(this.getFont());
        this.setHeight(9 * this.getLines().size());
    }

    protected int getUnusedSpaceX() {
        switch (this.getTextAlign()) {
            case CENTER: {
                return (this.method_25368() - this.getMaxWidth()) / 2;
            }
            case RIGHT: {
                return this.method_25368() - this.getMaxWidth();
            }
        }
        return 0;
    }

    protected static List<class_5348> findOptimalLines(class_327 font, class_2561 component, int width) {
        class_5225 stringSplitter = font.method_27527();
        List optimalLines = null;
        float minDifference = Float.MAX_VALUE;
        float tolerance = 10.0f;
        int offset = 0;
        List lines = stringSplitter.method_27495((class_5348)component, width - offset, class_2583.field_24360);
        float difference = Math.abs(AbstractMultiLineTextComponent.getMaxWidth(stringSplitter, lines) - (float)width);
        if (difference <= tolerance) {
            return lines;
        }
        if (difference < minDifference) {
            optimalLines = lines;
        }
        return optimalLines;
    }

    private static float getMaxWidth(@NotNull class_5225 stringSplitter, List<class_5348> formattedTexts) {
        return (float)formattedTexts.stream().mapToDouble(arg_0 -> ((class_5225)stringSplitter).method_27488(arg_0)).max().orElse(0.0);
    }
}

