/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.widget;

import com.daqem.uilib.api.IParent;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.widget.IWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8021;
import net.minecraft.class_8028;
import net.minecraft.class_8030;
import net.minecraft.class_9017;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollContainerWidget
extends class_9017
implements IWidget,
IParent {
    private final List<IComponent> components = new ArrayList<IComponent>();
    private final int contentSpacing;

    public ScrollContainerWidget(int width, int height, int contentSpacing) {
        super(0, 0, width, height, (class_2561)class_2561.method_43473());
        this.contentSpacing = contentSpacing;
    }

    public ScrollContainerWidget(int width, int height) {
        this(width, height, 0);
    }

    protected int method_44395() {
        if (this.components.isEmpty()) {
            return 0;
        }
        return this.components.stream().mapToInt(class_8021::method_25364).sum() + this.getContentSpacing() * (this.components.size() - 1);
    }

    protected double method_44393() {
        return 10.0;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
        int currentY = this.uilib$getParentY() - this.method_46427() - (int)this.method_44387();
        for (int i = 0; i < this.components.size(); ++i) {
            IComponent component = this.components.get(i);
            component.method_46419(currentY);
            component.renderBase(guiGraphics, mouseX, mouseY, partialTick, this.field_22758, this.field_22759);
            currentY += component.method_25364();
            if (i >= this.components.size() - 1) continue;
            currentY += this.getContentSpacing();
        }
        guiGraphics.method_44380();
        this.method_44396(guiGraphics);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    @NotNull
    public class_8030 method_65515(class_8028 direction) {
        return new class_8030(this.method_46426(), this.method_46427(), this.field_22758, this.method_44395());
    }

    public void method_25395(@Nullable class_364 focused) {
        super.method_25395(focused);
        if (focused != null && class_310.method_1551().method_48186().method_48183()) {
            class_8030 screenRectangle = this.method_48202();
            class_8030 screenRectangle2 = focused.method_48202();
            int i = screenRectangle2.method_49618() - screenRectangle.method_49618();
            int j = screenRectangle2.method_49619() - screenRectangle.method_49619();
            if (i < 0) {
                this.method_44382(this.method_44387() + (double)i - 14.0);
            } else if (j > 0) {
                this.method_44382(this.method_44387() + (double)j + 14.0);
            }
        }
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.getWidgets();
    }

    @NotNull
    public Collection<? extends class_6379> method_65516() {
        return this.getWidgets();
    }

    @Override
    public List<IComponent> getComponents() {
        return this.components;
    }

    @Override
    public void addComponent(IComponent component) {
        this.components.add(component);
    }

    @Override
    public void addComponents(List<? extends IComponent> components) {
        this.components.addAll(components);
    }

    @Override
    public void removeComponent(IComponent component) {
        this.components.remove(component);
    }

    @Override
    public void removeComponents(List<? extends IComponent> components) {
        this.components.removeAll(components);
    }

    @Override
    public void clearComponents() {
        this.components.clear();
    }

    @Override
    public void clear() {
        this.clearComponents();
        this.clearOnlyWidgets();
    }

    @Override
    public List<IWidget> getWidgets() {
        return this.components.stream().flatMap(component -> component.getAllWidgets().stream()).toList();
    }

    @Override
    public void addWidget(IWidget widget) {
        throw new UnsupportedOperationException("Cannot add a widget directly to ScrollContainerWidget. Add it to a component instead.");
    }

    @Override
    public void addWidgets(List<? extends IWidget> widgets) {
        throw new UnsupportedOperationException("Cannot add widgets directly to ScrollContainerWidget. Add them to a component instead.");
    }

    @Override
    public void removeWidget(IWidget widget) {
        throw new UnsupportedOperationException("Cannot remove a widget directly from ScrollContainerWidget. Remove it from a component instead.");
    }

    @Override
    public void removeWidgets(List<? extends IWidget> widgets) {
        throw new UnsupportedOperationException("Cannot remove widgets directly from ScrollContainerWidget. Remove them from a component instead.");
    }

    @Override
    public void clearOnlyWidgets() {
        throw new UnsupportedOperationException("Cannot clear widgets directly from ScrollContainerWidget. Clear them from components instead.");
    }

    public int getContentSpacing() {
        return this.contentSpacing;
    }
}

