/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component;

import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.component.AbstractComponent;
import com.daqem.uilib.gui.component.text.TruncatedTextComponent;
import com.daqem.uilib.gui.widget.ButtonWidget;
import com.daqem.yamlconfig.YamlConfig;
import com.daqem.yamlconfig.api.config.ConfigType;
import com.daqem.yamlconfig.api.config.IConfig;
import com.daqem.yamlconfig.client.gui.screen.ConfigScreen;
import com.daqem.yamlconfig.networking.c2s.ServerboundOpenConfigScreenPacket;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_8710;

public class ConfigsCategoryComponent
extends AbstractComponent {
    private static final int WIDTH = 300;
    private static final int TOP_MARGIN = 12;
    private static final int TITLE_HEIGHT = 10;
    private final List<IConfig> configs;
    private final class_327 font;
    private final TruncatedTextComponent title;
    private final List<ButtonWidget> configButtons;

    public ConfigsCategoryComponent(int x, int y, class_327 font, List<IConfig> configs) {
        super(x, y, 300, ConfigsCategoryComponent.calculateHeight(configs));
        this.configs = configs;
        this.font = font;
        if (configs.isEmpty()) {
            throw new IllegalArgumentException("Configs list cannot be empty");
        }
        IConfig firstConfig = configs.getFirst();
        this.title = new TruncatedTextComponent(4, 12, 300, firstConfig.getModName());
        this.configButtons = configs.stream().map(config -> new ButtonWidget(0, 0, 144, 20, config.getDisplayName(), button -> {
            ConfigType type = config.getType();
            switch (type) {
                case CLIENT: {
                    class_310.method_1551().method_1507((class_437)new ConfigScreen(class_310.method_1551().field_1755, YamlConfig.CONFIG_MANAGER.getConfig(config.getModId(), config.getName())));
                    break;
                }
                case COMMON: 
                case SERVER: {
                    NetworkManager.sendToServer((class_8710)new ServerboundOpenConfigScreenPacket(config.getModId(), config.getName()));
                }
            }
        })).toList();
        this.addComponent((IComponent)this.title);
        this.configButtons.forEach(arg_0 -> ((ConfigsCategoryComponent)this).addWidget(arg_0));
    }

    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        guiGraphics.method_25294(this.getTotalX(), this.getTotalY() + 12 + 10, this.getTotalX() + this.method_25368(), this.getTotalY() + 12 + 10 + 1, -1);
        this.configButtons.forEach(button -> {
            button.method_46421(3 + this.configButtons.indexOf(button) % 2 * 150);
            button.method_46419(25 + this.configButtons.indexOf(button) / 2 * 24);
        });
    }

    private static int calculateHeight(List<IConfig> configs) {
        float configsPerRow = 2.0f;
        int rowHeight = 24;
        int rows = (int)Math.ceil((float)configs.size() / configsPerRow);
        return 22 + rows * rowHeight;
    }
}

