/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.map;

import com.daqem.uilib.api.widget.IInputValidatable;
import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.widget.ButtonWidget;
import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.YamlConfig;
import com.daqem.yamlconfig.api.config.entry.map.IMapConfigEntry;
import com.daqem.yamlconfig.api.gui.component.IComponentValidator;
import com.daqem.yamlconfig.client.gui.component.CrossButtonComponent;
import com.daqem.yamlconfig.client.gui.component.entry.BaseConfigEntryComponent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3545;
import net.minecraft.class_4185;

public abstract class BaseMapConfigEntryComponent<C extends IMapConfigEntry<?>>
extends BaseConfigEntryComponent<C> {
    private static final int WIDTH = 290;
    protected final Map<class_3545<EditBoxWidget, EditBoxWidget>, CrossButtonComponent> editBoxWidgets;
    protected final ButtonWidget addEntryButton;
    protected final IComponentValidator validator;

    public BaseMapConfigEntryComponent(String key, C configEntry, IComponentValidator validator) {
        super(key, configEntry, 0, 0, BaseMapConfigEntryComponent.calculateInitialHeight(configEntry), 290);
        this.validator = validator;
        this.editBoxWidgets = this.createEditBoxWidgets(new ArrayList(new LinkedHashMap((Map)configEntry.get()).entrySet()));
        this.addEntryButton = this.createAddEntryButton();
        this.addWidgets(new ArrayList(this.editBoxWidgets.keySet().stream().flatMap(tuple -> Stream.of((EditBoxWidget)tuple.method_15442(), (EditBoxWidget)tuple.method_15441())).toList()));
        this.addWidgets(new ArrayList<CrossButtonComponent>(this.editBoxWidgets.values()));
        this.addWidget((IWidget)this.addEntryButton);
    }

    private static int calculateInitialHeight(IMapConfigEntry<?> configEntry) {
        int entryCount = ((Map)configEntry.get()).size();
        return 44 + entryCount * 24;
    }

    private ButtonWidget createAddEntryButton() {
        return new ButtonWidget(0, this.method_25364() - 20, 290, 20, (class_2561)YamlConfig.translatable("gui.add_entry"), this::handleAddEntryButtonClick);
    }

    private void handleAddEntryButtonClick(class_4185 clickedButton) {
        class_3545<EditBoxWidget, EditBoxWidget> newTextBoxes = this.createEditBoxWidgets(this.editBoxWidgets.size());
        CrossButtonComponent newCrossButton = this.createCrossButtonComponent(newTextBoxes);
        this.editBoxWidgets.put(newTextBoxes, newCrossButton);
        this.addWidget((IWidget)newTextBoxes.method_15442());
        this.addWidget((IWidget)newTextBoxes.method_15441());
        this.addWidget((IWidget)newCrossButton);
        this.adjustLayoutForNewEntry(clickedButton);
    }

    private class_3545<EditBoxWidget, EditBoxWidget> createEditBoxWidgets(int index) {
        return new class_3545((Object)this.createKeyEditBoxWidget(index), (Object)this.createValueEditBoxWidget(index));
    }

    private EditBoxWidget createKeyEditBoxWidget(int index) {
        return new EditBoxWidget(class_310.method_1551().field_1772, 0, index * 24 + 20 + 4, 136, 20, (class_2561)class_2561.method_43473()){

            public List<class_2561> validateInput(String input) {
                List errors = super.validateInput(input);
                if (BaseMapConfigEntryComponent.this.editBoxWidgets != null) {
                    List<String> currentKeys = BaseMapConfigEntryComponent.this.editBoxWidgets.keySet().stream().map(class_3545::method_15442).filter(EditBoxWidget2 -> EditBoxWidget2 != this).map(class_342::method_1882).toList();
                    if (currentKeys.contains(input)) {
                        errors.add(ValidationErrors.duplicateKey());
                        BaseMapConfigEntryComponent.this.editBoxWidgets.keySet().stream().map(class_3545::method_15442).filter(EditBoxWidget2 -> EditBoxWidget2 != this).filter(EditBoxWidget2 -> EditBoxWidget2.method_1882().equals(input)).forEach(EditBoxWidget2 -> {
                            EditBoxWidget2.setInputValidationErrors(new ArrayList(EditBoxWidget2.getInputValidationErrors()));
                            if (!EditBoxWidget2.getInputValidationErrors().contains(ValidationErrors.duplicateKey())) {
                                EditBoxWidget2.getInputValidationErrors().add(ValidationErrors.duplicateKey());
                            }
                        });
                    } else {
                        for (Map.Entry<class_3545<EditBoxWidget, EditBoxWidget>, CrossButtonComponent> entry : BaseMapConfigEntryComponent.this.editBoxWidgets.entrySet()) {
                            String key = ((EditBoxWidget)entry.getKey().method_15442()).method_1882();
                            List<String> duplicateKeys = BaseMapConfigEntryComponent.this.editBoxWidgets.keySet().stream().map(class_3545::method_15442).filter(EditBoxWidget2 -> EditBoxWidget2 != this).filter(EditBoxWidget2 -> EditBoxWidget2 != ((class_3545)entry.getKey()).method_15442()).map(class_342::method_1882).filter(value -> value.equals(key)).toList();
                            if (!duplicateKeys.isEmpty()) continue;
                            ((EditBoxWidget)entry.getKey().method_15442()).setInputValidationErrors(new ArrayList<class_2561>(((EditBoxWidget)entry.getKey().method_15442()).getInputValidationErrors().stream().filter(component -> !component.equals((Object)ValidationErrors.duplicateKey())).toList()));
                        }
                    }
                }
                if (input.isEmpty()) {
                    errors.add(ValidationErrors.emptyKey());
                }
                if (!input.matches("^[a-zA-Z0-9_-]+$")) {
                    errors.add(ValidationErrors.pattern((String)"^[a-zA-Z0-9_-]+$"));
                }
                return errors;
            }
        };
    }

    private EditBoxWidget createValueEditBoxWidget(int index) {
        return new EditBoxWidget(class_310.method_1551().field_1772, 140, index * 24 + 20 + 4, 150, 20, (class_2561)class_2561.method_43473()){

            public List<class_2561> validateInput(String input) {
                return BaseMapConfigEntryComponent.this.validator.validate(input);
            }
        };
    }

    private CrossButtonComponent createCrossButtonComponent(class_3545<EditBoxWidget, EditBoxWidget> editBoxWidgets) {
        return new CrossButtonComponent(297, ((EditBoxWidget)editBoxWidgets.method_15442()).method_46427() + 3, button -> this.handleRemoveEntryButtonClick(editBoxWidgets, (CrossButtonComponent)button));
    }

    private void handleRemoveEntryButtonClick(class_3545<EditBoxWidget, EditBoxWidget> editBoxWidgets, CrossButtonComponent crossButtonComponent) {
        this.removeEntry(editBoxWidgets, crossButtonComponent);
    }

    private void removeEntry(class_3545<EditBoxWidget, EditBoxWidget> editBoxWidgets, CrossButtonComponent crossButtonWidget) {
        this.removeWidget((IWidget)crossButtonWidget);
        this.removeWidget((IWidget)editBoxWidgets.method_15442());
        this.removeWidget((IWidget)editBoxWidgets.method_15441());
        this.editBoxWidgets.remove(editBoxWidgets);
        this.adjustLayoutForRemovedEntry();
    }

    private void adjustLayoutForNewEntry(class_4185 addEntryButton) {
        this.setHeight(this.method_25364() + 20 + 4);
        addEntryButton.method_46419(this.method_25364() - 20);
    }

    private void adjustLayoutForRemovedEntry() {
        this.setHeight(this.method_25364() - 20 - 4);
        this.addEntryButton.method_46419(this.method_25364() - 20);
        this.updateComponentPositions();
    }

    private void updateComponentPositions() {
        int index = 0;
        for (Map.Entry<class_3545<EditBoxWidget, EditBoxWidget>, CrossButtonComponent> entry : this.editBoxWidgets.entrySet()) {
            int yPosition = index * 24 + 20 + 4;
            ((EditBoxWidget)entry.getKey().method_15442()).method_46419(yPosition);
            ((EditBoxWidget)entry.getKey().method_15441()).method_46419(yPosition);
            entry.getValue().method_46419(yPosition + 3);
            ++index;
        }
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        super.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
        this.renderHorizontalLines(guiGraphics);
        this.addEntryButton.field_22763 = ((IMapConfigEntry)this.getConfigEntry()).getMaxLength() > this.editBoxWidgets.size();
        this.editBoxWidgets.values().forEach(crossButtonComponent -> {
            crossButtonComponent.field_22763 = ((IMapConfigEntry)this.getConfigEntry()).getMinLength() < this.editBoxWidgets.size();
        });
    }

    private void renderHorizontalLines(class_332 graphics) {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int lineYStart = 9 + 6;
        graphics.method_25294(this.getTotalX(), this.getTotalY() + lineYStart, this.getTotalX() + 290, this.getTotalY() + lineYStart + 1, -1);
    }

    @Override
    public boolean isOriginalValue() {
        List<String> currentKeyValues = this.editBoxWidgets.keySet().stream().map(class_3545::method_15442).map(class_342::method_1882).toList();
        List<String> originalKeyValues = ((Map)((IMapConfigEntry)this.getConfigEntry()).getDefaultValue()).keySet().stream().map(Object::toString).toList();
        List<String> currentValueValues = this.editBoxWidgets.keySet().stream().map(class_3545::method_15441).map(class_342::method_1882).toList();
        List<String> originalValueValues = ((Map)((IMapConfigEntry)this.getConfigEntry()).getDefaultValue()).values().stream().map(Object::toString).toList();
        return currentKeyValues.equals(originalKeyValues) && currentValueValues.equals(originalValueValues);
    }

    @Override
    public void resetValue() {
        this.clearEntries();
        this.editBoxWidgets.putAll(this.createEditBoxWidgets(new ArrayList(new LinkedHashMap((Map)((IMapConfigEntry)this.configEntry).getDefaultValue()).entrySet())));
        this.addWidgets(new ArrayList(this.editBoxWidgets.keySet().stream().flatMap(tuple -> Stream.of((EditBoxWidget)tuple.method_15442(), (EditBoxWidget)tuple.method_15441())).toList()));
        this.addWidgets(new ArrayList<CrossButtonComponent>(this.editBoxWidgets.values()));
        this.resetLayout();
    }

    private void clearEntries() {
        this.editBoxWidgets.keySet().stream().flatMap(tuple -> Stream.of((EditBoxWidget)tuple.method_15442(), (EditBoxWidget)tuple.method_15441())).forEach(arg_0 -> ((BaseMapConfigEntryComponent)this).removeWidget(arg_0));
        this.editBoxWidgets.values().forEach(arg_0 -> ((BaseMapConfigEntryComponent)this).removeWidget(arg_0));
        this.editBoxWidgets.clear();
    }

    private void resetLayout() {
        int newHeight = BaseMapConfigEntryComponent.calculateInitialHeight((IMapConfigEntry)this.getConfigEntry());
        this.setHeight(newHeight);
        this.addEntryButton.method_46419(newHeight - 20);
    }

    private Map<class_3545<EditBoxWidget, EditBoxWidget>, CrossButtonComponent> createEditBoxWidgets(List<Map.Entry<String, ?>> configValues) {
        LinkedHashMap<class_3545<EditBoxWidget, EditBoxWidget>, CrossButtonComponent> components = new LinkedHashMap<class_3545<EditBoxWidget, EditBoxWidget>, CrossButtonComponent>();
        for (int i = 0; i < configValues.size(); ++i) {
            EditBoxWidget keyTextBox = this.createKeyEditBoxWidget(i);
            EditBoxWidget valueTextBox = this.createValueEditBoxWidget(i);
            keyTextBox.method_1852(configValues.get(i).getKey());
            valueTextBox.method_1852(configValues.get(i).getValue().toString());
            class_3545 tuple = new class_3545((Object)keyTextBox, (Object)valueTextBox);
            CrossButtonComponent crossButton = this.createCrossButtonComponent((class_3545<EditBoxWidget, EditBoxWidget>)tuple);
            components.put((class_3545<EditBoxWidget, EditBoxWidget>)tuple, crossButton);
        }
        return components;
    }

    public boolean hasInputValidationErrors() {
        return this.editBoxWidgets.keySet().stream().flatMap(key -> Stream.of((EditBoxWidget)key.method_15442(), (EditBoxWidget)key.method_15441())).anyMatch(IInputValidatable::hasInputValidationErrors);
    }

    @Override
    public boolean hasValidationErrors() {
        return this.hasInputValidationErrors();
    }
}

