/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IBooleanConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class BooleanConfigEntry
extends BaseConfigEntry<Boolean>
implements IBooleanConfigEntry {
    public BooleanConfigEntry(String key, Boolean defaultValue) {
        super(key, defaultValue);
    }

    @Override
    public void validate(Boolean value) throws ConfigEntryValidationException {
    }

    @Override
    public IConfigEntryType<IConfigEntry<Boolean>, Boolean> getType() {
        return ConfigEntryTypes.BOOLEAN;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showDefaultValues()) {
            comments.addDefaultValues(((Boolean)this.getDefaultValue()).toString());
        }
        return comments;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IBooleanConfigEntry, Boolean> {
        @Override
        public void encodeNode(IBooleanConfigEntry configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.BOOL)) {
                configEntry.set(Boolean.parseBoolean(scalarNode.getValue()));
            }
        }

        @Override
        public NodeTuple decodeNode(IBooleanConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            ScalarNode valueNode = new ScalarNode(Tag.BOOL, Boolean.toString((Boolean)configEntry.get()), ScalarStyle.PLAIN);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IBooleanConfigEntry configEntry, Boolean value) {
            buf.method_52964(value.booleanValue());
        }

        @Override
        public Boolean valueFromNetwork(class_9129 buf) {
            return buf.readBoolean();
        }

        @Override
        public void toNetwork(class_9129 buf, IBooleanConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_52964(((Boolean)configEntry.getDefaultValue()).booleanValue());
            buf.method_52964(((Boolean)configEntry.get()).booleanValue());
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IBooleanConfigEntry fromNetwork(class_9129 buf) {
            BooleanConfigEntry configEntry = new BooleanConfigEntry(buf.method_19772(), buf.readBoolean());
            configEntry.set(buf.readBoolean());
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

