/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IDateTimeConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class DateTimeConfigEntry
extends BaseConfigEntry<LocalDateTime>
implements IDateTimeConfigEntry {
    private final LocalDateTime minDateTime;
    private final LocalDateTime maxDateTime;

    public DateTimeConfigEntry(String key, LocalDateTime defaultValue) {
        this(key, defaultValue, null, null);
    }

    public DateTimeConfigEntry(String key, LocalDateTime defaultValue, LocalDateTime minDateTime, LocalDateTime maxDateTime) {
        super(key, defaultValue);
        this.minDateTime = minDateTime;
        this.maxDateTime = maxDateTime;
    }

    @Override
    public void validate(LocalDateTime value) throws ConfigEntryValidationException {
        if (this.minDateTime != null && value.isBefore(this.minDateTime) || this.maxDateTime != null && value.isAfter(this.maxDateTime)) {
            String minDateTime = this.minDateTime != null ? this.minDateTime.format(IDateTimeConfigEntry.DATE_TIME_FORMATTER) : null;
            String maxDateTime = this.maxDateTime != null ? this.maxDateTime.format(IDateTimeConfigEntry.DATE_TIME_FORMATTER) : null;
            throw new ConfigEntryValidationException(this.getKey(), "Value is out of bounds. Expected between " + minDateTime + " and " + maxDateTime);
        }
    }

    @Override
    public IConfigEntryType<IConfigEntry<LocalDateTime>, LocalDateTime> getType() {
        return ConfigEntryTypes.DATE_TIME;
    }

    @Override
    public LocalDateTime getMinDateTime() {
        return this.minDateTime;
    }

    @Override
    public LocalDateTime getMaxDateTime() {
        return this.maxDateTime;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            if (this.minDateTime != null) {
                comments.addValidationParameter("Minimum value: " + this.minDateTime.format(IDateTimeConfigEntry.DATE_TIME_FORMATTER));
            }
            if (this.maxDateTime != null) {
                comments.addValidationParameter("Maximum value: " + this.maxDateTime.format(IDateTimeConfigEntry.DATE_TIME_FORMATTER));
            }
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues("'" + ((LocalDateTime)this.getDefaultValue()).format(IDateTimeConfigEntry.DATE_TIME_FORMATTER) + "'");
        }
        return comments;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IDateTimeConfigEntry, LocalDateTime> {
        @Override
        public void encodeNode(IDateTimeConfigEntry configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.STR)) {
                configEntry.set(LocalDateTime.parse(scalarNode.getValue(), IDateTimeConfigEntry.DATE_TIME_FORMATTER));
            }
        }

        @Override
        public NodeTuple decodeNode(IDateTimeConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            ScalarNode valueNode = new ScalarNode(Tag.STR, ((LocalDateTime)configEntry.get()).format(IDateTimeConfigEntry.DATE_TIME_FORMATTER), ScalarStyle.SINGLE_QUOTED);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IDateTimeConfigEntry configEntry, LocalDateTime value) {
            buf.method_52974(value.toEpochSecond(ZoneOffset.UTC));
        }

        @Override
        public LocalDateTime valueFromNetwork(class_9129 buf) {
            return LocalDateTime.ofEpochSecond(buf.readLong(), 0, ZoneOffset.UTC);
        }

        @Override
        public void toNetwork(class_9129 buf, IDateTimeConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_52974(((LocalDateTime)configEntry.get()).toEpochSecond(ZoneOffset.UTC));
            buf.method_52974(((LocalDateTime)configEntry.getDefaultValue()).toEpochSecond(ZoneOffset.UTC));
            buf.method_52974(configEntry.getMinDateTime() != null ? configEntry.getMinDateTime().toEpochSecond(ZoneOffset.UTC) : Long.MIN_VALUE);
            buf.method_52974(configEntry.getMaxDateTime() != null ? configEntry.getMaxDateTime().toEpochSecond(ZoneOffset.UTC) : Long.MAX_VALUE);
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IDateTimeConfigEntry fromNetwork(class_9129 buf) {
            String key = buf.method_19772();
            LocalDateTime value = LocalDateTime.ofEpochSecond(buf.readLong(), 0, ZoneOffset.UTC);
            LocalDateTime defaultValue = LocalDateTime.ofEpochSecond(buf.readLong(), 0, ZoneOffset.UTC);
            LocalDateTime minDateTime = buf.readLong() != Long.MIN_VALUE ? LocalDateTime.ofEpochSecond(buf.readLong(), 0, ZoneOffset.UTC) : null;
            LocalDateTime maxDateTime = buf.readLong() != Long.MAX_VALUE ? LocalDateTime.ofEpochSecond(buf.readLong(), 0, ZoneOffset.UTC) : null;
            DateTimeConfigEntry configEntry = new DateTimeConfigEntry(key, defaultValue, minDateTime, maxDateTime);
            configEntry.set(value);
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

