/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IEnumConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.stream.Stream;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class EnumConfigEntry<E extends Enum<E>>
extends BaseConfigEntry<E>
implements IEnumConfigEntry<E> {
    private final Class<E> enumClass;

    public EnumConfigEntry(String key, E defaultValue, Class<E> enumClass) {
        super(key, defaultValue);
        this.enumClass = enumClass;
    }

    @Override
    public void validate(E value) throws ConfigEntryValidationException {
        if (value == null) {
            throw new ConfigEntryValidationException(this.getKey(), "Value cannot be null");
        }
    }

    @Override
    public IConfigEntryType<IConfigEntry<E>, E> getType() {
        return ConfigEntryTypes.ENUM;
    }

    @Override
    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            comments.addValidationParameter("Allowed values: " + String.valueOf(Stream.of((Enum[])this.getEnumClass().getEnumConstants()).map(s -> "'" + String.valueOf(s) + "'").toList()));
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues(((Enum)this.getDefaultValue()).toString());
        }
        return comments;
    }

    public static class Serializer<E extends Enum<E>>
    implements IConfigEntrySerializer<IEnumConfigEntry<E>, E> {
        @Override
        public void encodeNode(IEnumConfigEntry<E> configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.STR)) {
                configEntry.set(Enum.valueOf(configEntry.getEnumClass(), scalarNode.getValue()));
            }
        }

        @Override
        public NodeTuple decodeNode(IEnumConfigEntry<E> configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            ScalarNode valueNode = new ScalarNode(Tag.STR, ((Enum)configEntry.get()).toString(), ScalarStyle.SINGLE_QUOTED);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IEnumConfigEntry<E> configEntry, E value) {
            buf.method_10814(configEntry.getEnumClass().getName());
            buf.method_10817(value);
        }

        @Override
        public E valueFromNetwork(class_9129 buf) {
            try {
                Class<?> enumClass = Class.forName(buf.method_19772());
                return (E)buf.method_10818(enumClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void toNetwork(class_9129 buf, IEnumConfigEntry<E> configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_10814(configEntry.getEnumClass().getName());
            buf.method_10814(((Enum)configEntry.get()).name());
            buf.method_10814(((Enum)configEntry.getDefaultValue()).name());
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IEnumConfigEntry<E> fromNetwork(class_9129 buf) {
            String key = buf.method_19772();
            String enumClassName = buf.method_19772();
            String enumValue = buf.method_19772();
            String defaultEnumValue = buf.method_19772();
            try {
                Class<?> enumClass = Class.forName(enumClassName);
                EnumConfigEntry configEntry = new EnumConfigEntry(key, Enum.valueOf(enumClass, defaultEnumValue), enumClass);
                configEntry.set(Enum.valueOf(enumClass, enumValue));
                buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
                return configEntry;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

