/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.nodes.MappingNode;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IStackConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import com.daqem.yamlconfig.registry.YamlConfigRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2540;
import net.minecraft.class_6880;
import net.minecraft.class_9129;

public class StackConfigEntry
extends BaseConfigEntry<LinkedHashMap<String, IConfigEntry<?>>>
implements IStackConfigEntry {
    public StackConfigEntry(String key, LinkedHashMap<String, IConfigEntry<?>> defaultValue) {
        super(key, defaultValue);
    }

    @Override
    public void validate(LinkedHashMap<String, IConfigEntry<?>> value) {
    }

    @Override
    public IConfigEntryType<IConfigEntry<LinkedHashMap<String, IConfigEntry<?>>>, LinkedHashMap<String, IConfigEntry<?>>> getType() {
        return ConfigEntryTypes.STACK;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IStackConfigEntry, LinkedHashMap<String, IConfigEntry<?>>> {
        @Override
        public void encodeNode(IStackConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                if (configEntry.get() != null) {
                    for (Map.Entry entry : ((LinkedHashMap)configEntry.get()).entrySet()) {
                        mappingNode.getValue().stream().filter(nodeTuple1 -> {
                            ScalarNode keyNode;
                            Node patt0$temp = nodeTuple1.getKeyNode();
                            return patt0$temp instanceof ScalarNode && (keyNode = (ScalarNode)patt0$temp).getValue().equals(entry.getKey());
                        }).findFirst().ifPresent(valueNode -> ((IConfigEntry)entry.getValue()).getType().getSerializer().encodeNode((IConfigEntry)entry.getValue(), (NodeTuple)valueNode));
                    }
                }
            }
        }

        @Override
        public NodeTuple decodeNode(IStackConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            MappingNode mappingNode = new MappingNode(Tag.MAP, ((LinkedHashMap)configEntry.get()).values().stream().map(configEntry1 -> configEntry1.getType().getSerializer().decodeNode(configEntry1)).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, mappingNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IStackConfigEntry configEntry, LinkedHashMap<String, IConfigEntry<?>> value) {
        }

        @Override
        public LinkedHashMap<String, IConfigEntry<?>> valueFromNetwork(class_9129 buf) {
            return null;
        }

        @Override
        public void toNetwork(class_9129 buf, IStackConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_53002(((LinkedHashMap)configEntry.getDefaultValue()).size());
            for (Map.Entry entry : ((LinkedHashMap)configEntry.getDefaultValue()).entrySet()) {
                buf.method_10814((String)entry.getKey());
                buf.method_10812(((IConfigEntry)entry.getValue()).getType().getId());
                ((IConfigEntry)entry.getValue()).getType().getSerializer().toNetwork(buf, (IConfigEntry)entry.getValue());
            }
            buf.method_53002(((LinkedHashMap)configEntry.get()).size());
            for (Map.Entry entry : ((LinkedHashMap)configEntry.get()).entrySet()) {
                buf.method_10814((String)entry.getKey());
                buf.method_10812(((IConfigEntry)entry.getValue()).getType().getId());
                ((IConfigEntry)entry.getValue()).getType().getSerializer().toNetwork(buf, (IConfigEntry)entry.getValue());
            }
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IStackConfigEntry fromNetwork(class_9129 buf) {
            String key = buf.method_19772();
            int defaultValueSize = buf.readInt();
            LinkedHashMap defaultValue = new LinkedHashMap();
            for (int i = 0; i < defaultValueSize; ++i) {
                String entryKey = buf.method_19772();
                Optional reference = YamlConfigRegistry.CONFIG_ENTRY.method_10223(buf.method_10810());
                IConfigEntryType type = reference.map(class_6880.class_6883::comp_349).orElse(null);
                Object entry = Objects.requireNonNull(type).getSerializer().fromNetwork(buf);
                defaultValue.put(entryKey, (IConfigEntry<?>)entry);
            }
            int size = buf.readInt();
            LinkedHashMap value = new LinkedHashMap();
            for (int i = 0; i < size; ++i) {
                String entryKey = buf.method_19772();
                Optional reference = YamlConfigRegistry.CONFIG_ENTRY.method_10223(buf.method_10810());
                IConfigEntryType type = reference.map(class_6880.class_6883::comp_349).orElse(null);
                Object entry = Objects.requireNonNull(type).getSerializer().fromNetwork(buf);
                value.put(entryKey, entry);
            }
            StackConfigEntry configEntry = new StackConfigEntry(key, defaultValue);
            configEntry.set(value);
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

