/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IStringConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class StringConfigEntry
extends BaseConfigEntry<String>
implements IStringConfigEntry {
    private final int minLength;
    private final int maxLength;
    @Nullable
    private final String pattern;
    private final List<String> validValues;

    public StringConfigEntry(String key, String defaultValue) {
        this(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public StringConfigEntry(String key, String defaultValue, int minLength, int maxLength) {
        this(key, defaultValue, minLength, maxLength, List.of());
    }

    public StringConfigEntry(String key, String defaultValue, int minLength, int maxLength, @Nullable String pattern) {
        this(key, defaultValue, minLength, maxLength, pattern, List.of());
    }

    public StringConfigEntry(String key, String defaultValue, int minLength, int maxLength, List<String> validValues) {
        this(key, defaultValue, minLength, maxLength, null, validValues);
    }

    public StringConfigEntry(String key, String defaultValue, int minLength, int maxLength, @Nullable String pattern, List<String> validValues) {
        super(key, defaultValue);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.pattern = pattern;
        this.validValues = validValues;
    }

    @Override
    public void validate(String value) throws ConfigEntryValidationException {
        if (this.minLength != Integer.MIN_VALUE && value.length() < this.minLength) {
            throw new ConfigEntryValidationException(this.getKey(), "String length (" + value.length() + ") is less than the minimum length (" + this.minLength + ")");
        }
        if (this.maxLength != Integer.MAX_VALUE && value.length() > this.maxLength) {
            throw new ConfigEntryValidationException(this.getKey(), "String length (" + value.length() + ") is greater than the maximum length (" + this.maxLength + ")");
        }
        if (this.pattern != null && !value.matches(this.pattern)) {
            throw new ConfigEntryValidationException(this.getKey(), "String (" + value + ") does not match the pattern (" + this.pattern + ")");
        }
        if (!this.validValues.isEmpty() && !this.validValues.contains(value)) {
            throw new ConfigEntryValidationException(this.getKey(), "String (" + value + ") is not a valid value");
        }
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    @Nullable
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public List<String> getValidValues() {
        return this.validValues;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            if (this.minLength != Integer.MIN_VALUE) {
                comments.addValidationParameter("Minimum length: " + this.minLength);
            }
            if (this.maxLength != Integer.MAX_VALUE) {
                comments.addValidationParameter("Maximum length: " + this.maxLength);
            }
            if (this.pattern != null) {
                comments.addValidationParameter("Pattern: " + this.pattern);
            }
            if (!this.validValues.isEmpty()) {
                comments.addValidationParameter("Valid values: " + String.valueOf(this.validValues));
            }
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues("'" + (String)this.getDefaultValue() + "'");
        }
        return comments;
    }

    @Override
    public IConfigEntryType<IConfigEntry<String>, String> getType() {
        return ConfigEntryTypes.STRING;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IStringConfigEntry, String> {
        @Override
        public void encodeNode(IStringConfigEntry configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.STR)) {
                configEntry.set(scalarNode.getValue());
            }
        }

        @Override
        public NodeTuple decodeNode(IStringConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            ScalarNode valueNode = new ScalarNode(Tag.STR, (String)configEntry.get(), ScalarStyle.SINGLE_QUOTED);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IStringConfigEntry configEntry, String value) {
            buf.method_10814(value);
        }

        @Override
        public String valueFromNetwork(class_9129 buf) {
            return buf.method_19772();
        }

        @Override
        public void toNetwork(class_9129 buf, IStringConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_10814((String)configEntry.getDefaultValue());
            buf.method_53002(configEntry.getMinLength());
            buf.method_53002(configEntry.getMaxLength());
            buf.method_10814((String)configEntry.get());
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IStringConfigEntry fromNetwork(class_9129 buf) {
            StringConfigEntry configEntry = new StringConfigEntry(buf.method_19772(), buf.method_19772(), buf.readInt(), buf.readInt());
            configEntry.set(buf.method_19772());
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

