/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.list.numeric;

import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.list.numeric.INumericListConfigEntry;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.impl.config.entry.list.BaseListConfigEntry;
import java.util.List;

public abstract class BaseNumericListConfigEntry<T extends Number>
extends BaseListConfigEntry<T>
implements INumericListConfigEntry<T> {
    private final T minValue;
    private final T maxValue;

    public BaseNumericListConfigEntry(String key, List<T> value, T minValue, T maxValue) {
        this(key, value, Integer.MIN_VALUE, Integer.MAX_VALUE, minValue, maxValue);
    }

    public BaseNumericListConfigEntry(String key, List<T> value, int minLength, int maxLength, T minValue, T maxValue) {
        super(key, value, minLength, maxLength);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public T getMinValue() {
        return this.minValue;
    }

    @Override
    public T getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void validate(List<T> value) throws ConfigEntryValidationException {
        super.validate(value);
        for (Number element : value) {
            if (this.minValue != null && ((Comparable)((Object)element)).compareTo(this.minValue) < 0) {
                throw new ConfigEntryValidationException(this.getKey(), "Element is too small. Expected at least " + String.valueOf(this.minValue));
            }
            if (this.maxValue == null || ((Comparable)((Object)element)).compareTo(this.maxValue) <= 0) continue;
            throw new ConfigEntryValidationException(this.getKey(), "Element is too large. Expected at most " + String.valueOf(this.maxValue));
        }
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            if (this.minValue != null) {
                comments.addValidationParameter("Minimum value: " + String.valueOf(this.minValue));
            }
            if (this.maxValue != null) {
                comments.addValidationParameter("Maximum value: " + String.valueOf(this.maxValue));
            }
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues(((List)this.getDefaultValue()).toString());
        }
        return comments;
    }
}

