/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.list.numeric;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.SequenceNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.list.numeric.IDoubleListConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.list.numeric.BaseNumericListConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class DoubleListConfigEntry
extends BaseNumericListConfigEntry<Double>
implements IDoubleListConfigEntry {
    public DoubleListConfigEntry(String key, List<Double> value) {
        super(key, value, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleListConfigEntry(String key, List<Double> value, int minLength, int maxLength) {
        super(key, value, minLength, maxLength, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleListConfigEntry(String key, List<Double> value, int minLength, int maxLength, Double minValue, Double maxValue) {
        super(key, value, minLength, maxLength, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<List<Double>>, List<Double>> getType() {
        return ConfigEntryTypes.DOUBLE_LIST;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IDoubleListConfigEntry, List<Double>> {
        @Override
        public void encodeNode(IDoubleListConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof SequenceNode) {
                SequenceNode sequenceNode = (SequenceNode)node;
                configEntry.set(sequenceNode.getValue().stream().filter(n -> {
                    ScalarNode scalarNode;
                    return n instanceof ScalarNode && ((scalarNode = (ScalarNode)n).getTag().equals(Tag.FLOAT) || scalarNode.getTag().equals(Tag.INT));
                }).map(n -> Double.parseDouble(((ScalarNode)n).getValue())).toList());
            }
        }

        @Override
        public NodeTuple decodeNode(IDoubleListConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            SequenceNode valueNode = new SequenceNode(Tag.SEQ, ((List)configEntry.get()).stream().map(s -> new ScalarNode(Tag.FLOAT, Double.toString(s), ScalarStyle.PLAIN)).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IDoubleListConfigEntry configEntry, List<Double> value) {
            buf.method_34062(value, class_2540::method_52940);
        }

        @Override
        public List<Double> valueFromNetwork(class_9129 buf) {
            return buf.method_34066(class_2540::readDouble);
        }

        @Override
        public void toNetwork(class_9129 buf, IDoubleListConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_34062((Collection)configEntry.get(), class_2540::method_52940);
            buf.method_34062((Collection)configEntry.getDefaultValue(), class_2540::method_52940);
            buf.method_53002(configEntry.getMinLength());
            buf.method_53002(configEntry.getMaxLength());
            buf.method_52940(((Double)configEntry.getMinValue()).doubleValue());
            buf.method_52940(((Double)configEntry.getMaxValue()).doubleValue());
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IDoubleListConfigEntry fromNetwork(class_9129 buf) {
            String key = buf.method_19772();
            List value = buf.method_34066(class_2540::readDouble);
            List defaultValue = buf.method_34066(class_2540::readDouble);
            int minLength = buf.readInt();
            int maxLength = buf.readInt();
            double minValue = buf.readDouble();
            double maxValue = buf.readDouble();
            DoubleListConfigEntry configEntry = new DoubleListConfigEntry(key, defaultValue, minLength, maxLength, minValue, maxValue);
            configEntry.set(value);
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

