/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.list.numeric;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.SequenceNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.list.numeric.IFloatListConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.list.numeric.BaseNumericListConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class FloatListConfigEntry
extends BaseNumericListConfigEntry<Float>
implements IFloatListConfigEntry {
    public FloatListConfigEntry(String key, List<Float> value) {
        super(key, value, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    public FloatListConfigEntry(String key, List<Float> value, int minLength, int maxLength) {
        super(key, value, minLength, maxLength, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    public FloatListConfigEntry(String key, List<Float> value, int minLength, int maxLength, Float minValue, Float maxValue) {
        super(key, value, minLength, maxLength, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<List<Float>>, List<Float>> getType() {
        return ConfigEntryTypes.FLOAT_LIST;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IFloatListConfigEntry, List<Float>> {
        @Override
        public void encodeNode(IFloatListConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof SequenceNode) {
                SequenceNode sequenceNode = (SequenceNode)node;
                configEntry.set(sequenceNode.getValue().stream().filter(n -> {
                    ScalarNode scalarNode;
                    return n instanceof ScalarNode && ((scalarNode = (ScalarNode)n).getTag().equals(Tag.FLOAT) || scalarNode.getTag().equals(Tag.INT));
                }).map(n -> Float.valueOf(Float.parseFloat(((ScalarNode)n).getValue()))).toList());
            }
        }

        @Override
        public NodeTuple decodeNode(IFloatListConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            SequenceNode valueNode = new SequenceNode(Tag.SEQ, ((List)configEntry.get()).stream().map(s -> new ScalarNode(Tag.FLOAT, Float.toString(s.floatValue()), ScalarStyle.PLAIN)).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IFloatListConfigEntry configEntry, List<Float> value) {
            buf.method_34062(value, class_2540::method_52941);
        }

        @Override
        public List<Float> valueFromNetwork(class_9129 buf) {
            return buf.method_34066(class_2540::readFloat);
        }

        @Override
        public void toNetwork(class_9129 buf, IFloatListConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_34062((Collection)configEntry.get(), class_2540::method_52941);
            buf.method_34062((Collection)configEntry.getDefaultValue(), class_2540::method_52941);
            buf.method_53002(configEntry.getMinLength());
            buf.method_53002(configEntry.getMaxLength());
            buf.method_52941(((Float)configEntry.getMinValue()).floatValue());
            buf.method_52941(((Float)configEntry.getMaxValue()).floatValue());
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IFloatListConfigEntry fromNetwork(class_9129 buf) {
            String key = buf.method_19772();
            List value = buf.method_34066(class_2540::readFloat);
            List defaultValue = buf.method_34066(class_2540::readFloat);
            int minLength = buf.readInt();
            int maxLength = buf.readInt();
            float minValue = buf.readFloat();
            float maxValue = buf.readFloat();
            FloatListConfigEntry configEntry = new FloatListConfigEntry(key, defaultValue, minLength, maxLength, Float.valueOf(minValue), Float.valueOf(maxValue));
            configEntry.set(value);
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

