/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.list.numeric;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.SequenceNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.list.numeric.IIntegerListConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.list.numeric.BaseNumericListConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class IntegerListConfigEntry
extends BaseNumericListConfigEntry<Integer>
implements IIntegerListConfigEntry {
    public IntegerListConfigEntry(String key, List<Integer> value) {
        super(key, value, Integer.valueOf(Integer.MIN_VALUE), Integer.valueOf(Integer.MAX_VALUE));
    }

    public IntegerListConfigEntry(String key, List<Integer> value, int minLength, int maxLength) {
        super(key, value, minLength, maxLength, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerListConfigEntry(String key, List<Integer> value, int minLength, int maxLength, Integer minValue, Integer maxValue) {
        super(key, value, minLength, maxLength, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<List<Integer>>, List<Integer>> getType() {
        return ConfigEntryTypes.INTEGER_LIST;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IIntegerListConfigEntry, List<Integer>> {
        @Override
        public void encodeNode(IIntegerListConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof SequenceNode) {
                SequenceNode sequenceNode = (SequenceNode)node;
                configEntry.set(sequenceNode.getValue().stream().filter(n -> {
                    ScalarNode scalarNode;
                    return n instanceof ScalarNode && (scalarNode = (ScalarNode)n).getTag().equals(Tag.INT);
                }).map(n -> Integer.parseInt(((ScalarNode)n).getValue())).toList());
            }
        }

        @Override
        public NodeTuple decodeNode(IIntegerListConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            SequenceNode valueNode = new SequenceNode(Tag.SEQ, ((List)configEntry.get()).stream().map(s -> new ScalarNode(Tag.INT, Integer.toString(s), ScalarStyle.PLAIN)).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IIntegerListConfigEntry configEntry, List<Integer> value) {
            buf.method_34062(value, class_2540::method_53002);
        }

        @Override
        public List<Integer> valueFromNetwork(class_9129 buf) {
            return buf.method_34066(class_2540::readInt);
        }

        @Override
        public void toNetwork(class_9129 buf, IIntegerListConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_34062((Collection)configEntry.get(), class_2540::method_53002);
            buf.method_34062((Collection)configEntry.getDefaultValue(), class_2540::method_53002);
            buf.method_53002(configEntry.getMinLength());
            buf.method_53002(configEntry.getMaxLength());
            buf.method_53002(((Integer)configEntry.getMinValue()).intValue());
            buf.method_53002(((Integer)configEntry.getMaxValue()).intValue());
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IIntegerListConfigEntry fromNetwork(class_9129 buf) {
            String key = buf.method_19772();
            List value = buf.method_34066(class_2540::readInt);
            List defaultValue = buf.method_34066(class_2540::readInt);
            int minLength = buf.readInt();
            int maxLength = buf.readInt();
            int minValue = buf.readInt();
            int maxValue = buf.readInt();
            IntegerListConfigEntry configEntry = new IntegerListConfigEntry(key, defaultValue, minLength, maxLength, minValue, maxValue);
            configEntry.set(value);
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

