/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.map;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.MappingNode;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.map.IStringMapConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.impl.config.entry.map.BaseMapConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class StringMapConfigEntry
extends BaseMapConfigEntry<String>
implements IStringMapConfigEntry {
    private final String pattern;
    private final List<String> validValues;

    public StringMapConfigEntry(String key, Map<String, String> defaultValue) {
        this(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public StringMapConfigEntry(String key, Map<String, String> defaultValue, int minLength, int maxLength) {
        this(key, defaultValue, minLength, maxLength, null, List.of());
    }

    public StringMapConfigEntry(String key, Map<String, String> defaultValue, int minLength, int maxLength, String pattern) {
        this(key, defaultValue, minLength, maxLength, pattern, List.of());
    }

    public StringMapConfigEntry(String key, Map<String, String> defaultValue, int minLength, int maxLength, List<String> validValues) {
        this(key, defaultValue, minLength, maxLength, null, validValues);
    }

    public StringMapConfigEntry(String key, Map<String, String> defaultValue, int minLength, int maxLength, String pattern, List<String> validValues) {
        super(key, defaultValue, minLength, maxLength);
        this.pattern = pattern;
        this.validValues = validValues;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public List<String> getValidValues() {
        return this.validValues;
    }

    @Override
    public void validate(Map<String, String> value) throws ConfigEntryValidationException {
        super.validate(value);
        for (Map.Entry<String, String> entry : value.entrySet()) {
            if (this.pattern != null && !entry.getValue().matches(this.pattern)) {
                throw new ConfigEntryValidationException(this.getKey(), "Value '" + entry.getValue() + "' does not match pattern '" + this.pattern + "'");
            }
            if (this.validValues.isEmpty() || this.validValues.contains(entry.getValue())) continue;
            throw new ConfigEntryValidationException(this.getKey(), "Value '" + entry.getValue() + "' is not a valid value");
        }
    }

    @Override
    public IConfigEntryType<IConfigEntry<Map<String, String>>, Map<String, String>> getType() {
        return ConfigEntryTypes.STRING_MAP;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            if (this.pattern != null) {
                comments.addValidationParameter("Pattern: " + this.pattern);
            }
            if (this.validValues != null) {
                comments.addValidationParameter("Valid values: " + String.valueOf(this.validValues));
            }
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues(((Map)this.getDefaultValue()).toString());
        }
        return comments;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IStringMapConfigEntry, Map<String, String>> {
        @Override
        public void encodeNode(IStringMapConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                configEntry.set(mappingNode.getValue().stream().filter(n -> {
                    Node patt0$temp = n.getKeyNode();
                    if (!(patt0$temp instanceof ScalarNode)) return false;
                    ScalarNode keyNode = (ScalarNode)patt0$temp;
                    Node patt1$temp = n.getValueNode();
                    if (!(patt1$temp instanceof ScalarNode)) return false;
                    ScalarNode valueNode = (ScalarNode)patt1$temp;
                    if (!keyNode.getTag().equals(Tag.STR)) return false;
                    if (!valueNode.getTag().equals(Tag.STR)) return false;
                    return true;
                }).collect(Collectors.toMap(n -> ((ScalarNode)n.getKeyNode()).getValue(), n -> ((ScalarNode)n.getValueNode()).getValue())));
            }
        }

        @Override
        public NodeTuple decodeNode(IStringMapConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            MappingNode valueNode = new MappingNode(Tag.MAP, ((Map)configEntry.get()).entrySet().stream().map(e -> new NodeTuple(new ScalarNode(Tag.STR, (String)e.getKey(), ScalarStyle.PLAIN), new ScalarNode(Tag.STR, (String)e.getValue(), ScalarStyle.SINGLE_QUOTED))).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IStringMapConfigEntry configEntry, Map<String, String> value) {
            buf.method_34063(value, class_2540::method_10814, class_2540::method_10814);
        }

        @Override
        public Map<String, String> valueFromNetwork(class_9129 buf) {
            return buf.method_34067(class_2540::method_19772, class_2540::method_19772);
        }

        @Override
        public void toNetwork(class_9129 buf, IStringMapConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_34063((Map)configEntry.get(), class_2540::method_10814, class_2540::method_10814);
            buf.method_34063((Map)configEntry.getDefaultValue(), class_2540::method_10814, class_2540::method_10814);
            buf.method_53002(configEntry.getMinLength());
            buf.method_53002(configEntry.getMaxLength());
            buf.method_10814(configEntry.getPattern() == null ? "" : configEntry.getPattern());
            buf.method_34062(configEntry.getValidValues(), class_2540::method_10814);
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IStringMapConfigEntry fromNetwork(class_9129 buf) {
            String key = buf.method_19772();
            Map value = buf.method_34067(class_2540::method_19772, class_2540::method_19772);
            Map defaultValue = buf.method_34067(class_2540::method_19772, class_2540::method_19772);
            int minLength = buf.readInt();
            int maxLength = buf.readInt();
            String pattern = buf.method_19772();
            List validValues = buf.method_34066(class_2540::method_19772);
            StringMapConfigEntry configEntry = new StringMapConfigEntry(key, defaultValue, minLength, maxLength, pattern.isEmpty() ? null : pattern, validValues);
            configEntry.set(value);
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

