/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.map.numeric;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.MappingNode;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.map.numeric.IDoubleMapConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.map.numeric.BaseNumericMapConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class DoubleMapConfigEntry
extends BaseNumericMapConfigEntry<Double>
implements IDoubleMapConfigEntry {
    public DoubleMapConfigEntry(String key, Map<String, Double> defaultValue) {
        super(key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleMapConfigEntry(String key, Map<String, Double> defaultValue, int minLength, int maxLength) {
        super(key, defaultValue, minLength, maxLength, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleMapConfigEntry(String key, Map<String, Double> defaultValue, int minLength, int maxLength, Double minValue, Double maxValue) {
        super(key, defaultValue, minLength, maxLength, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<Map<String, Double>>, Map<String, Double>> getType() {
        return ConfigEntryTypes.DOUBLE_MAP;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IDoubleMapConfigEntry, Map<String, Double>> {
        @Override
        public void encodeNode(IDoubleMapConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                configEntry.set(mappingNode.getValue().stream().filter(n -> {
                    Node patt0$temp = n.getKeyNode();
                    if (!(patt0$temp instanceof ScalarNode)) return false;
                    ScalarNode keyNode = (ScalarNode)patt0$temp;
                    Node patt1$temp = n.getValueNode();
                    if (!(patt1$temp instanceof ScalarNode)) return false;
                    ScalarNode valueNode = (ScalarNode)patt1$temp;
                    if (!keyNode.getTag().equals(Tag.STR)) return false;
                    if (valueNode.getTag().equals(Tag.FLOAT)) return true;
                    if (!valueNode.getTag().equals(Tag.INT)) return false;
                    return true;
                }).collect(Collectors.toMap(n -> ((ScalarNode)n.getKeyNode()).getValue(), n -> Double.parseDouble(((ScalarNode)n.getValueNode()).getValue()))));
            }
        }

        @Override
        public NodeTuple decodeNode(IDoubleMapConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            MappingNode valueNode = new MappingNode(Tag.MAP, ((Map)configEntry.get()).entrySet().stream().map(e -> new NodeTuple(new ScalarNode(Tag.STR, (String)e.getKey(), ScalarStyle.PLAIN), new ScalarNode(Tag.FLOAT, ((Double)e.getValue()).toString(), ScalarStyle.PLAIN))).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IDoubleMapConfigEntry configEntry, Map<String, Double> value) {
            buf.method_34063(value, class_2540::method_10814, class_2540::method_52940);
        }

        @Override
        public Map<String, Double> valueFromNetwork(class_9129 buf) {
            return buf.method_34067(class_2540::method_19772, class_2540::readDouble);
        }

        @Override
        public void toNetwork(class_9129 buf, IDoubleMapConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_34063((Map)configEntry.getDefaultValue(), class_2540::method_10814, class_2540::method_52940);
            buf.method_53002(configEntry.getMinLength());
            buf.method_53002(configEntry.getMaxLength());
            buf.method_52940(((Double)configEntry.getMinValue()).doubleValue());
            buf.method_52940(((Double)configEntry.getMaxValue()).doubleValue());
            buf.method_34063((Map)configEntry.get(), class_2540::method_10814, class_2540::method_52940);
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IDoubleMapConfigEntry fromNetwork(class_9129 buf) {
            DoubleMapConfigEntry configEntry = new DoubleMapConfigEntry(buf.method_19772(), buf.method_34067(class_2540::method_19772, class_2540::readDouble), buf.readInt(), buf.readInt(), buf.readDouble(), buf.readDouble());
            configEntry.set(buf.method_34067(class_2540::method_19772, class_2540::readDouble));
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

