/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.minecraft;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.minecraft.IRegistryConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;

public class RegistryConfigEntry<T>
extends BaseConfigEntry<T>
implements IRegistryConfigEntry<T> {
    private final class_2378<T> registry;

    public RegistryConfigEntry(String key, T defaultValue, class_2378<T> registry) {
        super(key, defaultValue);
        this.registry = registry;
    }

    @Override
    public void validate(T value) throws ConfigEntryValidationException {
        if (this.registry.method_10221(value) == null) {
            throw new ConfigEntryValidationException(this.getKey(), "Value is not in registry.");
        }
    }

    @Override
    public IConfigEntryType<IConfigEntry<T>, T> getType() {
        return ConfigEntryTypes.REGISTRY;
    }

    @Override
    public class_2378<T> getRegistry() {
        return this.registry;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            comments.addValidationParameter("Registry: " + String.valueOf(this.getRegistry().method_46765().method_29177()));
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues("'" + String.valueOf(this.getRegistry().method_10221(this.getDefaultValue())) + "'");
        }
        return comments;
    }

    public static class Serializer<T>
    implements IConfigEntrySerializer<IRegistryConfigEntry<T>, T> {
        @Override
        public void encodeNode(IRegistryConfigEntry<T> configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.STR)) {
                class_2960 resourceLocation = class_2960.method_60654((String)scalarNode.getValue());
                Optional reference = configEntry.getRegistry().method_10223(resourceLocation);
                reference.ifPresent(tReference -> configEntry.set(tReference.comp_349()));
            }
        }

        @Override
        public NodeTuple decodeNode(IRegistryConfigEntry<T> configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            class_2960 key = configEntry.getRegistry().method_10221(configEntry.get());
            ScalarNode valueNode = new ScalarNode(Tag.STR, Objects.requireNonNull(key).toString(), ScalarStyle.SINGLE_QUOTED);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IRegistryConfigEntry<T> configEntry, T value) {
            buf.method_44116(configEntry.getRegistry().method_46765());
            class_2960 resourceLocation = configEntry.getRegistry().method_10221(value);
            buf.method_10812(Objects.requireNonNull(resourceLocation));
        }

        @Override
        public T valueFromNetwork(class_9129 buf) {
            class_5321 key = buf.method_53006();
            class_2960 resourceLocation = buf.method_10810();
            Optional reference = class_7923.field_41167.method_46746(key);
            return reference.map(registry -> ((class_6880.class_6883)((class_2378)registry.comp_349()).method_10223(resourceLocation).get()).comp_349()).orElse(null);
        }

        @Override
        public void toNetwork(class_9129 buf, IRegistryConfigEntry<T> configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_44116(configEntry.getRegistry().method_46765());
            buf.method_10812(Objects.requireNonNull(configEntry.getRegistry().method_10221(configEntry.get())));
            buf.method_10812(Objects.requireNonNull(configEntry.getRegistry().method_10221(configEntry.getDefaultValue())));
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IRegistryConfigEntry<T> fromNetwork(class_9129 buf) {
            String key = buf.method_19772();
            class_5321 registryKey = buf.method_53006();
            class_2960 resourceLocation = buf.method_10810();
            class_2960 defaultResourceLocation = buf.method_10810();
            Optional reference = class_7923.field_41167.method_46746(registryKey);
            RegistryConfigEntry<Object> configEntry = new RegistryConfigEntry<Object>(key, reference.map(registry -> ((class_6880.class_6883)((class_2378)registry.comp_349()).method_10223(defaultResourceLocation).get()).comp_349()).orElse(null), reference.map(class_6880.class_6883::comp_349).orElse(null));
            configEntry.set(reference.map(registry -> ((class_6880.class_6883)((class_2378)registry.comp_349()).method_10223(resourceLocation).get()).comp_349()).orElse(null));
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

