/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.minecraft;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.minecraft.IResourceLocationConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public class ResourceLocationConfigEntry
extends BaseConfigEntry<class_2960>
implements IResourceLocationConfigEntry {
    private final String pattern;

    public ResourceLocationConfigEntry(String key, class_2960 defaultValue) {
        this(key, defaultValue, null);
    }

    public ResourceLocationConfigEntry(String key, class_2960 defaultValue, String pattern) {
        super(key, defaultValue);
        this.pattern = pattern;
    }

    @Override
    public void validate(class_2960 value) throws ConfigEntryValidationException {
        if (this.pattern != null && !value.toString().matches(this.pattern)) {
            throw new ConfigEntryValidationException(this.getKey(), "Value does not match pattern: " + this.pattern);
        }
    }

    @Override
    public IConfigEntryType<IConfigEntry<class_2960>, class_2960> getType() {
        return ConfigEntryTypes.RESOURCE_LOCATION;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters() && this.pattern != null) {
            comments.addValidationParameter("Pattern: " + this.pattern);
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues("'" + String.valueOf(this.getDefaultValue()) + "'");
        }
        return comments;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IResourceLocationConfigEntry, class_2960> {
        @Override
        public void encodeNode(IResourceLocationConfigEntry configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.STR)) {
                configEntry.set(class_2960.method_12829((String)scalarNode.getValue()));
            }
        }

        @Override
        public NodeTuple decodeNode(IResourceLocationConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            ScalarNode valueNode = new ScalarNode(Tag.STR, ((class_2960)configEntry.get()).toString(), ScalarStyle.SINGLE_QUOTED);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IResourceLocationConfigEntry configEntry, class_2960 value) {
            buf.method_10812(value);
        }

        @Override
        public class_2960 valueFromNetwork(class_9129 buf) {
            return buf.method_10810();
        }

        @Override
        public void toNetwork(class_9129 buf, IResourceLocationConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_10812((class_2960)configEntry.get());
            buf.method_10812((class_2960)configEntry.getDefaultValue());
            buf.method_10814(configEntry.getPattern() == null ? "" : configEntry.getPattern());
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IResourceLocationConfigEntry fromNetwork(class_9129 buf) {
            String key = buf.method_19772();
            class_2960 value = buf.method_10810();
            class_2960 defaultValue = buf.method_10810();
            String pattern = buf.method_19772();
            ResourceLocationConfigEntry configEntry = new ResourceLocationConfigEntry(key, defaultValue, pattern.isEmpty() ? null : pattern);
            configEntry.set(value);
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

