/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.numeric;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.numeric.IDoubleConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.numeric.BaseNumericConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class DoubleConfigEntry
extends BaseNumericConfigEntry<Double>
implements IDoubleConfigEntry {
    public DoubleConfigEntry(String key, Double defaultValue) {
        super(key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleConfigEntry(String key, Double defaultValue, Double minValue, Double maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<Double>, Double> getType() {
        return ConfigEntryTypes.DOUBLE;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IDoubleConfigEntry, Double> {
        @Override
        public void encodeNode(IDoubleConfigEntry configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.FLOAT)) {
                configEntry.set(Double.parseDouble(scalarNode.getValue()));
            }
        }

        @Override
        public NodeTuple decodeNode(IDoubleConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            ScalarNode valueNode = new ScalarNode(Tag.FLOAT, Double.toString((Double)configEntry.get()), ScalarStyle.PLAIN);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IDoubleConfigEntry configEntry, Double value) {
            buf.method_52940(value.doubleValue());
        }

        @Override
        public Double valueFromNetwork(class_9129 buf) {
            return buf.readDouble();
        }

        @Override
        public void toNetwork(class_9129 buf, IDoubleConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_52940(((Double)configEntry.getDefaultValue()).doubleValue());
            buf.method_52940(((Double)configEntry.getMinValue()).doubleValue());
            buf.method_52940(((Double)configEntry.getMaxValue()).doubleValue());
            buf.method_52940(((Double)configEntry.get()).doubleValue());
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IDoubleConfigEntry fromNetwork(class_9129 buf) {
            DoubleConfigEntry configEntry = new DoubleConfigEntry(buf.method_19772(), buf.readDouble(), buf.readDouble(), buf.readDouble());
            configEntry.set(buf.readDouble());
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

