/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.numeric;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.numeric.IFloatConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.numeric.BaseNumericConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class FloatConfigEntry
extends BaseNumericConfigEntry<Float>
implements IFloatConfigEntry {
    public FloatConfigEntry(String key, Float defaultValue) {
        super(key, defaultValue, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    public FloatConfigEntry(String key, Float defaultValue, Float minValue, Float maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<Float>, Float> getType() {
        return ConfigEntryTypes.FLOAT;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IFloatConfigEntry, Float> {
        @Override
        public void encodeNode(IFloatConfigEntry configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.FLOAT)) {
                configEntry.set(Float.valueOf(Float.parseFloat(scalarNode.getValue())));
            }
        }

        @Override
        public NodeTuple decodeNode(IFloatConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            ScalarNode valueNode = new ScalarNode(Tag.FLOAT, Float.toString(((Float)configEntry.get()).floatValue()), ScalarStyle.PLAIN);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IFloatConfigEntry configEntry, Float value) {
            buf.method_52941(value.floatValue());
        }

        @Override
        public Float valueFromNetwork(class_9129 buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public void toNetwork(class_9129 buf, IFloatConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_52941(((Float)configEntry.getDefaultValue()).floatValue());
            buf.method_52941(((Float)configEntry.getMinValue()).floatValue());
            buf.method_52941(((Float)configEntry.getMaxValue()).floatValue());
            buf.method_52941(((Float)configEntry.get()).floatValue());
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IFloatConfigEntry fromNetwork(class_9129 buf) {
            FloatConfigEntry configEntry = new FloatConfigEntry(buf.method_19772(), Float.valueOf(buf.readFloat()), Float.valueOf(buf.readFloat()), Float.valueOf(buf.readFloat()));
            configEntry.set(Float.valueOf(buf.readFloat()));
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

