/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.numeric;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.numeric.IIntegerConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.numeric.BaseNumericConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import net.minecraft.class_2540;
import net.minecraft.class_9129;

public class IntegerConfigEntry
extends BaseNumericConfigEntry<Integer>
implements IIntegerConfigEntry {
    public IntegerConfigEntry(String key, int defaultValue) {
        super(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerConfigEntry(String key, int defaultValue, int minValue, int maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<Integer>, Integer> getType() {
        return ConfigEntryTypes.INTEGER;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IIntegerConfigEntry, Integer> {
        @Override
        public void encodeNode(IIntegerConfigEntry configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.INT)) {
                configEntry.set(Integer.parseInt(scalarNode.getValue()));
            }
        }

        @Override
        public NodeTuple decodeNode(IIntegerConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            ScalarNode valueNode = new ScalarNode(Tag.INT, Integer.toString((Integer)configEntry.get()), ScalarStyle.PLAIN);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(class_9129 buf, IIntegerConfigEntry configEntry, Integer value) {
            buf.method_53002(value.intValue());
        }

        @Override
        public Integer valueFromNetwork(class_9129 buf) {
            return buf.readInt();
        }

        @Override
        public void toNetwork(class_9129 buf, IIntegerConfigEntry configEntry) {
            buf.method_10814(configEntry.getKey());
            buf.method_53002(((Integer)configEntry.getDefaultValue()).intValue());
            buf.method_53002(((Integer)configEntry.getMinValue()).intValue());
            buf.method_53002(((Integer)configEntry.getMaxValue()).intValue());
            buf.method_53002(((Integer)configEntry.get()).intValue());
            buf.method_34062(configEntry.getComments().getComments(false), class_2540::method_10814);
        }

        @Override
        public IIntegerConfigEntry fromNetwork(class_9129 buf) {
            IntegerConfigEntry configEntry = new IntegerConfigEntry(buf.method_19772(), buf.readInt(), buf.readInt(), buf.readInt());
            configEntry.set(buf.readInt());
            buf.method_34066(class_2540::method_19772).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

