/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.test;

import com.daqem.yamlconfig.api.config.ConfigExtension;
import com.daqem.yamlconfig.api.config.ConfigType;
import com.daqem.yamlconfig.api.config.IConfig;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.impl.config.ConfigBuilder;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1267;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ClientTestConfig {
    public static IConfig config;
    public static IConfigEntry<Boolean> debug;
    public static IConfigEntry<Integer> testInt;
    public static IConfigEntry<String> testString;
    public static IConfigEntry<String> testString1;
    public static IConfigEntry<List<String>> testStringList;
    public static IConfigEntry<List<Integer>> testIntList;
    public static IConfigEntry<Boolean> testBoolean;
    public static IConfigEntry<Float> testFloat;
    public static IConfigEntry<Double> testDouble;
    public static IConfigEntry<class_1267> testEnum;
    public static IConfigEntry<Map<String, Integer>> testIntegerMap;
    public static IConfigEntry<LocalDateTime> testDateTime;
    public static IConfigEntry<class_1792> testItem;
    public static IConfigEntry<class_2960> testResourceLocation;

    public static void init() {
        ConfigBuilder builder = new ConfigBuilder("test", "test-client", ConfigExtension.YAML, ConfigType.CLIENT);
        debug = builder.defineBoolean("debug", false).withComments("Whether debug mode is enabled for the mod.").dontSync();
        builder.push("test").withComments("This is a test stack.", "And another comment.", "Wow even a third comment.");
        testInt = builder.defineInteger("testInt", 10, 0, 100);
        builder.push("test1");
        testString = builder.defineString("testString", "test");
        builder.push("test2");
        testString1 = builder.defineString("testString", "test");
        builder.pop();
        builder.pop();
        builder.pop();
        testStringList = builder.defineStringList("testStringList", List.of("test1", "test2", "test3"), 3, 10, "test\\d+");
        testIntList = builder.defineIntegerList("testIntList", List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), 3, 10);
        testBoolean = builder.defineBoolean("testBoolean", true);
        testFloat = builder.defineFloat("testFloat", 1.0f);
        testDouble = builder.defineDouble("testDouble", 1.0);
        testEnum = builder.defineEnum("testEnum", class_1267.field_5802, class_1267.class);
        testIntegerMap = builder.defineIntegerMap("testIntegerMap", Map.of("test1", 1, "test2", 2, "test3", 3), 3, 10);
        testDateTime = builder.defineDateTime("testDateTime", LocalDateTime.of(2021, 1, 1, 0, 0, 0));
        testItem = builder.defineRegistry("testItem", class_1802.field_20391, class_7923.field_41178);
        testResourceLocation = builder.defineResourceLocation("testResourceLocation", class_2960.method_60655((String)"minecraft", (String)"stone"));
        config = builder.build();
        ConfigBuilder builder4 = new ConfigBuilder("test1", "test1-client", ConfigExtension.YAML, ConfigType.CLIENT);
        builder4.push("mod_config");
        builder4.push("general");
        builder4.defineString("mod_name", "Test Mod");
        builder4.defineString("mod_version", "1.0.0");
        builder4.defineString("mod_author", "Test Author");
        builder4.pop();
        builder4.push("items");
        builder4.defineRegistry("item", class_1802.field_8270, class_7923.field_41178);
        builder4.defineRegistry("block", class_2246.field_10219, class_7923.field_41175);
        builder4.defineString("custom_name", "Grass Block");
        builder4.defineInteger("max_stack_size", 64, 1, 64);
        builder4.pop();
        builder4.push("settings");
        builder4.defineInteger("integer_entry", 10, 0, 100);
        builder4.defineFloat("float_entry", 1.0f, 0.0f, 1.0f);
        builder4.defineDouble("double_entry", 1.0, 0.0, 1.0);
        builder4.defineResourceLocation("resource_location_entry", class_2960.method_60655((String)"minecraft", (String)"stone"));
        builder4.defineEnum("enum_entry", class_1267.field_5802, class_1267.class);
        builder4.defineDateTime("date_time_entry", LocalDateTime.of(2021, 1, 1, 0, 0, 0));
        builder4.pop();
        builder4.push("lists");
        builder4.defineStringList("string_list", List.of("test1", "test2", "test3"), 3, 10, "test\\d+");
        builder4.defineIntegerList("integer_list", List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), 3, 10);
        builder4.defineFloatList("float_list", List.of(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), 3, 10);
        builder4.defineDoubleList("double_list", List.of(Double.valueOf(1.0), Double.valueOf(2.0), Double.valueOf(3.0)), 3, 10);
        builder4.pop();
        builder4.pop();
        builder4.push("test");
        builder4.push("maps");
        builder4.defineStringMap("string_map", Map.of("test1", "1", "test2", "2", "test3", "3"), 3, 10);
        builder4.defineIntegerMap("integer_map", Map.of("test1", 1, "test2", 2, "test3", 3), 3, 10);
        builder4.defineFloatMap("float_map", Map.of("test1", Float.valueOf(1.0f), "test2", Float.valueOf(2.0f), "test3", Float.valueOf(3.0f)), 3, 10);
        builder4.defineDoubleMap("double_map", Map.of("test1", 1.0, "test2", 2.0, "test3", 3.0), 3, 10);
        builder4.pop();
        builder4.pop();
        builder4.build();
    }
}

