/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.storage;

import java.util.Collection;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_433;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import org.apache.logging.log4j.Logger;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.chesttracker.impl.storage.backend.Backend;

@Environment(value=EnvType.CLIENT)
public class Storage {
    private static final Logger LOGGER = ChestTracker.getLogger("Storage");
    private static Backend backend;

    public static void setBackend(Backend backend) {
        Storage.backend = backend;
    }

    public static void setup() {
        ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).storage.storageBackend.load();
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_433) {
                MemoryBankAccessImpl.INSTANCE.save();
            }
        });
    }

    public static Optional<Metadata> loadMetadata(String id) {
        Optional<MemoryBankImpl> existing = MemoryBankAccessImpl.INSTANCE.getLoadedInternal();
        if (existing.isPresent() && id.equals(existing.get().getId())) {
            return Optional.of(existing.get().getMetadata().deepCopy());
        }
        LOGGER.debug("Loading {} metadata using {}", (Object)id, (Object)backend.getClass().getSimpleName());
        return backend.loadMetadata(id);
    }

    public static Collection<String> getAllIds() {
        return backend.getAllIds();
    }

    public static boolean exists(String id) {
        return backend.exists(id);
    }

    public static void delete(String id) {
        backend.delete(id);
    }

    public static class_2561 getBackendLabel(String memoryBankId) {
        return backend.getDescriptionLabel(memoryBankId);
    }

    public static Optional<MemoryBankImpl> load(String id) {
        Optional<MemoryBankImpl> existing = MemoryBankAccessImpl.INSTANCE.getLoadedInternal();
        if (existing.isPresent() && id.equals(existing.get().getId())) {
            return existing;
        }
        class_638 level = class_310.method_1551().field_1687;
        class_5455 registries = null;
        if (level != null) {
            registries = level.method_30349();
        }
        LOGGER.debug("Loading {} using {}", (Object)id, (Object)backend.getClass().getSimpleName());
        MemoryBankImpl loaded = backend.load(id, (class_7225.class_7874)registries);
        if (loaded == null) {
            return Optional.empty();
        }
        loaded.setId(id);
        return Optional.of(loaded);
    }

    public static void save(MemoryBankImpl bank) {
        if (bank == null) {
            LOGGER.warn("Tried to save null Memory Bank");
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        class_5455 registries = null;
        if (level != null) {
            registries = level.method_30349();
        }
        bank.getMetadata().updateModified();
        backend.save(bank, (class_7225.class_7874)registries);
    }
}

