/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.invbutton.ui;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8028;
import net.minecraft.class_8030;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.api.gui.ScreenBlacklist;
import red.jackf.chesttracker.api.providers.MemoryLocation;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.gui.invbutton.ButtonPositionMap;
import red.jackf.chesttracker.impl.gui.invbutton.PositionExporter;
import red.jackf.chesttracker.impl.gui.invbutton.position.ButtonPosition;
import red.jackf.chesttracker.impl.gui.invbutton.position.PositionUtils;
import red.jackf.chesttracker.impl.gui.invbutton.position.RectangleUtils;
import red.jackf.chesttracker.impl.gui.invbutton.ui.RememberContainerButton;
import red.jackf.chesttracker.impl.gui.invbutton.ui.RenameButton;
import red.jackf.chesttracker.impl.gui.invbutton.ui.SecondaryButton;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.util.GuiUtil;

@Environment(value=EnvType.CLIENT)
public class InventoryButton
extends class_339 {
    private static final class_8666 TEXTURE = GuiUtil.twoSprite("inventory_button/button");
    private static final int MS_BEFORE_DRAG_START = 200;
    private static final int EXPANDED_HOVER_INFLATE = 5;
    private static final int EXTRA_BUTTON_SPACING = 3;
    public static final int SIZE = 9;
    public static final int IMAGE_SIZE = 11;
    @Nullable
    private static Pair<class_465<?>, MemoryLocation> locationToRestore = null;
    private final class_465<?> parent;
    private ButtonPosition lastPosition;
    private ButtonPosition position;
    private boolean lastRecipeBookVisible;
    private boolean canDrag = false;
    private long mouseDownStart = -1L;
    private boolean isDragging = false;
    private boolean secondaryButtonClicked = false;
    private final List<SecondaryButton> secondaryButtons = new ArrayList<SecondaryButton>();
    private class_8030 expandedHoverArea = class_8030.method_48248();

    public InventoryButton(class_465<?> parent, ButtonPosition position, Optional<MemoryLocation> target) {
        super(position.getX(parent), position.getY(parent), 9, 9, (class_2561)class_2561.method_43471((String)"chesttracker.title"));
        MemoryBankImpl bank;
        this.parent = parent;
        this.position = position;
        this.lastPosition = position;
        this.lastRecipeBookVisible = PositionUtils.isRecipeBookVisible(parent);
        this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.title")));
        if (locationToRestore != null && locationToRestore.getFirst() == parent) {
            target = Optional.of((MemoryLocation)locationToRestore.getSecond());
            locationToRestore = null;
        }
        if (!ScreenBlacklist.isBlacklisted(parent.getClass()) && (bank = (MemoryBankImpl)MemoryBankAccessImpl.INSTANCE.getLoadedInternal().orElse(null)) != null && ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.inventoryButton.showExtra && target.isPresent()) {
            MemoryLocation location = target.get();
            this.secondaryButtons.add(new RememberContainerButton(bank, location));
            this.secondaryButtons.add(new RenameButton(parent, bank, location));
        }
        if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.inventoryButton.showExport) {
            this.secondaryButtons.add(new SecondaryButton(GuiUtil.twoSprite("inventory_button/export"), (class_2561)class_2561.method_43471((String)"chesttracker.inventoryButton.export"), () -> PositionExporter.export(parent, position)));
        }
        for (int i = 0; i < this.secondaryButtons.size(); ++i) {
            this.secondaryButtons.get(i).setButtonIndex(i + 1);
        }
        this.applyPosition(true);
    }

    protected static void setRestoreLocation(class_465<?> screen, MemoryLocation location) {
        locationToRestore = Pair.of(screen, (Object)location);
    }

    private static boolean alwaysShowExtra() {
        return ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.inventoryButton.alwaysShowExtra;
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.isDragging) {
            this.applyPosition(false);
            this.showExtraButtons(InventoryButton.alwaysShowExtra() || this.method_49606() || this.isExpandedHover(mouseX, mouseY));
        } else {
            this.showExtraButtons(false);
        }
        class_2960 texture = TEXTURE.method_52729(this.method_37303(), this.method_25367());
        graphics.method_52707(class_10799.field_56883, texture, this.method_46426() - 1, this.method_46427() - 1, 11, 11, -1);
        for (class_339 class_3392 : this.secondaryButtons) {
            class_3392.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }

    private boolean isExpandedHover(int mouseX, int mouseY) {
        return this.expandedHoverArea.method_48252(new class_8030(mouseX, mouseY, 1, 1));
    }

    private void applyPosition(boolean force) {
        boolean recipeVisible = PositionUtils.isRecipeBookVisible(this.parent);
        if (!force && this.position.equals(this.lastPosition) && recipeVisible == this.lastRecipeBookVisible) {
            return;
        }
        this.lastPosition = this.position;
        this.lastRecipeBookVisible = recipeVisible;
        this.method_46421(this.position.getX(this.parent));
        this.method_46419(this.position.getY(this.parent));
        Set<class_8030> colliders = RectangleUtils.getCollidersFor(this.parent);
        class_8028 freeDir = class_8028.field_41829;
        for (class_8028 dir : List.of(class_8028.field_41829, class_8028.field_41828, class_8028.field_41827, class_8028.field_41826)) {
            if (!RectangleUtils.isFree(this.rectangleFor(dir), colliders, this.parent.method_48202())) continue;
            freeDir = dir;
            break;
        }
        for (int i = 1; i <= this.secondaryButtons.size(); ++i) {
            class_8030 pos = RectangleUtils.step(this.method_48202(), freeDir, 12 * i);
            this.secondaryButtons.get(i - 1).method_48229(pos.method_49620(), pos.method_49618());
        }
    }

    private class_8030 rectangleFor(class_8028 dir) {
        ArrayList<class_8030> boxes = new ArrayList<class_8030>();
        boxes.add(this.method_48202());
        for (int i = 1; i <= this.secondaryButtons.size(); ++i) {
            boxes.add(RectangleUtils.step(this.method_48202(), dir, 12 * i));
        }
        return RectangleUtils.encompassing(boxes);
    }

    private void showExtraButtons(boolean shouldShow) {
        for (SecondaryButton btn : this.secondaryButtons) {
            btn.setVisible(shouldShow, this.method_46426(), this.method_46427());
        }
        if (shouldShow) {
            List<class_8030> all = Stream.concat(Stream.of(this.method_48202()), this.secondaryButtons.stream().map(class_339::method_48202)).toList();
            this.expandedHoverArea = RectangleUtils.inflate(RectangleUtils.encompassing(all), 5);
        } else {
            this.expandedHoverArea = class_8030.method_48248();
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (super.method_25405(mouseX, mouseY)) {
            return true;
        }
        for (class_339 class_3392 : this.secondaryButtons) {
            if (!class_3392.field_22764 || !class_3392.method_25405(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        for (int i = 0; i < this.secondaryButtons.size(); ++i) {
            class_339 secondary = this.secondaryButtons.get(i);
            if (!secondary.method_25402(event, isDoubleClick)) continue;
            this.secondaryButtonClicked = true;
            return true;
        }
        if (super.method_25405(event.comp_4798(), event.comp_4799())) {
            this.canDrag = true;
            this.mouseDownStart = class_156.method_658();
            this.secondaryButtonClicked = false;
            return super.method_25402(event, isDoubleClick);
        }
        return false;
    }

    public void method_25348(class_11909 event, boolean isDoubleClick) {
    }

    public boolean method_25406(class_11909 event) {
        for (class_339 class_3392 : this.secondaryButtons) {
            if (!class_3392.field_22764 || !class_3392.method_25405(event.comp_4798(), event.comp_4799()) || !class_3392.method_25406(event)) continue;
            this.canDrag = false;
            this.mouseDownStart = -1L;
            this.secondaryButtonClicked = false;
            return true;
        }
        boolean wasDragging = this.isDragging;
        boolean bl = super.method_25405(event.comp_4798(), event.comp_4799());
        this.canDrag = false;
        this.mouseDownStart = -1L;
        if (wasDragging) {
            int centerY;
            this.isDragging = false;
            int centerX = this.method_46426() + 4;
            Optional<ButtonPosition> finalPos = PositionUtils.calculate(this.parent, centerX, centerY = this.method_46427() + 4, false);
            if (finalPos.isPresent()) {
                this.position = finalPos.get();
                ButtonPositionMap.saveUserPosition(this.parent, this.position);
            }
            this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.title")));
            return true;
        }
        if (bl && !wasDragging && !this.secondaryButtonClicked) {
            ChestTracker.openInGame(class_310.method_1551(), this.parent);
            this.secondaryButtonClicked = false;
            return true;
        }
        this.secondaryButtonClicked = false;
        return false;
    }

    public boolean method_25403(class_11909 event, double mouseX, double mouseY) {
        if (!this.canDrag) {
            return false;
        }
        if (this.secondaryButtonClicked) {
            return false;
        }
        for (class_339 class_3392 : this.secondaryButtons) {
            if (!class_3392.field_22764 || !class_3392.method_25405(event.comp_4798(), event.comp_4799())) continue;
            return false;
        }
        if (class_156.method_658() - this.mouseDownStart >= 200L) {
            this.isDragging = true;
            int newX = (int)event.comp_4798() - 4;
            int n = (int)event.comp_4799() - 4;
            newX = class_3532.method_15340((int)newX, (int)0, (int)(this.parent.field_22789 - 9));
            int n2 = class_3532.method_15340((int)n, (int)0, (int)(this.parent.field_22790 - 9));
            class_8030 buttonRect = new class_8030(newX, n2, 9, 9);
            Set<class_8030> collisions = RectangleUtils.getCollidersFor(this.parent);
            boolean hasCollision = false;
            for (class_8030 collision : collisions) {
                if (!buttonRect.method_48252(collision)) continue;
                hasCollision = true;
                break;
            }
            if (!hasCollision) {
                this.method_46421(newX);
                this.method_46419(n2);
            }
            this.method_47400(null);
            return true;
        }
        return this.canDrag;
    }

    protected void method_25349(class_11909 event, double mouseX, double mouseY) {
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }
}

