/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.memory.metadata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import red.jackf.chesttracker.impl.rendering.NameRenderMode;
import red.jackf.jackfredlib.api.base.codecs.JFLCodecs;

@Environment(value=EnvType.CLIENT)
public class CompatibilitySettings {
    protected static final Codec<CompatibilitySettings> CODEC = RecordCodecBuilder.create(instance -> {
        CompatibilitySettings def = new CompatibilitySettings();
        return instance.group((App)JFLCodecs.forEnum(NameFilterMode.class).optionalFieldOf("nameFilterMode").forGetter(settings -> Optional.of(settings.nameFilterMode)), (App)JFLCodecs.forEnum(NameRenderMode.class).optionalFieldOf("nameRenderMode").forGetter(settings -> Optional.of(settings.nameRenderMode))).apply((Applicative)instance, (nameFilterMode, displayContainerNames) -> new CompatibilitySettings(nameFilterMode.orElse(def.nameFilterMode), displayContainerNames.orElse(def.nameRenderMode)));
    });
    public NameFilterMode nameFilterMode = NameFilterMode.NO_FILTER;
    public NameRenderMode nameRenderMode = NameRenderMode.FULL;

    protected CompatibilitySettings() {
    }

    protected CompatibilitySettings(NameFilterMode nameFilterMode, NameRenderMode nameRenderMode) {
        this.nameFilterMode = nameFilterMode;
        this.nameRenderMode = nameRenderMode;
    }

    public CompatibilitySettings copy() {
        return new CompatibilitySettings(this.nameFilterMode, this.nameRenderMode);
    }

    private static class_2561 filterRegex(class_2561 component, Pattern regex) {
        class_5250 base = class_2561.method_43473();
        component.method_27658((style, str) -> {
            String filtered = regex.matcher(str).replaceAll("");
            if (!filtered.isBlank()) {
                base.method_10852((class_2561)class_2561.method_43470((String)filtered).method_27696(style));
            }
            return Optional.empty();
        }, class_2583.field_24360);
        return base;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum NameFilterMode {
        NO_FILTER(c -> c, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.compatibility.nameFilterMode.none"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.compatibility.nameFilterMode.none.tooltip")),
        ASCII(c -> CompatibilitySettings.filterRegex(c, Pattern.compile("[^\\u0000-\\u007F]")), (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.compatibility.nameFilterMode.ascii"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.compatibility.nameFilterMode.ascii.tooltip")),
        BASIC_UNICODE(c -> CompatibilitySettings.filterRegex(c, Pattern.compile("[^\\u0000-\\u33FF]")), (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.compatibility.nameFilterMode.basicUnicode"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.compatibility.nameFilterMode.basicUnicode.tooltip"));

        public final UnaryOperator<class_2561> filter;
        public final class_2561 label;
        public final class_2561 tooltip;

        private NameFilterMode(UnaryOperator<class_2561> filter, class_2561 label, class_2561 tooltip) {
            this.filter = filter;
            this.label = label;
            this.tooltip = tooltip;
        }
    }
}

