/*
 * Decompiled with CFR 0.152.
 */
package net.sergofox123.versecraft;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerseSharedConstants {
    public static final String MOD_ID = "versecraft";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"versecraft");
    public static final ModContainer MOD_CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("versecraft").orElseThrow();
    public static final Map<Object, Long> INSTANT_MAP = new Object2ObjectOpenHashMap();
    public static boolean UNSTABLE_LOGGING = FabricLoader.getInstance().isDevelopmentEnvironment();

    public static void log(String string, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(string);
        }
    }

    public static void logWithModId(String message, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(message + " versecraft");
        }
    }

    public static void log(class_1297 entity, String string, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(entity.toString() + " : " + string + " : " + String.valueOf(entity.method_73189()));
        }
    }

    public static void log(class_2248 block, String string, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(block.toString() + " : " + string + " : ");
        }
    }

    public static void log(class_2248 block, class_2338 pos, String string, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(block.toString() + " : " + string + " : " + String.valueOf(pos));
        }
    }

    public static void logMod(String string, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(string + " versecraft");
        }
    }

    public static void startMeasuring(@NotNull Object object) {
        long started = System.nanoTime();
        String name = object.getClass().getName();
        LOGGER.info("Started measuring {}", (Object)name.substring(name.lastIndexOf(".") + 1));
        INSTANT_MAP.put(object, started);
    }

    public static void stopMeasuring(Object object) {
        if (INSTANT_MAP.containsKey(object)) {
            String name = object.getClass().getName();
            LOGGER.info("{} took {} nanoseconds", (Object)name.substring(name.lastIndexOf(".") + 1), (Object)(System.nanoTime() - INSTANT_MAP.get(object)));
            INSTANT_MAP.remove(object);
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    @NotNull
    public static class_2960 idOrDefault(String path, String fallback) {
        try {
            return VerseSharedConstants.id(path);
        }
        catch (IllegalArgumentException ignored) {
            return VerseSharedConstants.id(fallback);
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    public static class_2960 vanillaId(String path) {
        return class_2960.method_60656((String)path);
    }

    @NotNull
    public static String string(@NotNull String path) {
        return VerseSharedConstants.id(path).toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String safeString(String path) {
        return "versecraft_" + path;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static class_2561 text(String key) {
        return class_2561.method_43471((String)("option.versecraft." + key));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static class_2561 tooltip(String key) {
        return class_2561.method_43471((String)("tooltip.versecraft." + key));
    }
}

