/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.base;

import com.finderfeed.fdbosses.content.entities.base.BossSpawnerContextAssignable;
import com.finderfeed.fdbosses.content.entities.base.ForceDossierClosePacket;
import com.finderfeed.fdbosses.packets.OpenBossDossierPacket;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class BossSpawnerEntity
extends FDEntity {
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(BossSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public BossSpawnerEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.isActive()) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide && hand == InteractionHand.MAIN_HAND && this.isActive()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenBossDossierPacket(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.interact(player, hand);
    }

    public void spawn() {
        if (this.isActive()) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ForceDossierClosePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            EntityType<? extends BossSpawnerContextAssignable> type = this.getBossEntityType();
            Entity entity = type.create(this.level());
            entity.setYRot(0.0f);
            entity.setYBodyRot(0.0f);
            entity.setYHeadRot(0.0f);
            ((BossSpawnerContextAssignable)entity).setSpawnedBy(this);
            entity.setPos(this.position());
            this.level().addFreshEntity(entity);
            this.setActive(false);
        }
    }

    public boolean isPickable() {
        return true;
    }

    public void setActive(boolean state) {
        this.entityData.set(ACTIVE, (Object)state);
    }

    public boolean isActive() {
        return (Boolean)this.entityData.get(ACTIVE);
    }

    public abstract EntityType<? extends BossSpawnerContextAssignable> getBossEntityType();

    public abstract Vec3 getPlayerItemsDropPosition(Vec3 var1);

    public boolean hurt(DamageSource src, float damage) {
        return src.is(DamageTypes.GENERIC_KILL) || src.is(DamageTypes.FELL_OUT_OF_WORLD);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ACTIVE, (Object)true);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("active")) {
            this.setActive(tag.getBoolean("active"));
        } else {
            this.setActive(true);
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putBoolean("active", this.isActive());
    }

    public abstract boolean canInteractWithBlockPos(BlockPos var1);

    public abstract Component onArenaDestructionMessage();
}

