/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.client.particles.arc_preparation_particle.ArcAttackPreparationParticleOptions;
import com.finderfeed.fdbosses.client.particles.square_preparation_particle.RectanglePreparationParticleOptions;
import com.finderfeed.fdbosses.client.particles.stripe_particle.StripeParticleOptions;
import com.finderfeed.fdbosses.content.entities.BossDespawner;
import com.finderfeed.fdbosses.content.entities.FDDespawnable;
import com.finderfeed.fdbosses.content.entities.IEffectImmune;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerContextAssignable;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.BossMusicAreaCylinder;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthBossBuddy;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthBossInitializer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthDamageSource;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthSecondPhaseInitializer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthWeaknessHandler;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_boss_spawner.MalkuthBossSpawner;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_boulder.MalkuthBoulderEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_cannon.MalkuthCannonEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_cannon.MalkuthCannonProjectile;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_chain.MalkuthChainEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_crush.MalkuthCrushAttack;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_earthquake.MalkuthEarthquake;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_fireball.MalkuthFireball;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_floor.MalkuthFloorEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_giant_sword.MalkuthGiantSwordSlash;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_platform.MalkuthPlatform;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_repair_crystal.MalkuthRepairCrystal;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_repair_crystal.MalkuthRepairEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_slash.MalkuthSlashProjectile;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.packets.MalkuthChargeSwordPacket;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossBars;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossCriteriaTriggers;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEffects;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossModels;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdbosses.packets.SlamParticlesPacket;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.init.FDRenderTypes;
import com.finderfeed.fdlib.init.FDScreenEffects;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.network.lib_packets.PlaySoundInEarsPacket;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDMob;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.HeadControllerContainer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.IHasHead;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.ModelSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.BaseModelAttachmentData;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.ModelAttachmentData;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.instances.fdmodel.FDModelAttachmentData;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelInfo;
import com.finderfeed.fdlib.systems.cutscenes.CameraPos;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneData;
import com.finderfeed.fdlib.systems.cutscenes.EasingType;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackAction;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackChain;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackInstance;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackOptions;
import com.finderfeed.fdlib.systems.hud.bossbars.FDServerBossBar;
import com.finderfeed.fdlib.systems.impact_frames.ImpactFrame;
import com.finderfeed.fdlib.systems.music.data.FDMusicData;
import com.finderfeed.fdlib.systems.music.data.FDMusicPartData;
import com.finderfeed.fdlib.systems.music.music_areas.FDMusicArea;
import com.finderfeed.fdlib.systems.music.music_areas.FDMusicAreasHandler;
import com.finderfeed.fdlib.systems.music.music_areas.shapes.FDMusicAreaShape;
import com.finderfeed.fdlib.systems.render_types.FDRenderType;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectData;
import com.finderfeed.fdlib.systems.screen.screen_effect.instances.datas.ScreenColorData;
import com.finderfeed.fdlib.systems.shake.DefaultShakePacket;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.ProjectileMovementPath;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingUseTotemEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MalkuthEntity
extends FDMob
implements IHasHead<MalkuthEntity>,
MalkuthBossBuddy,
AutoSerializable,
BossSpawnerContextAssignable,
IEffectImmune,
FDDespawnable {
    public static final UUID BOSS_MUSIC_UUID = UUID.fromString("5c6cd8c0-7e3e-44a3-9c2e-2459a61377f3");
    public static float CHANCE_TO_CHOOSE_WEAK_TYPE = 0.75f;
    public static final Vec3 FIRE_PLAYER_CANNON_OFFSET = new Vec3(-6.5, -1.0, -25.0);
    public static final Vec3 ICE_PLAYER_CANNON_OFFSET = new Vec3(6.5, -1.0, -25.0);
    public UUID bossSpawnerUUID;
    public static final Vec3 WALL_OFFSET = new Vec3(0.0, 13.0, 27.85);
    public static final String MAIN_LAYER = "MAIN";
    public static final float ENRAGE_HEIGHT = 11.0f;
    public static final float ENRAGE_RADIUS = 29.0f;
    public static final String SLASH_ATTACK = "slash";
    public static final String JUMP_CRUSH = "jump_crush";
    public static final String PULL_AND_PUNCH = "pull_and_punch";
    public static final String JUMP_ON_WALL_COMMAND_CANNONS = "jump_on_wall_command_cannons";
    public static final String CAROUSEL_SLASHES = "carousel_slashes";
    public static final String JUMP_BACK_ON_SPAWN = "jump_back_on_spawn";
    public static final String JUMP_BACK_ON_SPAWN_WITH_CRUSH = "jump_back_on_spawn_with_crush";
    public static final String GIANT_SWORDS_ULTIMATE = "giant_swords_attack";
    public static final String SUMMON_AND_THROW_SIDE_ROCKS = "summon_and_throw_side_rocks";
    public static final String ATTACH_SWORDS = "attach_swords";
    public static final String DEATTACH_SWORDS = "deattach_swords";
    public static final String DELAY_20 = "nothing_20_ticks";
    public static final String DELAY_10 = "nothing_10_ticks";
    public static final String DELAY_5 = "nothing_5_ticks";
    public static final String SUMMON_EARTHQUAKE = "summon_earthquake";
    public static final String SUMMON_EARTHQUAKE_LOWER = "summon_earthquake_lower";
    public static final String PLATFORMS_N_FIREBALLS = "platforms_n_fireballs";
    private static FDModel SERVER_MODEL;
    private static FDModel CLIENT_MODEL;
    public static final UUID FIRE_SWORD_UUID;
    public static final UUID FIRE_SWORD_EMISSIVE_UUID;
    public static final UUID ICE_SWORD_UUID;
    public static final UUID ICE_SWORD_EMISSIVE_UUID;
    public static final ResourceLocation MALKUTH_SWORD_SOLID;
    public static final ResourceLocation MALKUTH_ICE_SWORD;
    public static final ResourceLocation MALKUTH_FIRE_SWORD;
    private FDServerBossBar bossbar = new FDServerBossBar(BossBars.MALKUTH_BOSS_BAR, (Entity)this);
    private HeadControllerContainer<MalkuthEntity> headControllerContainer;
    private AttackChain attackChain;
    @SerializableField
    public int pullAndPunchCooldown = 0;
    @SerializableField
    protected Vec3 spawnPosition;
    @SerializableField
    private MalkuthBossInitializer malkuthBossInitializer;
    @SerializableField
    private MalkuthSecondPhaseInitializer malkuthSecondPhaseInitializer;
    @SerializableField
    protected boolean lookAtTarget = true;
    @SerializableField
    private int hits = 10;
    @SerializableField
    private boolean allowedToBeDamaged = false;
    private int maxHits = 10;
    private boolean dropLoot = true;
    private Vec3 oldTargetPos;
    private BossDespawner<MalkuthEntity> bossDespawner;
    private static final Vec3[] PLATFORM_SPAWN_OFFSETS;
    private static final int[][] PLATFORM_ATTACK_PATTERN;
    private Vec3[] FLY_TO_OFFSETS = new Vec3[]{new Vec3(0.0, 7.0, 15.0), new Vec3(-15.0, 7.0, 12.0), new Vec3(15.0, 7.0, 12.0)};
    @SerializableField
    private int currentlyFlyingTo = -1;
    @SerializableField
    private ProjectileMovementPath startSummonPlatformsPath;
    private MalkuthAttackType earthquakeToSummon = MalkuthAttackType.FIRE;
    private MalkuthAttackType sideRocksCurrentType = MalkuthAttackType.FIRE;
    private ProjectileMovementPath jumpBackOnSpawnPath;
    private MalkuthAttackType jumpBackOnSpawnCrushType = MalkuthAttackType.FIRE;
    private MalkuthAttackType slashAttackType = MalkuthAttackType.FIRE;
    private ProjectileMovementPath jumpCrushAttackMovementPath;
    private List<Player> pullAndPunchTargets = new ArrayList<Player>();
    private ProjectileMovementPath jumpOnWallPath = null;
    private MalkuthAttackType currentStartCarouselSlash = MalkuthAttackType.FIRE;
    @SerializableField
    private MalkuthAttackType giantSwordUltimateStartAttackType = MalkuthAttackType.FIRE;

    public MalkuthEntity(EntityType<? extends FDMob> type, Level level) {
        super(type, level);
        if (level.isClientSide) {
            if (CLIENT_MODEL == null) {
                CLIENT_MODEL = new FDModel(BossModels.MALKUTH.get());
            }
        } else if (SERVER_MODEL == null) {
            SERVER_MODEL = new FDModel(BossModels.MALKUTH.get());
        }
        this.maxHits = BossConfigs.BOSS_CONFIG.get().malkuthConfig.malkuthMaxHits;
        this.hits = BossConfigs.BOSS_CONFIG.get().malkuthConfig.malkuthMaxHits;
        this.malkuthBossInitializer = new MalkuthBossInitializer(this);
        this.malkuthSecondPhaseInitializer = new MalkuthSecondPhaseInitializer(this);
        this.headControllerContainer = new HeadControllerContainer((Mob)this).addHeadController(CLIENT_MODEL, "head");
        this.lookControl = this.headControllerContainer;
        AttackOptions.ChainAttackOptions cannons = AttackOptions.chainOptionsBuilder().addAttack(JUMP_ON_WALL_COMMAND_CANNONS).addAttack(DELAY_5).addAttack(JUMP_BACK_ON_SPAWN).build();
        AttackOptions.ChainAttackOptions cannonsNoJumpBack = AttackOptions.chainOptionsBuilder().addAttack(JUMP_ON_WALL_COMMAND_CANNONS).addAttack(DELAY_5).build();
        AttackOptions.ChainAttackOptions jumpCrushEarthquake = AttackOptions.chainOptionsBuilder().addAttack(JUMP_CRUSH).addAttack(DELAY_10).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(JUMP_BACK_ON_SPAWN).build();
        AttackOptions.ChainAttackOptions jumpCrushEarthquakeNoJumpBack = AttackOptions.chainOptionsBuilder().addAttack(JUMP_CRUSH).addAttack(DELAY_10).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).build();
        AttackOptions.ChainAttackOptions jumpCrushEarthquakeJumpCrushEarthquake = AttackOptions.chainOptionsBuilder().addAttack(JUMP_CRUSH).addAttack(DELAY_10).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(JUMP_CRUSH).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(JUMP_CRUSH).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(JUMP_BACK_ON_SPAWN).build();
        AttackOptions.ChainAttackOptions jumpCrushEarthquakeJumpCrushEarthquakeNoJumpBack = AttackOptions.chainOptionsBuilder().addAttack(JUMP_CRUSH).addAttack(DELAY_10).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(JUMP_CRUSH).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(JUMP_CRUSH).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).build();
        AttackOptions.ChainAttackOptions jumpCrushSlashNEarthquake = AttackOptions.chainOptionsBuilder().addAttack(JUMP_CRUSH).addAttack(DELAY_10).addAttack(SLASH_ATTACK).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(SLASH_ATTACK).addAttack(DELAY_5).addAttack(JUMP_CRUSH).addAttack(DELAY_5).addAttack(JUMP_BACK_ON_SPAWN).build();
        AttackOptions.ChainAttackOptions jumpCrushSlashNEarthquakeNoJumpBack = AttackOptions.chainOptionsBuilder().addAttack(JUMP_CRUSH).addAttack(DELAY_10).addAttack(SLASH_ATTACK).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(SLASH_ATTACK).addAttack(DELAY_5).addAttack(JUMP_CRUSH).addAttack(DELAY_5).build();
        AttackOptions.ChainAttackOptions jumpCrushMoreSlashNEarthquake = AttackOptions.chainOptionsBuilder().addAttack(JUMP_CRUSH).addAttack(DELAY_10).addAttack(SLASH_ATTACK).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(SLASH_ATTACK).addAttack(DELAY_5).addAttack(SLASH_ATTACK).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(JUMP_BACK_ON_SPAWN).build();
        AttackOptions.ChainAttackOptions jumpCrushMoreSlashNEarthquakeNoJumpBack = AttackOptions.chainOptionsBuilder().addAttack(JUMP_CRUSH).addAttack(DELAY_10).addAttack(SLASH_ATTACK).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).addAttack(DELAY_5).addAttack(SLASH_ATTACK).addAttack(DELAY_5).addAttack(SLASH_ATTACK).addAttack(DELAY_5).addAttack(SUMMON_EARTHQUAKE).build();
        AttackOptions randomJumpCrush = AttackOptions.builder().addAttack((AttackOptions)jumpCrushEarthquake).addAttack((AttackOptions)jumpCrushEarthquakeJumpCrushEarthquake).addAttack((AttackOptions)jumpCrushSlashNEarthquake).addAttack((AttackOptions)jumpCrushMoreSlashNEarthquake).build();
        AttackOptions randomJumpCrushNoJumpBack = AttackOptions.builder().addAttack((AttackOptions)jumpCrushEarthquakeNoJumpBack).addAttack((AttackOptions)jumpCrushEarthquakeJumpCrushEarthquakeNoJumpBack).addAttack((AttackOptions)jumpCrushSlashNEarthquakeNoJumpBack).addAttack((AttackOptions)jumpCrushMoreSlashNEarthquakeNoJumpBack).build();
        AttackOptions.ChainAttackOptions slashOptions = AttackOptions.chainOptionsBuilder().addAttack(SLASH_ATTACK).addAttack(SLASH_ATTACK).addAttack(SLASH_ATTACK).addAttack(SLASH_ATTACK).addAttack(SLASH_ATTACK).build();
        AttackOptions.ChainAttackOptions carouselEarthquakes = AttackOptions.chainOptionsBuilder().addAttack(CAROUSEL_SLASHES).addAttack(SUMMON_EARTHQUAKE_LOWER).addAttack(CAROUSEL_SLASHES).addAttack(SUMMON_EARTHQUAKE_LOWER).addAttack(CAROUSEL_SLASHES).build();
        AttackOptions.ChainAttackOptions boulders = AttackOptions.chainOptionsBuilder().addAttack(DELAY_10).addAttack(DEATTACH_SWORDS).addAttack(SUMMON_AND_THROW_SIDE_ROCKS).addAttack(SUMMON_AND_THROW_SIDE_ROCKS).addAttack(SUMMON_AND_THROW_SIDE_ROCKS).addAttack(ATTACH_SWORDS).addAttack(DELAY_20).build();
        AttackOptions.ChainAttackOptions bouldersNCarousel = AttackOptions.chainOptionsBuilder().addAttack(SUMMON_AND_THROW_SIDE_ROCKS).addAttack(CAROUSEL_SLASHES).addAttack(SUMMON_AND_THROW_SIDE_ROCKS).addAttack(CAROUSEL_SLASHES).build();
        int id = 0;
        this.attackChain = new AttackChain(this.getRandom()).registerAttack(DELAY_5, v -> this.doNothingNTicks(v, 5)).registerAttack(DELAY_10, v -> this.doNothingNTicks(v, 10)).registerAttack(DELAY_20, v -> this.doNothingNTicks(v, 20)).registerAttack(DEATTACH_SWORDS, v -> this.attachSwordsAttack(v, false)).registerAttack(ATTACH_SWORDS, v -> this.attachSwordsAttack(v, true)).registerAttack(SLASH_ATTACK, this::aerialSlashAttack).registerAttack(PULL_AND_PUNCH, this::pullAndPunch).registerAttack(JUMP_CRUSH, this::jumpCrushAttack).registerAttack(CAROUSEL_SLASHES, this::carouselSlashesAttack).registerAttack(JUMP_BACK_ON_SPAWN, v -> this.jumpBackOnSpawn(v, this.isBelowHalfHP())).registerAttack(JUMP_ON_WALL_COMMAND_CANNONS, this::jumpAndCommandCannons).registerAttack(GIANT_SWORDS_ULTIMATE, this::giantSwordUltimate).registerAttack(SUMMON_AND_THROW_SIDE_ROCKS, this::summonAndThrowSideRocks).registerAttack(SUMMON_EARTHQUAKE, v -> this.summonEarthquake(v, 0)).registerAttack(SUMMON_EARTHQUAKE_LOWER, v -> this.summonEarthquake(v, -1)).registerAttack(PLATFORMS_N_FIREBALLS, this::fireballsNPlatforms).addAlwaysTryCastAttack(this::checkCanPunch, PULL_AND_PUNCH).addAttack(id++, (AttackOptions)slashOptions).addAttack(id++, randomJumpCrushNoJumpBack).addAttack(id++, (AttackOptions)cannonsNoJumpBack).addAttack(id++, randomJumpCrush).addAttack(id++, (AttackOptions)carouselEarthquakes).addAttack(id++, randomJumpCrushNoJumpBack).addAttack(id++, (AttackOptions)cannons).addAttack(id++, (AttackOptions)slashOptions).addAttack(id++, GIANT_SWORDS_ULTIMATE).addAttack(id++, randomJumpCrushNoJumpBack).addAttack(id++, (AttackOptions)cannons).addAttack(id++, (AttackOptions)slashOptions).addAttack(id++, randomJumpCrush).addAttack(id++, (AttackOptions)boulders).addAttack(id++, (AttackOptions)AttackOptions.chainOptionsBuilder().addAttack(JUMP_CRUSH).addAttack(DELAY_10).addAttack(PLATFORMS_N_FIREBALLS).build()).attackListener(this::attackListener);
        this.bossDespawner = new BossDespawner<MalkuthEntity>(this, new AABB(-100.0, -50.0, -100.0, 100.0, 50.0, 100.0), 50, MalkuthRepairCrystal.class, MalkuthCannonProjectile.class, MalkuthBoulderEntity.class, MalkuthGiantSwordSlash.class, MalkuthCrushAttack.class, MalkuthRepairEntity.class, MalkuthPlatform.class, MalkuthFloorEntity.class);
    }

    private boolean doNothingNTicks(AttackInstance instance, int tick) {
        return instance.tick >= tick;
    }

    public static FDModel getClientModel() {
        if (CLIENT_MODEL == null) {
            CLIENT_MODEL = new FDModel(BossModels.MALKUTH.get());
        }
        return CLIENT_MODEL;
    }

    public void tick() {
        if (!this.level().isClientSide && this.firstTick) {
            this.attachSwords();
        }
        super.tick();
        if (this.level().isClientSide) {
            this.headControllerContainer.clientTick();
        } else {
            this.pullAndPunchCooldown = Mth.clamp((int)(this.pullAndPunchCooldown - 1), (int)0, (int)Integer.MAX_VALUE);
            this.preventEnteringLavaField();
            this.bossbar.setPercentage((float)this.hits / (float)this.getMaxHits());
            AnimationSystem animationSystem = this.getAnimationSystem();
            if (this.malkuthBossInitializer.isFinished() && !this.isDeadOrDying()) {
                if (animationSystem.getTicker(MAIN_LAYER) == null) {
                    animationSystem.startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build());
                }
                if (!FDMusicAreasHandler.hasMusicArea((UUID)this.getUUID())) {
                    FDMusicAreasHandler.addArea((UUID)this.getUUID(), (FDMusicArea)this.constructMusicArea());
                }
            }
            if (!this.isDeadOrDying()) {
                if (this.malkuthBossInitializer.isFinished() && (!this.isBelowHalfHP() || this.malkuthSecondPhaseInitializer.isFinished())) {
                    this.attackChain.tick();
                    if (this.getTarget() != null) {
                        LivingEntity target = this.getTarget();
                        this.checkTarget(target);
                        if (this.lookAtTarget) {
                            this.getLookControl().setLookAt((Entity)target);
                        }
                    } else {
                        this.changeTarget();
                        if (this.getTarget() == null) {
                            this.getLookControl().setLookAt(this.position().add(this.getForward().multiply(100.0, 0.0, 100.0)));
                        }
                    }
                    this.bossDespawner.tick();
                } else if (!this.malkuthBossInitializer.isFinished()) {
                    this.malkuthBossInitializer.tick();
                } else if (!this.malkuthSecondPhaseInitializer.isFinished()) {
                    this.malkuthSecondPhaseInitializer.tick();
                }
            }
            if (this.getTarget() != null) {
                this.oldTargetPos = this.getTarget().position();
            }
            this.setYRot(this.yBodyRot);
        }
    }

    private FDMusicArea constructMusicArea() {
        return new FDMusicArea(this.level().dimension(), this.spawnPosition.add(0.0, -2.0, 0.0), (FDMusicAreaShape)new BossMusicAreaCylinder(29.0f, 19.0f), this.constructMusicData());
    }

    private FDMusicData constructMusicData() {
        return new FDMusicData(BOSS_MUSIC_UUID, new FDMusicPartData(BossSounds.MALKUTH_THEME_INTRO.get(), 14.75f)).addMusicPart(new FDMusicPartData(BossSounds.MALKUTH_THEME_MAIN.get(), 103.375f).setLooping(true)).fadeInTime(80).inactiveDeleteTime(600);
    }

    private void preventEnteringLavaField() {
        for (LivingEntity entity : BossTargetFinder.getEntitiesInArc(LivingEntity.class, this.level(), this.spawnPosition.add(0.0, -1.5, -0.7), new Vec2(0.0f, 1.0f), (float)Math.PI, 13.0f, 29.0f)) {
            if (entity instanceof MalkuthBossBuddy) continue;
            Vec3 speed = new Vec3(0.0, (double)0.025f, -1.0);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                FDLibCalls.setServerPlayerSpeed((ServerPlayer)serverPlayer, (Vec3)speed);
            } else {
                entity.setDeltaMovement(speed);
            }
            Vector3f col = MalkuthEntity.getAndRandomizeColor(MalkuthAttackType.FIRE, this.random);
            BallParticleOptions ballParticleOptions = BallParticleOptions.builder().color(col.x, col.y, col.z).scalingOptions(0, 0, 20).brightness(2).friction(0.7f).build();
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ballParticleOptions, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 25, (double)(entity.getBbWidth() / 2.0f), (double)(entity.getBbHeight() / 2.0f), (double)(entity.getBbWidth() / 2.0f), 0.5);
        }
    }

    public void hurtBoss(int amount) {
        if (this.allowedToBeDamaged) {
            this.hits = Math.clamp((long)(this.hits - amount), 0, this.maxHits);
            if (this.hits == 0) {
                this.kill();
            }
        }
    }

    public void die(DamageSource src) {
        this.dropLoot = false;
        for (MalkuthRepairCrystal repairCrystal : BossTargetFinder.getEntitiesInCylinder(MalkuthRepairCrystal.class, this.level(), this.spawnPosition.add(0.0, -3.0, 0.0), 30.0f, 40.0f)) {
            repairCrystal.remove(Entity.RemovalReason.DISCARDED);
        }
        this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_FLOAT).setToNullTransitionTime(0).build());
        this.getAnimationSystem().stopAnimation(MAIN_LAYER);
        Vec3 teleportPos = this.spawnPosition.add(WALL_OFFSET);
        this.teleportTo(teleportPos.x, teleportPos.y, teleportPos.z);
        this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.ANIMATION);
        this.lookAt(EntityAnchorArgument.Anchor.EYES, this.position().add(0.0, 0.0, -100.0));
        super.die(src);
        CutsceneData data = this.deathCutscene();
        for (ServerPlayer player : BossTargetFinder.getEntitiesInCylinder(ServerPlayer.class, this.level(), this.spawnPosition.subtract(0.0, 2.0, 0.0), 40.0f, 40.0f)) {
            FDLibCalls.startCutsceneForPlayer((ServerPlayer)player, (CutsceneData)data);
        }
    }

    private CutsceneData deathCutscene() {
        Vec3 base = this.spawnPosition;
        CameraPos last = new CameraPos(base.add(0.0, 16.119, 23.01), new Vec3(0.0, -0.27, 0.963));
        CutsceneData data1 = CutsceneData.create().addScreenEffect(0, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 0, 6, 30).timeEasing(EasingType.EASE_OUT).time(80).addCameraPos(new CameraPos(base.add(0.0, 16.119, 19.863), new Vec3(0.0, -0.182, 0.983))).addCameraPos(last);
        CutsceneData data2 = CutsceneData.create().addScreenEffect(219, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 0, 30, 30).addCameraPos(last).time(220);
        data1.nextCutscene(data2);
        return data1;
    }

    protected void tickDeath() {
        ++this.deathTime;
        int animStartTime = 5;
        int animEndtime = animStartTime + ((Animation)BossAnims.MALKUTH_DEATH.get()).getAnimTime();
        if (!this.level().isClientSide) {
            FDMusicAreasHandler.removeArea((MinecraftServer)((ServerLevel)this.level()).getServer(), (UUID)this.getUUID(), (int)40);
            if (this.deathTime == 1) {
                for (Player combatant : this.getCombatants(true)) {
                    if (combatant.isSpectator()) continue;
                    BossCriteriaTriggers.BOSS_KILLED.get().trigger((ServerPlayer)combatant, (Entity)this);
                }
            } else if (this.deathTime == animStartTime) {
                this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_DEATH).build());
            } else if (this.deathTime == animEndtime - 38) {
                DefaultShakePacket.send((ServerLevel)((ServerLevel)this.level()), (Vec3)this.spawnPosition, (double)40.0, (FDShakeData)FDShakeData.builder().amplitude(0.3f).outTime(30).build());
                for (ServerPlayer player : BossTargetFinder.getEntitiesInCylinder(ServerPlayer.class, this.level(), this.spawnPosition.subtract(0.0, 2.0, 0.0), 40.0f, 40.0f)) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlaySoundInEarsPacket(BossSounds.MALKUTH_HIT.get(), 0.75f, 1.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlaySoundInEarsPacket(BossSounds.MALKUTH_VOLCANO_ERRUPTION.get(), 1.75f, 1.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else if (this.deathTime == animEndtime - 37) {
                BossUtil.malkuthSwordsInsertParticles((ServerLevel)this.level(), this.spawnPosition, 100.0, this.getId());
            } else if (this.deathTime == animEndtime + 15) {
                this.dropLoot = true;
                Vector3f col1 = MalkuthEntity.getAndRandomizeColor(MalkuthAttackType.FIRE, this.random);
                Vector3f col2 = MalkuthEntity.getAndRandomizeColor(MalkuthAttackType.ICE, this.random);
                BallParticleOptions options = BallParticleOptions.builder().color(col1.x, col1.y, col1.z).scalingOptions(0, 0, 25).size(0.25f).brightness(2).friction(0.8f).build();
                BallParticleOptions options2 = BallParticleOptions.builder().color(col2.x, col2.y, col2.z).scalingOptions(0, 0, 25).size(0.25f).brightness(2).friction(0.8f).build();
                for (ServerPlayer player : BossTargetFinder.getEntitiesInCylinder(ServerPlayer.class, this.level(), this.spawnPosition.subtract(0.0, 2.0, 0.0), 40.0f, 40.0f)) {
                    player.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)options, true, this.getX(), this.getY(), this.getZ(), 1.0f, 1.0f, 1.0f, 0.75f, 400));
                    player.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)options2, true, this.getX(), this.getY(), this.getZ(), 1.0f, 1.0f, 1.0f, 0.75f, 400));
                }
                BossSpawnerEntity spawnerEntity = this.getSpawner();
                if (spawnerEntity != null) {
                    spawnerEntity.setActive(true);
                }
                this.teleportTo(this.spawnPosition.x, this.spawnPosition.y, this.spawnPosition.z);
                this.dropAllDeathLoot((ServerLevel)this.level(), this.level().damageSources().generic());
                this.setRemoved(Entity.RemovalReason.KILLED);
            }
        }
    }

    protected boolean shouldDropLoot() {
        return this.dropLoot;
    }

    public int getCurrentHits() {
        return this.hits;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void removeThingsForSecondPhase() {
        for (MalkuthCannonEntity malkuthCannonEntity : this.getMalkuthCannons()) {
            malkuthCannonEntity.cancelShot();
        }
        for (MalkuthCannonEntity malkuthCannonEntity : this.getPlayerCannons(false)) {
            malkuthCannonEntity.cancelShot();
        }
        for (MalkuthCannonProjectile malkuthCannonProjectile : BossTargetFinder.getEntitiesInCylinder(MalkuthCannonProjectile.class, this.level(), this.spawnPosition.add(0.0, -2.0, 0.0), 30.0f, 40.0f)) {
            malkuthCannonProjectile.remove(Entity.RemovalReason.DISCARDED);
        }
        this.getAnimationSystem().stopAnimation(MAIN_LAYER);
        this.attackChain.reset();
    }

    private AttackAction attackListener(String attack) {
        if (this.getTarget() == null) {
            return AttackAction.WAIT;
        }
        return AttackAction.PROCEED;
    }

    private boolean fireballsNPlatforms(AttackInstance inst) {
        int stage = inst.stage;
        int tick = inst.tick;
        if (stage == 0) {
            this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_JUMP_AND_CRUSH).setSpeed(1.25f).build());
            Vec3 between = this.spawnPosition.subtract(this.position());
            Vec3 midpos = this.position().add(between.multiply(0.4, 0.0, 0.4)).add(0.0, 15.0, 0.0);
            if (this.startSummonPlatformsPath == null) {
                this.startSummonPlatformsPath = new ProjectileMovementPath(15, false).addPos(this.position()).addPos(midpos).addPos(this.spawnPosition);
            }
            if (tick > 5) {
                this.startSummonPlatformsPath.tick((Entity)this);
                if (tick == 6) {
                    this.doJumpStartParticles(0.0f);
                }
            }
            if (tick == 25) {
                this.startSummonPlatformsPath = null;
                this.setDeltaMovement(Vec3.ZERO);
                this.teleportTo(this.spawnPosition.x, this.spawnPosition.y, this.spawnPosition.z);
                this.lookAt(EntityAnchorArgument.Anchor.FEET, this.position().add(0.0, 0.0, -100.0));
                inst.nextStage();
            }
        } else if (stage == 1) {
            if (tick == 1) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_SWORD_EARTH_IMPACT.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
                for (int i = 0; i < 20; ++i) {
                    this.malkuthEarthStrikeStripe(MalkuthAttackType.getRandom(this.random));
                }
                PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(5.0f).amplitude(2.5f).inTime(0).stayTime(0).outTime(5).build(), (Vec3)this.position(), (double)60.0);
                MalkuthFloorEntity malkuthFloorEntity = new MalkuthFloorEntity(BossEntities.MALKUTH_FLOOR.get(), this.level());
                malkuthFloorEntity.setPos(this.spawnPosition.add(0.0, -1.0, 0.0));
                this.level().addFreshEntity((Entity)malkuthFloorEntity);
                List<Player> combatants = this.getCombatants(true);
                for (Player player : combatants) {
                    if (!(Math.abs(player.getY() - this.spawnPosition.y) <= 3.0)) continue;
                    FDLibCalls.setServerPlayerSpeed((ServerPlayer)((ServerPlayer)player), (Vec3)new Vec3(0.0, 1.6, 0.0));
                }
                for (Vec3 offset : PLATFORM_SPAWN_OFFSETS) {
                    Vec3 pos = this.spawnPosition.add(offset);
                    MalkuthPlatform malkuthPlatform = new MalkuthPlatform(BossEntities.MALKUTH_PLATFORM.get(), this.level());
                    malkuthPlatform.setPos(pos);
                    this.level().addFreshEntity((Entity)malkuthPlatform);
                }
                inst.nextStage();
            }
        } else if (stage == 2) {
            if (tick == 0) {
                this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_JUMP_TO_FLOAT).nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_FLOAT).build()).build());
            }
            if (tick > 4) {
                BossUtil.malkuthFloatParticles((ServerLevel)this.level(), this);
                this.currentlyFlyingTo = 0;
                this.noPhysics = true;
                this.setNoGravity(true);
                inst.nextStage();
            }
        } else if (stage == 3) {
            BossUtil.malkuthFloatParticles((ServerLevel)this.level(), this);
            if (this.getTarget() != null) {
                this.lookAt(EntityAnchorArgument.Anchor.EYES, this.getTarget().position());
            }
            this.noPhysics = true;
            this.setNoGravity(true);
            int fireballTickStart = 30;
            int fireballTickEnd = fireballTickStart + PLATFORM_SPAWN_OFFSETS.length;
            int fireballLaunchTick = fireballTickEnd + 20;
            int cycleTime = fireballLaunchTick + 5;
            int currentCycle = tick / cycleTime;
            int localTick = tick % cycleTime;
            if (currentCycle > 6) {
                inst.nextStage();
                return false;
            }
            if (this.currentlyFlyingTo == -1) {
                this.currentlyFlyingTo = this.random.nextInt(this.FLY_TO_OFFSETS.length);
            }
            if (localTick == 0) {
                int old = this.currentlyFlyingTo;
                while (this.currentlyFlyingTo == old) {
                    this.currentlyFlyingTo = this.random.nextInt(this.FLY_TO_OFFSETS.length);
                }
                if (currentCycle == 0) {
                    this.currentlyFlyingTo = 0;
                }
            } else if (localTick < fireballTickStart) {
                Vec3 target = this.spawnPosition.add(this.FLY_TO_OFFSETS[this.currentlyFlyingTo]);
                this.moveToPos(target);
                int ticksToEnd = fireballTickStart - localTick;
                if (ticksToEnd == 7) {
                    this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_SUMMON_AND_FIRE_FIREBALLS).important().nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_FLOAT).build()).build());
                }
            } else if (localTick < fireballTickEnd) {
                MalkuthAttackType type;
                int id;
                int[] pattern = PLATFORM_ATTACK_PATTERN[currentCycle % PLATFORM_ATTACK_PATTERN.length];
                if (localTick == fireballTickStart) {
                    for (int i = 0; i < PLATFORM_SPAWN_OFFSETS.length; ++i) {
                        id = pattern[i];
                        type = id == 0 ? MalkuthAttackType.FIRE : MalkuthAttackType.ICE;
                        Vec3 offset = PLATFORM_SPAWN_OFFSETS[i];
                        Vec3 centerpos = this.spawnPosition.add(offset);
                        Vector3f color = MalkuthEntity.getMalkuthAttackPreparationParticleColor(type);
                        RectanglePreparationParticleOptions options = new RectanglePreparationParticleOptions(new Vec3(0.0, 0.0, -1.0), 5.0f, 1.5f, 30, 5, 10, color.x, color.y, color.z, 0.2f);
                        int dir = offset.dot(new Vec3(1.0, 0.0, 0.0)) < 0.0 ? 1 : -1;
                        Vec3 direction = new Vec3((double)dir, 0.0, 0.0);
                        RectanglePreparationParticleOptions options2 = new RectanglePreparationParticleOptions(direction, 5.0f, 1.5f, 30, 5, 10, color.x, color.y, color.z, 0.2f);
                        FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)options, (Vec3)centerpos.add(0.0, (double)1.06f, 2.5), (double)60.0);
                        FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)options2, (Vec3)centerpos.add(0.0, (double)1.061f, 0.0).add(direction.multiply(-2.5, 0.0, 0.0)), (double)60.0);
                    }
                }
                this.setDeltaMovement(Vec3.ZERO);
                int currentFireball = localTick - fireballTickStart;
                id = pattern[currentFireball];
                type = id == 0 ? MalkuthAttackType.FIRE : MalkuthAttackType.ICE;
                Vec3 forward = this.getForward().multiply(1.0, 0.0, 1.0).normalize();
                Vec3 left = forward.yRot(1.5707964f);
                Vec3 platformPos = this.spawnPosition.add(PLATFORM_SPAWN_OFFSETS[currentFireball]);
                float p = (float)currentFireball / (float)(PLATFORM_SPAWN_OFFSETS.length - 1);
                float angle = (float)Math.PI * p;
                Vector3f spawnOffset = new Quaternionf(new AxisAngle4d((double)angle, forward.x, forward.y, forward.z)).transform((float)left.x, (float)left.y, (float)left.z, new Vector3f()).mul(5.0f);
                Vec3 spawnPos = this.position().add((double)(spawnOffset.x * 0.3f), (double)(spawnOffset.y * 0.3f + 2.0f), (double)(spawnOffset.z * 0.3f));
                Vec3 gotoPos = spawnPos.add((double)spawnOffset.x, (double)spawnOffset.y, (double)spawnOffset.z);
                float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.fireballsDamage);
                MalkuthFireball malkuthFireball = MalkuthFireball.summon(type, this.level(), spawnPos, gotoPos, platformPos.add(0.0, 1.5, 0.0), damage);
            } else if (localTick == fireballLaunchTick) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_FIREBALL_LAUNCH.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
                for (MalkuthFireball fireball : this.level().getEntitiesOfClass(MalkuthFireball.class, new AABB(-20.0, -20.0, -20.0, 20.0, 20.0, 20.0).move(this.position()))) {
                    fireball.setMoveToTarget(12);
                }
            }
        } else if (stage == 4) {
            if (tick == 0) {
                this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_IDLE).important().build());
            }
            if (this.moveToPos(this.spawnPosition)) {
                this.noPhysics = false;
                this.setNoGravity(false);
                this.setDeltaMovement(Vec3.ZERO);
                this.teleportTo(this.spawnPosition.x, this.spawnPosition.y, this.spawnPosition.z);
                inst.nextStage();
            } else {
                BossUtil.malkuthFloatParticles((ServerLevel)this.level(), this);
            }
        } else if (stage == 5) {
            if (tick == 5) {
                for (Object platform : this.level().getEntitiesOfClass(MalkuthPlatform.class, new AABB(-29.0, -29.0, -29.0, 29.0, 29.0, 29.0).move(this.spawnPosition))) {
                    ((MalkuthPlatform)((Object)platform)).kill();
                }
                for (Object platform : this.level().getEntitiesOfClass(MalkuthFloorEntity.class, new AABB(-29.0, -29.0, -29.0, 29.0, 29.0, 29.0).move(this.spawnPosition))) {
                    ((MalkuthFloorEntity)((Object)platform)).kill();
                }
            } else if (tick >= 20) {
                return true;
            }
        }
        return false;
    }

    private void malkuthEarthStrikeStripe(MalkuthAttackType type) {
        float rndRadius = 4.0f + FDEasings.easeOut((float)this.random.nextFloat()) * 3.0f;
        Vec3 rnd = new Vec3((double)rndRadius, 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat());
        Vec3 dir = rnd.normalize();
        float startOffsetRand = 0.25f;
        Vec3 startOffset = dir.multiply((double)startOffsetRand, (double)startOffsetRand, (double)startOffsetRand);
        Vec3 stripePos = this.position().add(this.getForward().multiply(1.0, 0.0, 1.0).normalize()).add(startOffset);
        Vector3f colFire = MalkuthEntity.getMalkuthAttackPreparationParticleColor(type);
        FDColor fireColorStart = new FDColor(colFire.x, colFire.y - this.random.nextFloat() * 0.1f - 0.3f, colFire.z, 0.5f);
        FDColor fireColor = new FDColor(colFire.x, colFire.y + this.random.nextFloat() * 0.1f, colFire.z, 1.0f);
        float firstPointOffset = 1.0f + this.random.nextFloat() * 1.0f;
        float secondPointOffset = 3.0f + this.random.nextFloat() * 1.0f;
        StripeParticleOptions stripeParticleOptions = StripeParticleOptions.builder().startColor(fireColorStart).endColor(fireColor).lifetime(10).lod(50).scale(0.1f).stripePercentLength(0.5f).endOutPercent(0.2f).startInPercent(0.2f).offsets(new Vec3((double)0.01f, 0.0, 0.0), dir.multiply((double)firstPointOffset, 0.0, (double)firstPointOffset).add(0.0, 1.5, 0.0), dir.multiply((double)secondPointOffset, 0.0, (double)secondPointOffset).add(0.0, 3.5, 0.0), rnd.add(0.0, (double)(4.0f + this.random.nextFloat() * 2.0f), 0.0)).build();
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)stripeParticleOptions, stripePos.x, stripePos.y, stripePos.z, 0, 0.0, 0.0, 0.0, 0.0);
    }

    private boolean moveToPos(Vec3 target) {
        Vec3 thisPos = this.position();
        Vec3 between = target.subtract(thisPos);
        double len = between.length();
        if (len > 0.025) {
            float p = (float)Math.clamp(len / 15.0, 0.0, 1.0);
            float speed = (float)FDMathUtil.lerp((double)0.025, (double)2.0, (double)p);
            this.setDeltaMovement(between.normalize().multiply((double)speed, (double)speed, (double)speed));
            return false;
        }
        this.setDeltaMovement(Vec3.ZERO);
        return true;
    }

    private MalkuthAttackType chooseAttackTypeForTarget(LivingEntity target, float chanceToChooseWeakToType) {
        if (target instanceof Player) {
            Player player = (Player)target;
            MalkuthAttackType weakTo = MalkuthWeaknessHandler.getWeakTo(player);
            if (this.random.nextFloat() < chanceToChooseWeakToType) {
                return weakTo;
            }
            return MalkuthAttackType.getOpposite(weakTo);
        }
        return MalkuthAttackType.getRandom(this.random);
    }

    private boolean summonEarthquake(AttackInstance inst, int spawnYOffset) {
        int stage = inst.stage;
        int tick = inst.tick;
        if (stage == 0) {
            this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.ANIMATION);
            this.lookAtTarget = true;
            LivingEntity target = this.getTarget();
            this.lookAt(EntityAnchorArgument.Anchor.EYES, target.position());
            this.earthquakeToSummon = this.chooseAttackTypeForTarget(this.getTarget(), CHANCE_TO_CHOOSE_WEAK_TYPE);
            if (this.earthquakeToSummon.isFire()) {
                this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_SINGLE_EARTHQUAKE_FIRE).important().nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build()).build());
            } else {
                this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_SINGLE_EARTHQUAKE_ICE).important().nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build()).build());
            }
            inst.nextStage();
        } else if (stage == 1) {
            if (tick == 8) {
                Vec3 targetPos = this.getTarget() != null ? this.getTarget().position() : this.position().add(this.getForward().multiply(1.0, 0.0, 1.0).normalize().multiply(10.0, 10.0, 10.0));
                Vec3 direction = targetPos.subtract(this.position()).multiply(1.5, 0.0, 1.5);
                SlamParticlesPacket packet = new SlamParticlesPacket(new SlamParticlesPacket.SlamData(this.getOnPos(), this.position().add(0.0, 0.5, 0.0), direction.normalize()).maxAngle((float)Math.PI).maxSpeed(0.5f).collectRadius(2).maxParticleLifetime(30).count(40).maxVerticalSpeedEdges(0.15f).maxVerticalSpeedCenter(0.4f));
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_SWORD_EARTH_IMPACT.get(), SoundSource.HOSTILE, 3.0f, 1.0f + this.random.nextFloat() * 0.2f);
                double dist = direction.length();
                int time = (int)Math.ceil(dist * (double)0.9f);
                float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.impalingDoomDamage);
                float arcAngle = 0.47123894f;
                MalkuthEarthquake malkuthEarthquake = MalkuthEarthquake.summon(this.level(), this.earthquakeToSummon, this.position().add(0.0, (double)spawnYOffset, 0.0), direction, time, arcAngle, damage);
                for (LivingEntity e : BossTargetFinder.getEntitiesInCylinder(LivingEntity.class, this.level(), this.position().add(0.0, -0.1, 0.0), 4.0f, 1.0f, entity -> !(entity instanceof MalkuthBossBuddy))) {
                    e.hurt((DamageSource)new MalkuthDamageSource(BossDamageSources.MALKUTH_IMPALING_DOOM_SOURCE, this.earthquakeToSummon, 51), damage * 2.0f);
                }
            } else if (tick == 9) {
                PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(5.0f).amplitude(2.5f).inTime(0).stayTime(0).outTime(5).build(), (Vec3)this.position(), (double)60.0);
            } else if (tick >= 20) {
                this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.LOOK);
                return true;
            }
        }
        return false;
    }

    private boolean attachSwordsAttack(AttackInstance instance, boolean attach) {
        if (attach) {
            this.attachSwords();
            this.causeSwordChargeParticles(MalkuthAttackType.FIRE);
            this.causeSwordChargeParticles(MalkuthAttackType.ICE);
        } else {
            this.deattachSwords();
            this.causeSwordChargeParticles(MalkuthAttackType.FIRE);
            this.causeSwordChargeParticles(MalkuthAttackType.ICE);
        }
        return true;
    }

    private boolean summonAndThrowSideRocks(AttackInstance inst) {
        int stage = inst.stage;
        int lstage = stage % 3;
        int tick = inst.tick;
        if (lstage == 0) {
            this.deattachSwords();
            this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_SUMMON_THROW_SIDE_STONES).important().setSpeed(0.8f).nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build()).build());
            inst.nextStage();
        } else if (lstage == 1) {
            if (tick == 10) {
                int count = 8;
                float distForOne = 3.4f;
                Vec3 startPos = this.position().add(0.0, 0.1, -1.0);
                int h = this.random.nextInt(2);
                float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.sideRocksDamage);
                MalkuthAttackType currentType = this.sideRocksCurrentType;
                for (int i = 0; i < count; ++i) {
                    int k = h % 2 == 0 ? 1 : -1;
                    Vec3 clipdir = new Vec3((double)(k * 30), 0.0, 0.0);
                    Vec3 cliplastpos = startPos.add(clipdir);
                    ClipContext clipContext = new ClipContext(startPos, cliplastpos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
                    BlockHitResult ctx = this.level().clip(clipContext);
                    Vec3 location = ctx.getLocation();
                    double x = location.x - (double)k;
                    double r = startPos.x - x;
                    double y = this.getY() - 1.0;
                    double z = startPos.z;
                    Vec3 summonPos = new Vec3(x, y, z);
                    Vec3 moveToPos = new Vec3(x + r * 2.0, y, z);
                    ProjectileMovementPath movementPath = new ProjectileMovementPath(summonPos, 10, false).addPos(moveToPos);
                    MalkuthBoulderEntity malkuthBoulderEntity = MalkuthBoulderEntity.summon(this.level(), summonPos, 10, 3.0f, movementPath, currentType, damage);
                    Vector3f col = MalkuthEntity.getMalkuthAttackPreparationParticleColor(currentType);
                    RectanglePreparationParticleOptions rectanglePreparationParticleOptions = new RectanglePreparationParticleOptions(new Vec3((double)(-k), 0.0, 0.0), 56.0f, distForOne / 2.0f, 30, 10, 10, col.x, col.y, col.z, 0.25f);
                    Vec3 ppos = new Vec3(this.getX() + (double)(k * 28), y + (double)0.01f, z);
                    FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)rectanglePreparationParticleOptions, (Vec3)ppos, (double)60.0);
                    currentType = currentType.isFire() ? MalkuthAttackType.ICE : MalkuthAttackType.FIRE;
                    startPos = startPos.add(0.0, 0.0, (double)(-distForOne));
                    ++h;
                }
                this.sideRocksCurrentType = this.sideRocksCurrentType.isFire() ? MalkuthAttackType.ICE : MalkuthAttackType.FIRE;
            } else if (tick > 40) {
                List l = this.level().getEntitiesOfClass(MalkuthBoulderEntity.class, new AABB(-30.0, -30.0, -30.0, 30.0, 30.0, 30.0).move(this.position()));
                for (MalkuthBoulderEntity b : l) {
                    b.setShouldMoveToTarget(true);
                }
                inst.nextStage();
            }
        } else if (lstage == 2) {
            return true;
        }
        return false;
    }

    private boolean jumpBackOnSpawn(AttackInstance attackInstance, boolean crush) {
        int stage = attackInstance.stage;
        int tick = attackInstance.tick;
        ProjectileMovementPath path = this.jumpBackOnSpawnPath;
        if (this.jumpBackOnSpawnPath == null) {
            Vec3 thisPos = this.position();
            Vec3 target = this.spawnPosition;
            Vec3 between = target.subtract(thisPos);
            Vec3 pos1 = thisPos.add(between.multiply(0.25, 0.25, 0.25).add(0.0, 5.0, 0.0));
            Vec3 pos2 = thisPos.add(between.multiply(0.5, 0.5, 0.5).add(0.0, 8.0, 0.0));
            Vec3 pos3 = thisPos.add(between.multiply(0.75, 0.75, 0.75).add(0.0, 5.0, 0.0));
            this.jumpBackOnSpawnPath = path = new ProjectileMovementPath(20, false).addPos(thisPos).addPos(pos1).addPos(pos2).addPos(pos3).addPos(target);
            attackInstance.stage = 0;
            attackInstance.nextStage();
        }
        int earthquakesCount = 5;
        float angle = (float)Math.PI / (float)earthquakesCount;
        float radius = 28.0f;
        if (stage == 1) {
            Vec3 lastpos = (Vec3)this.jumpBackOnSpawnPath.getPositions().getLast();
            if (crush && tick == 10) {
                this.jumpEndEarthquakePrepareParticles(lastpos.add(0.0, -0.99, 0.0), earthquakesCount, angle, radius);
            }
            if (tick == 0) {
                this.jumpBackOnSpawnCrushType = MalkuthAttackType.getRandom(this.random);
                if (!crush) {
                    this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_JUMP_AND_LAND).nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build()).build());
                } else {
                    this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_JUMP_AND_CRUSH).nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build()).build());
                }
            } else if (tick > 5) {
                this.noPhysics = true;
                this.setNoGravity(true);
                this.getLookControl().setLookAt(lastpos);
                this.lookAtTarget = false;
                if (path.isFinished()) {
                    this.setDeltaMovement(Vec3.ZERO);
                    this.teleportTo(lastpos.x, lastpos.y, lastpos.z);
                    this.noPhysics = false;
                    this.setNoGravity(false);
                    this.lookAtTarget = true;
                    attackInstance.nextStage();
                } else {
                    path.tick((Entity)this);
                }
            }
        } else if (stage == 2) {
            int waitTime;
            if (tick == 3 && crush) {
                this.jumpEarthquake(this.position().add(0.0, -0.99, 0.0), earthquakesCount, angle, radius);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_SWORD_EARTH_IMPACT.get(), SoundSource.HOSTILE, 2.0f, 0.8f);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.ROCK_IMPACT.get(), SoundSource.HOSTILE, 2.0f, 0.8f);
            }
            this.noPhysics = false;
            this.setNoGravity(false);
            this.lookAtTarget = true;
            int n = waitTime = crush ? 30 : 10;
            if (tick == 0 && this.getTarget() != null) {
                this.lookAt(EntityAnchorArgument.Anchor.EYES, this.getTarget().position());
            }
            if (tick >= waitTime) {
                this.jumpBackOnSpawnPath = null;
                return true;
            }
        }
        return false;
    }

    private void jumpEndEarthquakePrepareParticles(Vec3 lastpos, int earthquakesCount, float angle, float radius) {
        MalkuthAttackType localType = this.jumpBackOnSpawnCrushType;
        for (int i = 0; i < earthquakesCount; ++i) {
            float currentAngle = (float)i * angle + angle / 2.0f;
            Vector3f col = MalkuthEntity.getMalkuthAttackPreparationParticleColor(localType);
            Vec3 v = new Vec3(1.0, 0.0, 0.0).yRot(currentAngle);
            ArcAttackPreparationParticleOptions options = new ArcAttackPreparationParticleOptions(v, radius, angle / 2.0f, 20, 5, 10, col.x, col.y, col.z, 0.25f);
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)options, lastpos.x, lastpos.y, lastpos.z, 1, 0.0, 0.0, 0.0, 0.0);
            localType = localType.isFire() ? MalkuthAttackType.ICE : MalkuthAttackType.FIRE;
        }
    }

    private void jumpEarthquake(Vec3 lastpos, int earthquakesCount, float angle, float radius) {
        MalkuthAttackType localType = this.jumpBackOnSpawnCrushType;
        float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.jumpBackOnSpawnCrushDamage);
        for (int i = 0; i < earthquakesCount; ++i) {
            float currentAngle = (float)i * angle + angle / 2.0f;
            Vec3 v = new Vec3((double)radius, 0.0, 0.0).yRot(currentAngle);
            MalkuthEarthquake earthquake = MalkuthEarthquake.summon(this.level(), localType, lastpos, v, 40, angle, damage);
            localType = localType.isFire() ? MalkuthAttackType.ICE : MalkuthAttackType.FIRE;
        }
        PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(5.0f).amplitude(5.0f).inTime(0).stayTime(0).outTime(5).build(), (Vec3)lastpos, (double)120.0);
    }

    private Animation getSlashAttackAnimation(MalkuthAttackType malkuthAttackType) {
        if (malkuthAttackType.isFire()) {
            return (Animation)BossAnims.MALKUTH_SLASH_FIRE.get();
        }
        return (Animation)BossAnims.MALKUTH_SLASH_ICE.get();
    }

    private boolean aerialSlashAttack(AttackInstance inst) {
        int stage = inst.stage;
        int tick = inst.tick;
        int localStage = stage % 3;
        if (localStage == 0) {
            this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.LOOK);
            this.slashAttackType = this.chooseAttackTypeForTarget(this.getTarget(), CHANCE_TO_CHOOSE_WEAK_TYPE);
            Animation animation = this.getSlashAttackAnimation(this.slashAttackType);
            AnimationTicker ticker = AnimationTicker.builder((Animation)animation).nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build()).important().build();
            this.getAnimationSystem().startAnimation(MAIN_LAYER, ticker);
            inst.nextStage();
        } else if (localStage == 1) {
            if (tick == 24) {
                Vec3 targetPos;
                Vec3 spawnPos = this.position().add(0.0, 1.5, 0.0);
                float speedMod = 1.0f;
                if (this.getTarget() != null) {
                    LivingEntity t = this.getTarget();
                    if (t.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                        speedMod = t.getEffect(MobEffects.MOVEMENT_SPEED).getAmplifier() + 1;
                    }
                    targetPos = t.position().add(0.0, (double)(t.getBbHeight() / 2.0f), 0.0);
                } else {
                    targetPos = this.position().add(this.getForward().multiply(100.0, 0.0, 100.0));
                }
                float spawnForwardOffset = -speedMod;
                spawnPos = spawnPos.add(this.getForward().multiply(1.0, 0.0, 1.0).multiply((double)spawnForwardOffset, (double)spawnForwardOffset, (double)spawnForwardOffset));
                Vec3 speedv = targetPos.subtract(spawnPos);
                double speed = Math.min(Math.max(2.0, speedv.length() * (double)0.15f) * (double)speedMod, 5.0);
                speedv = speedv.normalize().multiply(speed, speed, speed);
                float rotation = this.slashAttackType.isFire() ? 25.0f : -25.0f;
                float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.slashAttackDamage);
                MalkuthSlashProjectile malkuthSlashProjectile = MalkuthSlashProjectile.summon(this.level(), spawnPos, speedv, this.slashAttackType, damage, 2.2f, rotation, 0);
                for (LivingEntity e : BossTargetFinder.getEntitiesInCylinder(LivingEntity.class, this.level(), this.position().add(0.0, -0.1, 0.0), 4.0f, 1.0f, entity -> !(entity instanceof MalkuthBossBuddy))) {
                    e.hurt((DamageSource)new MalkuthDamageSource(BossDamageSources.MALKUTH_SLASHES_SOURCE, this.slashAttackType, 33), damage * 2.0f);
                }
            } else if (tick == 20) {
                this.playSlashSound();
            } else if (tick >= 28) {
                inst.nextStage();
            } else if (tick == 8) {
                this.causeSwordChargeParticles(this.slashAttackType);
                for (int i = 0; i < 6; ++i) {
                    this.doSwordChargeStripe(this.slashAttackType, 3.0f, 0.5f, 0.25f, false);
                }
            }
        } else if (localStage == 2) {
            return this.getTarget() != null;
        }
        return false;
    }

    private boolean jumpCrushAttack(AttackInstance inst) {
        int stage = inst.stage;
        int tick = inst.tick;
        if (stage == 0) {
            this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_CRUSH_ATTACK_FULL).setLoopMode(Animation.LoopMode.ONCE).nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build()).build());
            if (tick == 5) {
                this.jumpCrushAttackMovementPath = this.createJumpCrushAttackMovementPath(15);
                this.lookAt(EntityAnchorArgument.Anchor.FEET, (Vec3)this.jumpCrushAttackMovementPath.getPositions().getLast());
                inst.nextStage();
            }
        } else if (stage == 1) {
            if (tick == 1) {
                this.doJumpStartParticles(-2.0f);
            }
            this.setNoGravity(true);
            this.noPhysics = true;
            this.jumpCrushAttackMovementPath.tick((Entity)this);
            this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.ANIMATION);
            if (this.jumpCrushAttackMovementPath.isFinished()) {
                Vec3 lastPos = (Vec3)this.jumpCrushAttackMovementPath.getPositions().getLast();
                Vec3 between = lastPos.subtract(this.position());
                double dist = between.length();
                if (dist < 0.5) {
                    inst.nextStage();
                } else {
                    this.setDeltaMovement(between.multiply(0.5, 0.5, 0.5));
                }
            } else if (tick < 20 && this.getTarget() != null) {
                this.jumpCrushAttackMovementPath.getPositions().set(this.jumpCrushAttackMovementPath.getPositions().size() - 1, this.getTarget().position());
            }
        } else if (stage == 2) {
            this.setNoGravity(false);
            this.noPhysics = false;
            if (tick == 5) {
                Vec3 basePos = this.position().add(this.getForward().multiply(1.0, 0.0, 1.0).normalize());
                Vec3 actualPos = this.findGroundPosForCrush(basePos);
                if (this.isBelowHalfHP()) {
                    this.summonRepairCrystal(actualPos);
                }
                float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.earthshatterDamage);
                MalkuthCrushAttack malkuthCrushAttack = MalkuthCrushAttack.summon(this.level(), actualPos, damage);
                PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(5.0f).amplitude(5.0f).inTime(0).stayTime(0).outTime(5).build(), (Vec3)malkuthCrushAttack.position(), (double)120.0);
                this.level().playSound(null, malkuthCrushAttack.getX(), malkuthCrushAttack.getY(), malkuthCrushAttack.getZ(), BossSounds.MALKUTH_SWORD_EARTH_IMPACT.get(), SoundSource.HOSTILE, 2.0f, 0.8f);
                this.level().playSound(null, malkuthCrushAttack.getX(), malkuthCrushAttack.getY(), malkuthCrushAttack.getZ(), BossSounds.ROCK_IMPACT.get(), SoundSource.HOSTILE, 2.0f, 0.8f);
            } else if (tick >= 10) {
                return true;
            }
        }
        return false;
    }

    private void summonRepairCrystal(Vec3 pos) {
        Vec3 posBelow = pos.add(0.0, -20.0, 0.0);
        BlockHitResult result = this.level().clip(new ClipContext(pos, posBelow, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
        pos = result.getLocation();
        if (!BossTargetFinder.isPointInCylinder(pos, this.spawnPosition.add(0.0, -2.0, 0.0), 21.0f, 29.0f)) {
            return;
        }
        List<MalkuthRepairCrystal> crystals = BossTargetFinder.getEntitiesInCylinder(MalkuthRepairCrystal.class, this.level(), this.spawnPosition.add(0.0, -2.0, 0.0), 20.0f, 30.0f);
        List<MalkuthCannonEntity> playerCannons = this.getPlayerCannons(true);
        int spawnedCrystals = crystals.size();
        int cannonsAmount = playerCannons.size();
        if (crystals.size() == playerCannons.size()) {
            return;
        }
        int fireCrystals = (int)crystals.stream().filter(c -> c.getCrystalType().isFire()).count();
        int iceCrystals = spawnedCrystals - fireCrystals;
        int fireCannons = (int)playerCannons.stream().filter(cannon -> cannon.getCannonType().isFire()).count();
        int iceCannons = cannonsAmount - fireCannons;
        if (fireCrystals >= fireCannons && iceCrystals >= iceCannons) {
            return;
        }
        MalkuthAttackType finalType = fireCrystals >= fireCannons ? MalkuthAttackType.ICE : (iceCrystals >= iceCannons ? MalkuthAttackType.FIRE : MalkuthAttackType.getRandom(this.random));
        MalkuthRepairCrystal malkuthRepairCrystal = new MalkuthRepairCrystal(BossEntities.MALKUTH_REPAIR_CRYSTAL.get(), this.level());
        malkuthRepairCrystal.getEntityData().set(MalkuthRepairCrystal.CRYSTAL_TYPE, (Object)finalType);
        malkuthRepairCrystal.setPos(pos);
        this.level().addFreshEntity((Entity)malkuthRepairCrystal);
    }

    private Vec3 findGroundPosForCrush(Vec3 crushBasePos) {
        Vec3 end = crushBasePos.add(0.0, -5.0, 0.0);
        ClipContext clipContext = new ClipContext(crushBasePos, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
        BlockHitResult res = this.level().clip(clipContext);
        if (res.getType() == HitResult.Type.BLOCK) {
            return res.getLocation();
        }
        return crushBasePos;
    }

    private ProjectileMovementPath createJumpCrushAttackMovementPath(int flyTime) {
        Vec3 target = this.getTarget() != null ? this.getTarget().position() : this.position().add(this.getForward().multiply(1.0, 0.0, 1.0).normalize().multiply(10.0, 0.0, 10.0));
        Vec3 begin = this.position();
        Vec3 between = target.subtract(begin);
        Vec3 pos1 = this.position().add(between.multiply(0.25, 0.25, 0.25)).add(0.0, 9.0, 0.0);
        Vec3 pos2 = this.position().add(between.multiply((double)0.33f, (double)0.33f, (double)0.33f)).add(0.0, 13.0, 0.0);
        Vec3 pos3 = this.position().add(between.multiply(0.5, 0.5, 0.5)).add(0.0, 9.0, 0.0);
        ProjectileMovementPath path = new ProjectileMovementPath(begin, flyTime, false).addPos(pos1).addPos(pos2).addPos(pos3).addPos(target);
        return path;
    }

    private boolean checkCanPunch() {
        if (this.pullAndPunchCooldown > 0) {
            return false;
        }
        AABB box = new AABB(-29.0, 5.0, -29.0, 29.0, 29.0, 29.0).move(this.position());
        List players = this.level().getEntitiesOfClass(Player.class, box);
        return !players.isEmpty();
    }

    private List<Player> getPullAndPunchTargets() {
        AABB box = new AABB(-29.0, 4.0, -29.0, 29.0, 29.0, 29.0).move(this.position());
        return new ArrayList<Player>(this.level().getEntitiesOfClass(Player.class, box, player -> !player.isCreative() && !player.isSpectator()));
    }

    private boolean pullAndPunch(AttackInstance inst) {
        int stage = inst.stage;
        int tick = inst.tick;
        if (stage == 0) {
            if (this.getTarget() != null) {
                this.lookAt(EntityAnchorArgument.Anchor.EYES, this.getTarget().position());
            }
            this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_PULL_AND_PUNCH).nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build()).build());
            this.pullAndPunchTargets = this.getPullAndPunchTargets();
            inst.nextStage();
        } else if (stage == 1) {
            this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.LOOK);
            if (tick == 6) {
                this.causeSwordChargeParticles(MalkuthAttackType.ICE);
                this.deattachIceSword();
            } else if (tick == 10) {
                if (this.getTarget() == null) {
                    this.causeSwordChargeParticles(MalkuthAttackType.ICE);
                    this.attachIceSword();
                    this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build());
                    return true;
                }
                if (this.pullAndPunchTargets.isEmpty()) {
                    this.pullAndPunchTargets = this.getPullAndPunchTargets();
                }
                for (Player target : this.pullAndPunchTargets) {
                    Vec3 pullToPos = this.position().add(0.0, 2.5, 0.0).add(this.getForward().multiply(1.0, 0.0, 1.0).normalize().multiply(2.0, 2.0, 2.0));
                    MalkuthChainEntity malkuthChainEntity = MalkuthChainEntity.summon(this.level(), this, MalkuthAttackType.ICE, pullToPos, (LivingEntity)target, 10, 10);
                }
                inst.nextStage();
            }
        } else if (stage == 2) {
            if (tick > 0 && tick < 11) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_CHAIN_PULL.get(), SoundSource.HOSTILE, 2.5f, 0.85f);
            } else if (tick < 21) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_CHAIN_PULL.get(), SoundSource.HOSTILE, 2.5f, 0.9f);
            }
            if (tick == 10) {
                this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.ANIMATION);
            } else if (tick == 21) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_PUNCH.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
            } else if (tick == 25) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.CHESED_CRYSTAL_HIT.get(), SoundSource.HOSTILE, 2.0f, 0.5f);
                Vector3f pos = this.getModelPartPosition((Entity)this, MalkuthEntity.getMalkuthSwordPlaceBone(MalkuthAttackType.ICE), SERVER_MODEL);
                Vector3f col = MalkuthEntity.getMalkuthAttackPreparationParticleColor(MalkuthAttackType.ICE);
                FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)BallParticleOptions.builder().size(5.0f).scalingOptions(0, 0, 2).color(col.x, col.y, col.z).brightness(2).build(), (Vec3)this.position().add((double)pos.x, (double)pos.y, (double)pos.z), (double)60.0);
                float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.pullAndPunchDamage);
                for (MalkuthChainEntity chain : this.level().getEntitiesOfClass(MalkuthChainEntity.class, this.getBoundingBox().inflate(20.0, 20.0, 20.0))) {
                    ArrayList passengers = new ArrayList(chain.getPassengers());
                    chain.ejectPassengers();
                    chain.setRemoved(Entity.RemovalReason.DISCARDED);
                    Vec3 forward = this.getForward().multiply(1.0, 0.0, 1.0).normalize();
                    for (Entity e : passengers) {
                        if (!(e instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)e;
                        livingEntity.hurt(BossDamageSources.MALKUTH_CHAINPUNCH_SOURCE, damage);
                        Vec3 speed = forward.multiply(6.0, 6.0, 6.0).add(0.0, -1.0, 0.0);
                        if (livingEntity instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)livingEntity;
                            FDLibCalls.setServerPlayerSpeed((ServerPlayer)player, (Vec3)speed);
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 33, 0, true, false));
                            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 5, 0, true, false));
                            player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0, true, false));
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DefaultShakePacket(FDShakeData.builder().stayTime(0).inTime(0).outTime(35).amplitude(0.2f).build()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            continue;
                        }
                        livingEntity.setDeltaMovement(speed);
                    }
                }
            } else if (tick == 35) {
                this.causeSwordChargeParticles(MalkuthAttackType.ICE);
                this.attachIceSword();
                this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.LOOK);
            } else if (tick >= 40) {
                this.pullAndPunchCooldown = BossConfigs.BOSS_CONFIG.get().malkuthConfig.chainpunchCooldown;
                return true;
            }
        }
        return false;
    }

    private boolean jumpAndCommandCannons(AttackInstance attackInstance) {
        this.allowedToBeDamaged = true;
        this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.ANIMATION);
        this.lookAtTarget = false;
        this.getLookControl().setLookAt(this.position().add(0.0, 0.0, -100.0));
        int stage = attackInstance.stage;
        int tick = attackInstance.tick;
        if (stage == 0) {
            for (MalkuthCannonEntity cannon : BossTargetFinder.getEntitiesInCylinder(MalkuthCannonEntity.class, this.level(), this.spawnPosition.add(0.0, -5.0, 0.0), 20.0f, 35.0f)) {
                cannon.setBroken(false);
            }
            this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_JUMP_AND_LAND).important().nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build()).build());
            this.jumpOnWallPath = this.makeJumpOnWallPath(23, false);
            attackInstance.nextStage();
        } else if (stage == 1) {
            if (this.jumpOnWallPath == null) {
                this.jumpOnWallPath = this.makeJumpOnWallPath(23, false);
            }
            if (tick >= 6) {
                if (tick == 6) {
                    this.doJumpStartParticles(0.0f);
                }
                this.jumpOnWallPath.tick((Entity)this);
                this.noPhysics = true;
                this.setNoGravity(true);
            }
            if (this.jumpOnWallPath.isFinished()) {
                this.lookAt(EntityAnchorArgument.Anchor.EYES, this.position().add(0.0, 0.0, -100.0));
                Vec3 last = (Vec3)this.jumpOnWallPath.getPositions().getLast();
                this.setNoGravity(false);
                this.noPhysics = false;
                this.teleportTo(last.x, last.y, last.z);
                attackInstance.nextStage();
                this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_SWORD_FORWARD).setToNullTransitionTime(0).build());
            }
        } else if (stage == 2) {
            int start = 6;
            int t = tick - start;
            if (t >= 160) {
                attackInstance.nextStage();
            }
            if (t % 40 == 0) {
                this.shootCannons();
            }
        } else if (stage == 3) {
            if (tick > 60) {
                this.allowedToBeDamaged = false;
                this.lookAtTarget = true;
                this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.LOOK);
                return true;
            }
            return false;
        }
        return false;
    }

    private void shootCannons() {
        this.shootCannons(5);
    }

    private void shootCannons(int amountPerPoint) {
        List<MalkuthCannonEntity> cannons = this.getMalkuthCannons();
        if (cannons.isEmpty()) {
            return;
        }
        List<Player> combatants = this.getCombatants(false);
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        for (Player combatant : combatants) {
            for (int i = 0; i < 4; ++i) {
                Vec3 p = combatant.position().add((double)(this.random.nextFloat() * 8.0f - 4.0f), 0.0, (double)(this.random.nextFloat() * 8.0f - 4.0f));
                positions.add(p);
            }
            positions.add(combatant.position());
        }
        Vec3 start = this.spawnPosition.add(0.0, -1.0, 0.0);
        Vec3 v = new Vec3(0.0, 0.0, -16.5);
        float rndRadius = 14.5f;
        for (int i = 0; i < 3; ++i) {
            Vec3 p1 = start.add(v.yRot((float)i * (float)Math.PI / 8.0f));
            Vec3 p2 = start.add(v.yRot((float)(-i) * (float)Math.PI / 8.0f));
            for (int k = 0; k < amountPerPoint; ++k) {
                Vec3 rndPos = p1.add((double)(this.random.nextFloat() * 2.0f * rndRadius - rndRadius), 0.0, (double)(this.random.nextFloat() * 2.0f * rndRadius - rndRadius));
                Vec3 rndPos2 = p2.add((double)(this.random.nextFloat() * 2.0f * rndRadius - rndRadius), 0.0, (double)(this.random.nextFloat() * 2.0f * rndRadius - rndRadius));
                positions.add(rndPos);
                if (i == 0) continue;
                positions.add(rndPos2);
            }
        }
        int baseAmountPerCannon = positions.size() / cannons.size();
        int spreadAmount = baseAmountPerCannon * cannons.size();
        HashMap<MalkuthCannonEntity, List> cannonTargets = new HashMap<MalkuthCannonEntity, List>();
        int currentCannon = 0;
        while (!positions.isEmpty()) {
            Vec3 pos = (Vec3)positions.removeFirst();
            MalkuthCannonEntity cannon = cannons.get(currentCannon);
            cannonTargets.computeIfAbsent(cannon, c -> new ArrayList()).add(pos);
            currentCannon = (currentCannon + 1) % cannons.size();
            if (--spreadAmount > 0) continue;
            currentCannon = this.random.nextInt(cannons.size());
        }
        float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.cannonDamage);
        for (Map.Entry entry : cannonTargets.entrySet()) {
            MalkuthCannonEntity cannon = (MalkuthCannonEntity)entry.getKey();
            cannon.shoot((List)entry.getValue(), damage);
        }
    }

    private ProjectileMovementPath makeJumpOnWallPath(int time, boolean reversed) {
        Vec3 start = this.position();
        Vec3 offset = WALL_OFFSET;
        Vec3 end = this.spawnPosition.add(offset);
        double yDiff = end.y - start.y;
        Vec3 hoffset = end.subtract(start).multiply(1.0, 0.0, 1.0);
        Vec3 v1 = start.add(hoffset.multiply(0.25, 0.25, 0.25).add(0.0, yDiff + 5.0, 0.0));
        Vec3 v2 = start.add(hoffset.multiply(0.5, 0.5, 0.5).add(0.0, yDiff + 10.0, 0.0));
        Vec3 v3 = start.add(hoffset.multiply(0.75, 0.75, 0.75).add(0.0, yDiff + 5.0, 0.0));
        ProjectileMovementPath path = new ProjectileMovementPath(time, false);
        if (!reversed) {
            path.addPos(start);
            path.addPos(v1);
            path.addPos(v2);
            path.addPos(v3);
            path.addPos(end);
        } else {
            path.addPos(end);
            path.addPos(v3);
            path.addPos(v2);
            path.addPos(v1);
            path.addPos(start);
        }
        return path;
    }

    protected void doJumpStartParticles(float verticalOffset) {
        SlamParticlesPacket packet = new SlamParticlesPacket(new SlamParticlesPacket.SlamData(this.getOnPos(), this.position().add(0.0, (double)verticalOffset, 0.0), new Vec3(1.0, 0.0, 0.0)).maxAngle((float)Math.PI * 2).maxSpeed(0.3f).collectRadius(2).maxParticleLifetime(30).count(20).maxVerticalSpeedEdges(0.15f).maxVerticalSpeedCenter(0.15f));
        PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void hideRepairCrystals(boolean hide) {
        for (MalkuthRepairCrystal crystal : BossTargetFinder.getEntitiesInCylinder(MalkuthRepairCrystal.class, this.level(), this.spawnPosition.add(0.0, -2.0, 0.0), 10.0f, 40.0f)) {
            crystal.setHidden(hide);
        }
    }

    private boolean carouselSlashesAttack(AttackInstance attackInstance) {
        int stage = attackInstance.stage;
        int tick = attackInstance.tick;
        int preparationTime = 20;
        float radius = 30.0f;
        Vec3 startVec = new Vec3(1.0, 0.0, 0.0);
        int slashesAmount = 10;
        this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.ANIMATION);
        if (tick == 0) {
            this.hideRepairCrystals(true);
            this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_CAROUSEL_SLASH_1).important().nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build()).build());
            float angle = (float)Math.PI / (float)slashesAmount;
            MalkuthAttackType localCarouselSlash = this.currentStartCarouselSlash;
            for (int i = 0; i < slashesAmount; ++i) {
                Vec3 direction = startVec.yRot((float)i * angle + angle / 2.0f);
                Vector3f col = MalkuthEntity.getMalkuthAttackPreparationParticleColor(localCarouselSlash);
                ArcAttackPreparationParticleOptions options = new ArcAttackPreparationParticleOptions(direction, radius, angle / 2.0f, preparationTime, 10, 10, col.x, col.y, col.z, 0.25f);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)options, this.getX(), this.getY() - 0.99, this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                localCarouselSlash = localCarouselSlash.isFire() ? MalkuthAttackType.ICE : MalkuthAttackType.FIRE;
            }
        } else if (tick == preparationTime) {
            float angle = (float)Math.PI / (float)slashesAmount;
            float maxSlashSize = (float)Math.sqrt(2.0f * radius * radius * (1.0f - (float)Math.cos(angle))) / 2.0f;
            float slashSpeed = 2.5f;
            int reachDestinationTime = Math.round(radius / slashSpeed);
            float verticalSpeed = -1.0f / (float)reachDestinationTime;
            MalkuthAttackType localCarouselSlash = this.currentStartCarouselSlash;
            float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.arcSlashesDamage);
            this.playSlashSound();
            for (int i = 0; i < slashesAmount; ++i) {
                Vec3 direction = startVec.yRot((float)i * angle + angle / 2.0f);
                Vec3 speed = direction.multiply((double)slashSpeed, (double)slashSpeed, (double)slashSpeed);
                speed = speed.add(0.0, (double)(verticalSpeed * 0.15f), 0.0);
                MalkuthSlashProjectile.summon(this.level(), this.position().add(0.0, 0.25, 0.0), speed, localCarouselSlash, damage, maxSlashSize + 2.0f, 0.0f, reachDestinationTime);
                localCarouselSlash = localCarouselSlash.isFire() ? MalkuthAttackType.ICE : MalkuthAttackType.FIRE;
            }
            for (LivingEntity entity : BossTargetFinder.getEntitiesInCylinder(LivingEntity.class, this.level(), this.position().add(0.0, -2.0, 0.0), 5.0f, 2.0f)) {
                MalkuthAttackType malkuthAttackType;
                if (entity instanceof MalkuthBossBuddy) continue;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    malkuthAttackType = MalkuthWeaknessHandler.getWeakTo(player);
                } else {
                    malkuthAttackType = MalkuthAttackType.getRandom(this.random);
                }
                entity.hurt((DamageSource)new MalkuthDamageSource(BossDamageSources.MALKUTH_SLASHES_SOURCE, malkuthAttackType, 33), damage);
            }
            this.currentStartCarouselSlash = this.currentStartCarouselSlash.isFire() ? MalkuthAttackType.ICE : MalkuthAttackType.FIRE;
        } else if (tick >= preparationTime + 20) {
            this.hideRepairCrystals(false);
            return true;
        }
        return false;
    }

    private void playSlashSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_SLASH.get(), SoundSource.HOSTILE, 2.0f, 1.0f + this.random.nextFloat() * 0.5f);
    }

    public static Vector3f getAndRandomizeColor(MalkuthAttackType malkuthAttackType, RandomSource random) {
        Vector3f color = MalkuthEntity.getMalkuthAttackPreparationParticleColor(malkuthAttackType);
        color.x = Math.clamp(color.x + random.nextFloat() * 0.2f, 0.0f, 1.0f);
        color.y = Math.clamp(color.y + random.nextFloat() * 0.2f, 0.0f, 1.0f);
        color.z = Math.clamp(color.z + random.nextFloat() * 0.2f, 0.0f, 1.0f);
        return color;
    }

    public static Vector3f getMalkuthAttackPreparationParticleColor(MalkuthAttackType attackType) {
        float b;
        float g;
        float r;
        if (attackType.isFire()) {
            r = 1.0f;
            g = 0.4f;
            b = 0.1f;
        } else {
            r = 0.1f;
            g = 0.8f;
            b = 1.0f;
        }
        return new Vector3f(r, g, b);
    }

    public boolean giantSwordUltimate(AttackInstance inst) {
        this.allowedToBeDamaged = false;
        int stage = inst.stage;
        int tick = inst.tick;
        if (stage == 0) {
            AABB firstBox = new AABB(0.0, -2.0, -29.0, 29.0, 10.0, 0.0).move(this.spawnPosition);
            AABB secondBox = new AABB(-29.0, -2.0, -29.0, 0.0, 10.0, 0.0).move(this.spawnPosition);
            List players = this.level().getEntitiesOfClass(Player.class, firstBox, player -> true);
            if (players.isEmpty()) {
                players = this.level().getEntitiesOfClass(Player.class, secondBox, player -> true);
                if (!players.isEmpty()) {
                    Player firstPlayer = (Player)players.getFirst();
                    MalkuthAttackType weakTo = MalkuthWeaknessHandler.getWeakTo(firstPlayer);
                    this.giantSwordUltimateStartAttackType = MalkuthAttackType.getOpposite(weakTo);
                }
            } else {
                MalkuthAttackType weakTo;
                Player firstPlayer = (Player)players.getFirst();
                this.giantSwordUltimateStartAttackType = weakTo = MalkuthWeaknessHandler.getWeakTo(firstPlayer);
            }
            this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_GIANT_SWORD_ATTACK).setLoopMode(Animation.LoopMode.HOLD_ON_LAST_FRAME).build());
            this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.ANIMATION);
            this.lookAtTarget = false;
            this.getLookControl().setLookAt(new Vec3(0.0, 0.0, -100.0).add(this.position()));
            inst.nextStage();
        } else if (stage == 1) {
            int swordSpawnTick = 12;
            int particlesStart = swordSpawnTick - 3;
            int particlesEnd = swordSpawnTick + 40;
            if (tick >= particlesStart && tick < particlesEnd && tick % 3 == 0) {
                BossUtil.malkuthSwordChargeParticles((ServerLevel)this.level(), MalkuthAttackType.FIRE, this, 60.0);
                BossUtil.malkuthSwordChargeParticles((ServerLevel)this.level(), MalkuthAttackType.ICE, this, 60.0);
                float sizeModifier = (float)(tick - particlesStart) / (float)(particlesEnd - particlesStart);
                this.doSwordChargeStripe(MalkuthAttackType.FIRE, 1.75f, sizeModifier);
                this.doSwordChargeStripe(MalkuthAttackType.ICE, 1.75f, sizeModifier);
            }
            if (this.isBelowHalfHP() && tick < swordSpawnTick + MalkuthGiantSwordSlash.TIME_TO_RISE && tick % 25 == 0) {
                this.shootCannons(3);
            }
            if (tick == swordSpawnTick - 5) {
                this.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(0.0, 0.0, -100.0).add(this.position()));
                Vector3f red = MalkuthEntity.getMalkuthAttackPreparationParticleColor(this.giantSwordUltimateStartAttackType);
                Vector3f blue = MalkuthEntity.getMalkuthAttackPreparationParticleColor(MalkuthAttackType.getOpposite(this.giantSwordUltimateStartAttackType));
                RectanglePreparationParticleOptions rectanglePreparationParticleOptions1 = new RectanglePreparationParticleOptions(new Vec3(0.0, 0.0, -1.0), 30.0f, 14.0f, 60, 20, 10, red.x, red.y, red.z, 0.25f);
                RectanglePreparationParticleOptions rectanglePreparationParticleOptions2 = new RectanglePreparationParticleOptions(new Vec3(0.0, 0.0, -1.0), 30.0f, 14.0f, 60, 20, 10, blue.x, blue.y, blue.z, 0.25f);
                Vec3 pos1 = new Vec3(14.0, -0.99, 0.5).add(this.position());
                Vec3 pos2 = new Vec3(-14.0, -0.99, 0.5).add(this.position());
                FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)rectanglePreparationParticleOptions1, (Vec3)pos1, (double)100.0);
                FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)rectanglePreparationParticleOptions2, (Vec3)pos2, (double)100.0);
            } else if (tick == swordSpawnTick) {
                Vec3 offs1 = new Vec3(10.0, -1.0, 11.0);
                Vec3 offs2 = new Vec3(-10.0, -1.0, 11.0);
                Vec3 pos1 = this.position().add(offs1);
                Vec3 pos2 = this.position().add(offs2);
                MalkuthGiantSwordSlash slash1 = MalkuthGiantSwordSlash.summon(this.level(), pos1, new Vec3(0.0, 0.0, -1.0), this.giantSwordUltimateStartAttackType, 0.0f);
                slash1.setDoDamage(false);
                MalkuthGiantSwordSlash slash2 = MalkuthGiantSwordSlash.summon(this.level(), pos2, new Vec3(0.0, 0.0, -1.0), MalkuthAttackType.getOpposite(this.giantSwordUltimateStartAttackType), 0.0f);
                slash2.setDoDamage(false);
            } else if (tick == MalkuthGiantSwordSlash.TIME_TO_HIT + MalkuthGiantSwordSlash.TIME_TO_RISE + swordSpawnTick - 2) {
                ImpactFrame base = new ImpactFrame(0.5f, 0.1f, 1, false);
                FDLibCalls.sendImpactFrames((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (float)30.0f, (ImpactFrame[])new ImpactFrame[]{base, new ImpactFrame(base).setDuration(1).setInverted(true), new ImpactFrame(base).setDuration(1), new ImpactFrame(base).setDuration(1).setInverted(true), new ImpactFrame(base).setDuration(1), new ImpactFrame(base).setDuration(1).setInverted(true), new ImpactFrame(base).setDuration(1), new ImpactFrame(base).setDuration(1).setInverted(true)});
            } else if (tick == MalkuthGiantSwordSlash.TIME_TO_HIT + MalkuthGiantSwordSlash.TIME_TO_RISE + swordSpawnTick) {
                Player player2;
                float damage;
                for (ServerPlayer entity2 : BossTargetFinder.getEntitiesInCylinder(ServerPlayer.class, this.level(), this.spawnPosition.add(0.0, -5.0, 0.0), 50.0f, 50.0f)) {
                    PacketDistributor.sendToPlayer((ServerPlayer)entity2, (CustomPacketPayload)new PlaySoundInEarsPacket(BossSounds.MALKUTH_SWORD_EARTH_IMPACT.get(), 1.0f, 1.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    PacketDistributor.sendToPlayer((ServerPlayer)entity2, (CustomPacketPayload)new PlaySoundInEarsPacket(BossSounds.MALKUTH_SWORD_ULTIMATE_IMPACT.get(), 1.0f, 1.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().amplitude(4.0f).outTime(60).frequency(100.0f).build(), (Vec3)this.spawnPosition, (double)50.0);
                AABB firstBox = new AABB(0.0, -2.0, -29.0, 29.0, 10.0, 0.0).move(this.spawnPosition);
                AABB secondBox = new AABB(-29.0, -2.0, -29.0, 0.0, 10.0, 0.0).move(this.spawnPosition);
                DamageSource damageSource = BossDamageSources.MALKUTH_TSARS_WRATH_SOURCE;
                for (LivingEntity entity3 : this.level().getEntitiesOfClass(LivingEntity.class, firstBox, entity -> !(entity instanceof MalkuthBossBuddy))) {
                    entity3.invulnerableTime = 0;
                    damage = 2.1474836E9f;
                    if (entity3 instanceof Player && !MalkuthWeaknessHandler.isWeakTo(player2 = (Player)entity3, this.giantSwordUltimateStartAttackType)) {
                        damage = 0.1f;
                    }
                    entity3.hurt((DamageSource)new MalkuthDamageSource(damageSource, this.giantSwordUltimateStartAttackType, 101), damage);
                }
                for (LivingEntity entity3 : this.level().getEntitiesOfClass(LivingEntity.class, secondBox, entity -> !(entity instanceof MalkuthBossBuddy))) {
                    entity3.invulnerableTime = 0;
                    damage = 2.1474836E9f;
                    if (entity3 instanceof Player && !MalkuthWeaknessHandler.isWeakTo(player2 = (Player)entity3, MalkuthAttackType.getOpposite(this.giantSwordUltimateStartAttackType))) {
                        damage = 0.1f;
                    }
                    entity3.hurt((DamageSource)new MalkuthDamageSource(damageSource, MalkuthAttackType.getOpposite(this.giantSwordUltimateStartAttackType), 101), damage);
                }
                inst.nextStage();
            }
        } else if (stage == 2) {
            if (tick == 0) {
                this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_IDLE).build());
                this.headControllerContainer.setControllersMode(HeadControllerContainer.Mode.LOOK);
                this.lookAtTarget = true;
            }
            if (tick > 80) {
                return true;
            }
        }
        return false;
    }

    private void doSwordChargeStripe(MalkuthAttackType sword, float radius, float sizeModifier) {
        this.doSwordChargeStripe(sword, radius, sizeModifier, 1.0f + this.random.nextFloat(), true);
    }

    private void doSwordChargeStripe(MalkuthAttackType sword, float radius, float sizeModifier, float circleAmount, boolean in) {
        Matrix4f swordTransform = this.getModelPartTransformation((Entity)this, MalkuthEntity.getMalkuthSwordPlaceBone(sword), SERVER_MODEL);
        Vector3f fireSwordDirection = swordTransform.transformDirection(0.0f, 1.0f, 0.0f, new Vector3f());
        Vector3f fireSwordPosition = swordTransform.transformPosition(0.0f, 0.0f, 0.0f, new Vector3f());
        float rndHeightFire = 0.5f + 2.0f * this.random.nextFloat();
        Vector3f colFire = MalkuthEntity.getMalkuthAttackPreparationParticleColor(sword);
        FDColor fireColorStart = new FDColor(colFire.x, colFire.y - this.random.nextFloat() * 0.1f - 0.3f, colFire.z, 0.5f);
        FDColor fireColor = new FDColor(colFire.x, colFire.y + this.random.nextFloat() * 0.1f, colFire.z, 1.0f);
        StripeParticleOptions fireOptions = StripeParticleOptions.createHorizontalCircling(fireColorStart, fireColor, new Vec3((double)fireSwordDirection.x, (double)fireSwordDirection.y, (double)fireSwordDirection.z), (float)Math.PI * 2 * this.random.nextFloat(), 0.015f + 0.06f * FDEasings.easeOut((float)sizeModifier), 10, 50, this.random.nextFloat() * 4.0f - 2.0f, radius, circleAmount, 0.5f, true, in);
        Vector3f fireStripeLocation = fireSwordPosition.add((Vector3fc)fireSwordDirection.mul(rndHeightFire, new Vector3f()));
        FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)fireOptions, (Vec3)new Vec3((double)fireStripeLocation.x + this.getX(), (double)fireStripeLocation.y + this.getY(), (double)fireStripeLocation.z + this.getZ()), (double)60.0);
    }

    private boolean isBelowHalfHP() {
        return this.hits <= this.maxHits / 2;
    }

    public boolean hurt(DamageSource src, float damage) {
        Entity entity = src.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Vec3 position = this.position();
            double dist = serverPlayer.position().distanceTo(position);
            if (dist < 5.0) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_HIT.get(), SoundSource.HOSTILE, 1.0f, 0.5f);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new DefaultShakePacket(FDShakeData.builder().outTime(5).amplitude(0.15f).build()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 2));
            }
        }
        if (!src.is(DamageTypes.GENERIC_KILL) && !src.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            return false;
        }
        return super.hurt(src, damage);
    }

    private void causeSwordChargeParticles(MalkuthAttackType attackType) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new MalkuthChargeSwordPacket(this, attackType), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Nullable
    public LivingEntity getTarget() {
        return super.getTarget();
    }

    public void setTarget(@Nullable LivingEntity living) {
        super.setTarget(living);
    }

    private void changeTarget() {
        List<Player> combatants = this.getCombatants(false);
        if (combatants.isEmpty()) {
            this.oldTargetPos = null;
            this.setTarget(null);
        } else {
            LivingEntity oldTarget = this.getTarget();
            this.setTarget((LivingEntity)combatants.get(this.random.nextInt(combatants.size())));
            LivingEntity newTarget = this.getTarget();
            if (oldTarget != newTarget) {
                this.oldTargetPos = newTarget.position();
            }
        }
    }

    private Vec3 vectorBetweenNewAndOldTargetPos() {
        LivingEntity target = this.getTarget();
        if (target == null) {
            return null;
        }
        Vec3 oldPos = this.oldTargetPos == null ? target.position() : this.oldTargetPos;
        return target.position().subtract(oldPos);
    }

    private void checkTarget(LivingEntity target) {
        Player player;
        if (target.isDeadOrDying()) {
            this.changeTarget();
            return;
        }
        if (target.position().distanceTo(this.position()) > 29.0) {
            this.changeTarget();
            return;
        }
        if (target instanceof Player && ((player = (Player)target).isCreative() || player.isSpectator())) {
            this.changeTarget();
            return;
        }
    }

    public void setPos(double x, double y, double z) {
        super.setPos(x, y, z);
        if (this.spawnPosition == null && x != 0.0 && y != 0.0 && z != 0.0) {
            this.spawnPosition = new Vec3(x, y, z);
        }
    }

    public List<Player> getCombatants(boolean includeCreativeAndSpectator) {
        return this.level().getEntitiesOfClass(Player.class, this.createEnrageRadiusAABB(this.spawnPosition), player -> includeCreativeAndSpectator || !player.isCreative() && !player.isSpectator());
    }

    private AABB createEnrageRadiusAABB(Vec3 offset) {
        return new AABB(-29.0, -29.0, -29.0, 29.0, 29.0, 29.0).move(offset);
    }

    protected List<MalkuthCannonEntity> getMalkuthCannons() {
        return BossTargetFinder.getEntitiesInCylinder(MalkuthCannonEntity.class, this.level(), this.spawnPosition, 30.0f, 35.0f, cannon -> !cannon.isPlayerControlled());
    }

    protected List<MalkuthCannonEntity> getPlayerCannons(boolean onlyCannonsThatNeedRepair) {
        return BossTargetFinder.getEntitiesInCylinder(MalkuthCannonEntity.class, this.level(), this.spawnPosition.add(0.0, -2.0, 0.0), 30.0f, 30.0f, cannon -> cannon.isPlayerControlled() && (!onlyCannonsThatNeedRepair || cannon.requiresRepair()));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.attackChain.save(tag);
        if (this.jumpCrushAttackMovementPath != null) {
            this.jumpCrushAttackMovementPath.autoSave("jumpCrushAttackMovementPath", tag);
        }
        if (this.jumpOnWallPath != null) {
            this.jumpOnWallPath.autoSave("jumpOnWallPath", tag);
        }
        if (this.bossSpawnerUUID != null) {
            tag.putUUID("boss_spawner", this.bossSpawnerUUID);
        }
        this.autoSave(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.autoLoad(tag);
        if (tag.contains("boss_spawner")) {
            this.bossSpawnerUUID = tag.getUUID("boss_spawner");
        }
        this.attackChain.load(tag);
        if (tag.contains("jumpCrushAttackMovementPath")) {
            this.jumpCrushAttackMovementPath = new ProjectileMovementPath();
            this.jumpCrushAttackMovementPath.autoLoad("jumpCrushAttackMovementPath", tag);
        }
        if (tag.contains("jumpOnWallPath")) {
            this.jumpOnWallPath = new ProjectileMovementPath();
            this.jumpOnWallPath.autoLoad("jumpOnWallPath", tag);
        }
    }

    private void attachSwords() {
        this.attachFireSword();
        this.attachIceSword();
    }

    private void attachIceSword() {
        ModelSystem modelSystem = this.getModelSystem();
        BaseModelAttachmentData iceSword = new BaseModelAttachmentData();
        modelSystem.attachToLayer(0, "ice_sword_place", ICE_SWORD_UUID, (ModelAttachmentData)FDModelAttachmentData.create((BaseModelAttachmentData)iceSword, (FDModelInfo)BossModels.MALKUTH_SWORD.get()).texture(MALKUTH_SWORD_SOLID).renderType((FDRenderType)FDRenderTypes.ENTITY_CUTOUT_NO_CULL.get()));
        modelSystem.attachToLayer(0, "ice_sword_place", ICE_SWORD_EMISSIVE_UUID, (ModelAttachmentData)FDModelAttachmentData.create((BaseModelAttachmentData)iceSword, (FDModelInfo)BossModels.MALKUTH_SWORD.get()).texture(MALKUTH_ICE_SWORD).renderType((FDRenderType)FDRenderTypes.EYES.get()));
    }

    private void attachFireSword() {
        ModelSystem modelSystem = this.getModelSystem();
        BaseModelAttachmentData fireSword = new BaseModelAttachmentData();
        modelSystem.attachToLayer(0, "fire_sword_place", FIRE_SWORD_UUID, (ModelAttachmentData)FDModelAttachmentData.create((BaseModelAttachmentData)fireSword, (FDModelInfo)BossModels.MALKUTH_SWORD.get()).texture(MALKUTH_SWORD_SOLID).renderType((FDRenderType)FDRenderTypes.ENTITY_CUTOUT_NO_CULL.get()));
        modelSystem.attachToLayer(0, "fire_sword_place", FIRE_SWORD_EMISSIVE_UUID, (ModelAttachmentData)FDModelAttachmentData.create((BaseModelAttachmentData)fireSword, (FDModelInfo)BossModels.MALKUTH_SWORD.get()).texture(MALKUTH_FIRE_SWORD).renderType((FDRenderType)FDRenderTypes.EYES.get()));
    }

    protected void playBlockFallSound() {
    }

    private void deattachFireSword() {
        ModelSystem modelSystem = this.getModelSystem();
        modelSystem.removeAttachment(FIRE_SWORD_UUID);
        modelSystem.removeAttachment(FIRE_SWORD_EMISSIVE_UUID);
    }

    private void deattachIceSword() {
        ModelSystem modelSystem = this.getModelSystem();
        modelSystem.removeAttachment(ICE_SWORD_UUID);
        modelSystem.removeAttachment(ICE_SWORD_EMISSIVE_UUID);
    }

    private void deattachSwords() {
        this.deattachIceSword();
        this.deattachFireSword();
    }

    public int getHeadRotSpeed() {
        return 10;
    }

    public int getMaxHeadXRot() {
        return super.getMaxHeadXRot();
    }

    public int getMaxHeadYRot() {
        return 80;
    }

    public HeadControllerContainer<MalkuthEntity> getHeadControllerContainer() {
        return this.headControllerContainer;
    }

    public void push(double p_20286_, double p_20287_, double p_20288_) {
    }

    public void push(Entity p_21294_) {
    }

    public void push(Vec3 p_347665_) {
    }

    protected void pushEntities() {
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    @Override
    public void setSpawnedBy(BossSpawnerEntity bossSpawnerEntity) {
        this.bossSpawnerUUID = bossSpawnerEntity.getUUID();
    }

    @Override
    public void setSpawnPosition(Vec3 spawnPosition) {
        this.spawnPosition = spawnPosition;
    }

    @Override
    public BossSpawnerEntity getSpawner() {
        Level level;
        if (this.bossSpawnerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            return (BossSpawnerEntity)level2.getEntity(this.bossSpawnerUUID);
        }
        return null;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossbar.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossbar.removePlayer(player);
    }

    public static String getMalkuthSwordPlaceBone(MalkuthAttackType type) {
        if (type.isFire()) {
            return "fire_sword_place";
        }
        return "ice_sword_place";
    }

    @Override
    public boolean onFDDespawn() {
        BossSpawnerEntity spawner = this.getSpawner();
        if (spawner != null) {
            spawner.setActive(true);
            return true;
        }
        return false;
    }

    static {
        FIRE_SWORD_UUID = UUID.fromString("7a6d1a24-599a-4717-baa3-42d9e3293896");
        FIRE_SWORD_EMISSIVE_UUID = UUID.fromString("cd95b81b-4a3f-4ef0-9b46-f0b3503ed7fb");
        ICE_SWORD_UUID = UUID.fromString("a46c06e3-f6af-4295-a296-20fba19ac613");
        ICE_SWORD_EMISSIVE_UUID = UUID.fromString("930a0a3b-5a47-4ebd-b614-7e42e5d0cd92");
        MALKUTH_SWORD_SOLID = FDBosses.location("textures/item/malkuth_sword_solid.png");
        MALKUTH_ICE_SWORD = FDBosses.location("textures/item/malkuth_sword_ice_emissive.png");
        MALKUTH_FIRE_SWORD = FDBosses.location("textures/item/malkuth_sword_fire_emissive.png");
        PLATFORM_SPAWN_OFFSETS = new Vec3[]{new Vec3(16.0, 5.0, -15.0), new Vec3(16.0, 5.0, -7.0), new Vec3(8.0, 5.0, -17.0), new Vec3(8.0, 5.0, -9.0), new Vec3(0.0, 5.0, -19.0), new Vec3(0.0, 5.0, -11.0), new Vec3(-8.0, 5.0, -17.0), new Vec3(-8.0, 5.0, -9.0), new Vec3(-16.0, 5.0, -15.0), new Vec3(-16.0, 5.0, -7.0)};
        PLATFORM_ATTACK_PATTERN = new int[][]{{0, 1, 1, 0, 0, 1, 1, 0, 0, 1}, {1, 1, 0, 0, 1, 1, 0, 0, 1, 1}, {0, 0, 0, 1, 1, 1, 0, 1, 0, 0}, {1, 0, 0, 1, 1, 0, 0, 1, 1, 0}, {0, 0, 1, 1, 0, 0, 1, 1, 0, 0}, {1, 1, 1, 0, 0, 0, 1, 0, 1, 1}};
    }

    @EventBusSubscriber(modid="fdbosses", bus=EventBusSubscriber.Bus.GAME)
    public static class Events {
        public static final int MARK_OF_A_COWARD_DURATION = 60;

        @SubscribeEvent
        public static void ignoreTotems(LivingUseTotemEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!livingEntity.level().isClientSide && event.getSource() == BossDamageSources.MALKUTH_COWARDICE_SOURCE) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onCowardice(MobEffectEvent.Expired event) {
            MobEffectInstance instance = event.getEffectInstance();
            Holder effect = instance.getEffect();
            LivingEntity entity = event.getEntity();
            if (!entity.level().isClientSide && effect.is(BossEffects.MARK_OF_A_COWARD)) {
                entity.hurt(BossDamageSources.MALKUTH_COWARDICE_SOURCE, Float.MAX_VALUE);
            }
        }

        @SubscribeEvent
        public static void livingTick(PlayerTickEvent.Post event) {
            Player entity = event.getEntity();
            Level level = entity.level();
            if (!level.isClientSide && entity.hasEffect(BossEffects.MARK_OF_A_KNIGHT)) {
                Vec3 cylinderStart = entity.position().add(0.0, -11.0, 0.0);
                List<MalkuthBossSpawner> spawners = BossTargetFinder.getEntitiesInArc(MalkuthBossSpawner.class, level, cylinderStart, new Vec2(0.0f, 1.0f), (float)Math.PI, 13.0f, 29.0f);
                if (spawners.isEmpty()) {
                    entity.removeEffect(BossEffects.MARK_OF_A_KNIGHT);
                    if (!entity.hasEffect(BossEffects.MARK_OF_A_COWARD)) {
                        entity.addEffect(new MobEffectInstance(BossEffects.MARK_OF_A_COWARD, 60, 0, true, false));
                    }
                } else {
                    entity.removeEffect(BossEffects.MARK_OF_A_COWARD);
                }
            }
        }
    }
}

