/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_earthquake;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.client.BossParticles;
import com.finderfeed.fdbosses.client.particles.GravityParticleOptions;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthBossBuddy;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthDamageSource;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthWeaknessHandler;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_earthquake.MalkuthEarthquakeSegment;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.init.FDEDataSerializers;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class MalkuthEarthquake
extends Entity
implements AutoSerializable {
    public static final EntityDataAccessor<MalkuthAttackType> MALKUTH_ATTACK_TYPE = SynchedEntityData.defineId(MalkuthEarthquake.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    public static final EntityDataAccessor<Float> ANGLE = SynchedEntityData.defineId(MalkuthEarthquake.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Vec3> DIRECTION = SynchedEntityData.defineId(MalkuthEarthquake.class, (EntityDataSerializer)((EntityDataSerializer)FDEDataSerializers.VEC3.get()));
    public static final EntityDataAccessor<Integer> TIME = SynchedEntityData.defineId(MalkuthEarthquake.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @SerializableField
    private float damage;
    private List<MalkuthEarthquakeSegment> segments = new ArrayList<MalkuthEarthquakeSegment>();

    public static MalkuthEarthquake summon(Level level, MalkuthAttackType malkuthAttackType, Vec3 pos, Vec3 directionAndLength, int time, float arcAngle, float damage) {
        MalkuthEarthquake malkuthEarthquake = new MalkuthEarthquake(BossEntities.MALKUTH_EARTHQUAKE.get(), level);
        malkuthEarthquake.setEarthquakeTime(time);
        malkuthEarthquake.setDirectionAndLength(directionAndLength);
        malkuthEarthquake.setAngle(arcAngle);
        malkuthEarthquake.setMalkuthAttackType(malkuthAttackType);
        malkuthEarthquake.setPos(pos);
        malkuthEarthquake.damage = damage;
        level.addFreshEntity((Entity)malkuthEarthquake);
        return malkuthEarthquake;
    }

    public MalkuthEarthquake(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.summonSegments();
            this.manageSegments();
        } else {
            this.tickDamage();
            if (this.tickCount > this.getEarthquakeTime() + 20) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            Pair<Float, Float> damageRadiuses = this.getCurrentDamageRadius();
            float v = FDMathUtil.lerp((float)((Float)damageRadiuses.first).floatValue(), (float)((Float)damageRadiuses.second).floatValue(), (float)0.5f);
            Vec3 vec = this.getDirectionAndLength().normalize().multiply((double)v, (double)v, (double)v).add(this.position());
            int tick = this.tickCount - 1;
            if (tick % 5 == 0) {
                this.level().playSound(null, vec.x, vec.y, vec.z, BossSounds.MALKUTH_EARTHQUAKE_ROLLING.get(), SoundSource.HOSTILE, 1.0f, 0.75f);
            }
            if (tick % 3 == 0 && this.getEarthquakeType().isIce()) {
                this.level().playSound(null, vec.x, vec.y, vec.z, BossSounds.MALKUTH_EARTHQUAKE_SPIKE.get(), SoundSource.HOSTILE, 1.0f, 1.1f);
            }
        }
    }

    private void tickDamage() {
        Pair<Float, Float> radius = this.getCurrentDamageRadius();
        Vec3 dirAndLength = this.getDirectionAndLength();
        float length = (float)dirAndLength.length();
        Vec2 dir = new Vec2((float)dirAndLength.x, (float)dirAndLength.z);
        List<LivingEntity> entities = BossTargetFinder.getEntitiesInArc(LivingEntity.class, this.level(), this.position().add(0.0, -1.0, 0.0), dir, this.getAngle(), 3.0f, length, livingEntity -> !(livingEntity instanceof MalkuthBossBuddy));
        List<LivingEntity> entities2 = BossTargetFinder.getEntitiesInCylinder(LivingEntity.class, this.level(), this.position().add(0.0, -1.0, 0.0), 3.0f, 1.0f, livingEntity -> !(livingEntity instanceof MalkuthBossBuddy));
        entities.addAll(entities2);
        for (LivingEntity entity : entities) {
            ServerPlayer serverPlayer;
            Vec3 position = entity.position();
            Vec3 b = position.subtract(this.position()).multiply(1.0, 0.0, 1.0);
            double k = b.length();
            if (k < (double)((Float)radius.first).floatValue() || k > (double)((Float)radius.second).floatValue()) continue;
            Vec3 speed = new Vec3((double)dir.x, 0.0, (double)dir.y).normalize().add(0.0, 1.2, 0.0);
            boolean setPlayerSpeed = false;
            if (entity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity;
                if (MalkuthWeaknessHandler.isWeakTo((Player)serverPlayer, this.getEarthquakeType())) {
                    setPlayerSpeed = true;
                }
            } else {
                entity.setDeltaMovement(speed);
            }
            entity.hurt((DamageSource)new MalkuthDamageSource(BossDamageSources.MALKUTH_IMPALING_DOOM_SOURCE, this.getEarthquakeType(), 51), this.damage);
            if (!(entity instanceof ServerPlayer)) continue;
            serverPlayer = (ServerPlayer)entity;
            if (!setPlayerSpeed) continue;
            FDLibCalls.setServerPlayerSpeed((ServerPlayer)serverPlayer, (Vec3)speed);
        }
    }

    public List<MalkuthEarthquakeSegment> getSegments() {
        return this.segments;
    }

    private Pair<Float, Float> getCurrentDamageRadius() {
        float fullLength = (float)this.getDirectionAndLength().length();
        float currentCompletionPercent = (float)(this.tickCount - 1) / (float)this.getEarthquakeTime();
        float currentLength = fullLength * currentCompletionPercent;
        float sizeOfDamageArea = this.getSizeOfDamageArea();
        return new Pair((Object)Float.valueOf(currentLength), (Object)Float.valueOf(currentLength + sizeOfDamageArea));
    }

    private float getSizeOfDamageArea() {
        float fullLength = (float)this.getDirectionAndLength().length();
        return fullLength / (float)this.getEarthquakeTime();
    }

    private void summonSegments() {
        if (this.tickCount > this.getEarthquakeTime()) {
            return;
        }
        Pair<Float, Float> pair = this.getCurrentDamageRadius();
        Vec3 direction = this.getDirectionAndLength();
        float angle = this.getAngle();
        float start = ((Float)pair.first).floatValue();
        float end = ((Float)pair.second).floatValue();
        float sizeOfSegment = 1.25f;
        Vec3 ndir = direction.normalize();
        boolean reverse = false;
        for (float i = start + 0.01f; i <= end; i += sizeOfSegment) {
            float lengthOfCircle = (float)Math.PI * 2 * i;
            float anglePercent = sizeOfSegment / lengthOfCircle;
            float sizeInAngle = anglePercent * (float)Math.PI * 2.0f;
            for (float b = this.random.nextFloat() * sizeInAngle / 2.0f; b <= angle; b += sizeInAngle) {
                float rot = reverse ? angle - b : b;
                float f = i + sizeOfSegment * this.random.nextFloat() / 2.0f;
                Vec3 offset = ndir.multiply((double)f, (double)f, (double)f).yRot(rot - angle / 2.0f);
                MalkuthEarthquakeSegment.Type segmentType = this.getRandomSegmentType(this.random.nextInt(2));
                float segmentAngle = 0.7853982f - this.random.nextFloat() * (float)Math.PI / 6.0f;
                int segmentTime = 10;
                MalkuthEarthquakeSegment malkuthEarthquakeSegment = new MalkuthEarthquakeSegment(segmentType, offset, segmentAngle, segmentTime);
                this.segments.add(malkuthEarthquakeSegment);
                if (this.getEarthquakeType().isIce() && this.random.nextFloat() > 0.6f) {
                    float additionalAngle = (float)(reverse ? -1 : 1) * this.random.nextFloat() * sizeInAngle;
                    offset = ndir.yRot(rot - angle / 2.0f + additionalAngle).multiply((double)i, (double)i, (double)i);
                    MalkuthEarthquakeSegment s = new MalkuthEarthquakeSegment(MalkuthEarthquakeSegment.Type.ICE_SPIKE, offset, this.random.nextFloat() * (float)Math.PI / 32.0f, segmentTime);
                    this.segments.add(s);
                }
                this.segments.sort(Comparator.comparingInt(v -> v.getType().getId()));
                for (int k = 0; k < 1; ++k) {
                    Object options;
                    float hspeed = 0.4f;
                    if (this.getEarthquakeType().isFire()) {
                        float rnd = this.random.nextFloat();
                        if ((double)rnd > 0.66) {
                            options = new GravityParticleOptions(BossParticles.FLAME_WITH_STONE.get(), 20 + this.random.nextInt(4), 0.15f + this.random.nextFloat() * 0.2f, 1.5999999f, 2.0f, true);
                        } else if ((double)rnd > 0.33) {
                            float rc = 0.9f + this.random.nextFloat() * 0.1f;
                            float gc = 0.2f + this.random.nextFloat() * 0.2f;
                            float bc = this.random.nextFloat() * 0.2f;
                            options = BallParticleOptions.builder().color(rc, gc, bc).size(0.2f + this.random.nextFloat() * 0.2f).scalingOptions(0, 0, 20).friction(0.7f).build();
                            hspeed = 0.75f;
                        } else {
                            options = ParticleTypes.LAVA;
                        }
                    } else if ((double)this.random.nextFloat() > 0.5) {
                        options = new GravityParticleOptions(BossParticles.ICE_CHUNK.get(), 20 + this.random.nextInt(4), 0.5f + this.random.nextFloat() * 0.2f, 1.5999999f, 2.0f, true);
                    } else {
                        float rc = this.random.nextFloat() * 0.2f;
                        float gc = 0.7f + this.random.nextFloat() * 0.1f;
                        float bc = 0.9f + this.random.nextFloat() * 0.1f;
                        options = BallParticleOptions.builder().color(rc, gc, bc).size(0.2f + this.random.nextFloat() * 0.2f).scalingOptions(0, 0, 20).friction(0.7f).build();
                        hspeed = 0.75f;
                    }
                    Vec3 pos = offset.add(this.position()).add((double)this.random.nextFloat() * 0.8 - 0.4, (double)this.random.nextFloat() * 0.8 - 0.4, (double)this.random.nextFloat() * 0.8 - 0.4);
                    this.level().addParticle((ParticleOptions)options, true, pos.x, pos.y, pos.z, ndir.x * (double)hspeed, (double)this.random.nextFloat() * 0.75 + 0.1, ndir.z * (double)hspeed);
                }
            }
            reverse = true;
        }
    }

    private MalkuthEarthquakeSegment.Type getRandomSegmentType(int segmentId) {
        if (this.getEarthquakeType().isFire()) {
            if (segmentId == 0) {
                return MalkuthEarthquakeSegment.Type.FIRE_1;
            }
            return MalkuthEarthquakeSegment.Type.FIRE_2;
        }
        if (segmentId == 0) {
            return MalkuthEarthquakeSegment.Type.ICE_1;
        }
        return MalkuthEarthquakeSegment.Type.ICE_2;
    }

    private void manageSegments() {
        Iterator<MalkuthEarthquakeSegment> iter = this.segments.iterator();
        while (iter.hasNext()) {
            MalkuthEarthquakeSegment segment = iter.next();
            if (segment.hasFinished()) {
                iter.remove();
                continue;
            }
            segment.tick();
        }
    }

    public int getEarthquakeTime() {
        return (Integer)this.entityData.get(TIME);
    }

    public void setEarthquakeTime(int time) {
        this.entityData.set(TIME, (Object)time);
    }

    public void setMalkuthAttackType(MalkuthAttackType malkuthAttackType) {
        this.entityData.set(MALKUTH_ATTACK_TYPE, (Object)malkuthAttackType);
    }

    public void setDirectionAndLength(Vec3 direction) {
        this.entityData.set(DIRECTION, (Object)direction);
    }

    public Vec3 getDirectionAndLength() {
        return (Vec3)this.entityData.get(DIRECTION);
    }

    public MalkuthAttackType getEarthquakeType() {
        return (MalkuthAttackType)((Object)this.entityData.get(MALKUTH_ATTACK_TYPE));
    }

    public void setAngle(float angle) {
        this.entityData.set(ANGLE, (Object)Float.valueOf(angle));
    }

    public float getAngle() {
        return ((Float)this.entityData.get(ANGLE)).floatValue();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MALKUTH_ATTACK_TYPE, (Object)MalkuthAttackType.FIRE);
        builder.define(DIRECTION, (Object)new Vec3(1.0, 0.0, 0.0));
        builder.define(TIME, (Object)20);
        builder.define(ANGLE, (Object)Float.valueOf(0.5235988f));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.autoLoad(tag);
        this.entityData.set(ANGLE, (Object)Float.valueOf(tag.getFloat("angle")));
        this.entityData.set(DIRECTION, (Object)new Vec3(tag.getDouble("xdir"), 0.0, tag.getDouble("zdir")));
        this.entityData.set(MALKUTH_ATTACK_TYPE, (Object)MalkuthAttackType.valueOf(tag.getString("earthquake_type")));
        this.entityData.set(TIME, (Object)tag.getInt("time"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        this.autoSave(tag);
        tag.putFloat("angle", ((Float)this.entityData.get(ANGLE)).floatValue());
        tag.putDouble("xdir", ((Vec3)this.entityData.get(MalkuthEarthquake.DIRECTION)).x);
        tag.putDouble("zdir", ((Vec3)this.entityData.get(MalkuthEarthquake.DIRECTION)).z);
        tag.putString("earthquake_type", ((MalkuthAttackType)((Object)this.entityData.get(MALKUTH_ATTACK_TYPE))).name());
        tag.putInt("time", ((Integer)this.entityData.get(TIME)).intValue());
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }
}

