/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_floor;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.client.BossParticles;
import com.finderfeed.fdbosses.client.particles.GravityParticleOptions;
import com.finderfeed.fdbosses.client.particles.smoke_particle.BigSmokeParticleOptions;
import com.finderfeed.fdbosses.client.particles.stripe_particle.StripeParticleOptions;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthBossBuddy;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.util.FDColor;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MalkuthFloorEntity
extends Entity {
    public static EntityDataAccessor<Boolean> IS_DEAD = SynchedEntityData.defineId(MalkuthFloorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final float RADIUS = 28.0f;
    public static final int DEATH_TME = 10;
    public int deathTicks = 10;

    public MalkuthFloorEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.summonParticles();
            this.particles();
        } else if (!this.isDead()) {
            this.damageAndThrowUp();
        }
        if (this.isDead()) {
            if (!this.level().isClientSide && this.deathTicks <= 0) {
                this.setRemoved(Entity.RemovalReason.DISCARDED);
            }
            this.deathTicks = Math.clamp((long)(this.deathTicks - 1), 0, 10);
        }
    }

    private void damageAndThrowUp() {
        if (this.tickCount > 10) {
            float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.malkuthFloorDamage);
            List<LivingEntity> targets = BossTargetFinder.getEntitiesInArc(LivingEntity.class, this.level(), this.position(), new Vec2(0.0f, -1.0f), (float)Math.PI, 2.5f, 28.0f);
            for (LivingEntity target : targets) {
                if (target instanceof MalkuthBossBuddy) continue;
                target.hurt(BossDamageSources.MALKUTH_IMPALING_DOOM_SOURCE, damage);
                double speed = 1.2f;
                if (target instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)target;
                    FDLibCalls.setServerPlayerSpeed((ServerPlayer)serverPlayer, (Vec3)new Vec3(0.0, speed, 0.0));
                    continue;
                }
                target.setDeltaMovement(0.0, speed, 0.0);
            }
        }
    }

    public boolean isDead() {
        return (Boolean)this.entityData.get(IS_DEAD);
    }

    private void setDead() {
        this.entityData.set(IS_DEAD, (Object)true);
    }

    private void summonParticles() {
        if (this.tickCount == 1) {
            float segmentSize = 1.0f;
            float radius = 28.0f;
            for (float currentRad = segmentSize; currentRad <= radius; currentRad += segmentSize) {
                float currentArcLength = (float)Math.PI * currentRad;
                for (float i = 0.0f; i <= currentArcLength; i += segmentSize) {
                    Object particleOptions;
                    float p = i / currentArcLength;
                    float currentAngle = (float)Math.PI * p;
                    Vec3 currentOffset = new Vec3((double)currentRad, 0.0, 0.0).yRot(currentAngle);
                    Vec3 ppos = this.position().add(currentOffset);
                    float rnd = this.random.nextFloat();
                    float speedX = this.random.nextFloat() * 0.5f - 0.25f;
                    float speedY = this.random.nextFloat() * 0.5f + 0.5f;
                    float speedZ = this.random.nextFloat() * 0.5f - 0.25f;
                    if ((double)rnd > 0.75) {
                        particleOptions = ParticleTypes.LAVA;
                    } else if (rnd > 0.5f) {
                        particleOptions = new GravityParticleOptions(BossParticles.FLAME_WITH_STONE.get(), 20 + this.random.nextInt(4), 0.5f + this.random.nextFloat() * 0.2f, 1.5999999f, 2.0f, true);
                    } else if (rnd > 0.25f) {
                        particleOptions = new GravityParticleOptions(BossParticles.ICE_CHUNK.get(), 20 + this.random.nextInt(4), 0.5f + this.random.nextFloat() * 0.2f, 1.5999999f, 2.0f, true);
                    } else {
                        Vector3f colFire = MalkuthEntity.getMalkuthAttackPreparationParticleColor(MalkuthAttackType.getRandom(this.random));
                        FDColor colorStart = new FDColor(colFire.x, colFire.y - this.random.nextFloat() * 0.1f - 0.3f, colFire.z, 0.5f);
                        FDColor colorEnd = new FDColor(colFire.x, colFire.y + this.random.nextFloat() * 0.1f, colFire.z, 1.0f);
                        speedX = 0.0f;
                        speedY = 0.0f;
                        speedZ = 0.0f;
                        List<Vec3> offsets = List.of(new Vec3(0.0, 0.0, 0.01), new Vec3((double)(this.random.nextFloat() * 4.0f - 2.0f), (double)(2 + this.random.nextInt(2)), (double)(this.random.nextFloat() * 4.0f - 2.0f)), new Vec3((double)(this.random.nextFloat() * 4.0f - 2.0f), (double)(4 + this.random.nextInt(2)), (double)(this.random.nextFloat() * 4.0f - 2.0f)));
                        particleOptions = StripeParticleOptions.builder().startColor(colorStart).endColor(colorEnd).lifetime(5 + this.random.nextInt(15)).lod(20).scale(0.05f).stripePercentLength(0.5f).startInPercent(0.5f).endOutPercent(0.5f).offsets(offsets).build();
                    }
                    this.level().addParticle((ParticleOptions)particleOptions, true, ppos.x + (double)(this.random.nextFloat() * segmentSize) - (double)(segmentSize / 2.0f), ppos.y, ppos.z + (double)(this.random.nextFloat() * segmentSize) - (double)(segmentSize / 2.0f), (double)speedX, (double)speedY, (double)speedZ);
                }
            }
        }
    }

    private void particles() {
        if (this.level().getGameTime() % 5L == 0L) {
            float segmentSize = 3.0f;
            float radius = 25.0f;
            for (float currentRad = segmentSize; currentRad <= radius; currentRad += segmentSize) {
                float currentArcLength = (float)Math.PI * currentRad;
                for (float i = 0.0f; i <= currentArcLength; i += segmentSize) {
                    Object particleOptions;
                    float p = i / currentArcLength;
                    float currentAngle = (float)Math.PI * p;
                    Vec3 currentOffset = new Vec3((double)currentRad, 0.0, 0.0).yRot(currentAngle);
                    Vec3 ppos = this.position().add(currentOffset);
                    if (this.random.nextBoolean()) {
                        particleOptions = ParticleTypes.LAVA;
                    } else {
                        float col = this.random.nextFloat() * 0.2f + 0.3f;
                        particleOptions = BigSmokeParticleOptions.builder().lifetime(0, 0, 40).size(2.0f + this.random.nextFloat()).color(col, col, col).build();
                    }
                    this.level().addParticle((ParticleOptions)particleOptions, true, ppos.x + (double)(this.random.nextFloat() * segmentSize) - (double)(segmentSize / 2.0f), ppos.y, ppos.z + (double)(this.random.nextFloat() * segmentSize) - (double)(segmentSize / 2.0f), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void kill() {
        this.setDead();
    }

    public boolean isPickable() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(IS_DEAD, (Object)false);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.entityData.set(IS_DEAD, (Object)tag.getBoolean("is_dead"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putBoolean("is_dead", ((Boolean)this.entityData.get(IS_DEAD)).booleanValue());
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        return true;
    }

    public AABB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling();
    }
}

