/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.packets;

import com.finderfeed.fdbosses.BossClientPackets;
import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerContextAssignable;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerEntity;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@RegisterFDPacket(value="fdbosses:open_boss_dossier")
public class OpenBossDossierPacket
extends FDPacket {
    private static final StreamCodec<RegistryFriendlyByteBuf, List<Item>> ITEM_CODEC = ByteBufCodecs.registry((ResourceKey)Registries.ITEM).apply(ByteBufCodecs.list());
    private List<Item> drops;
    private int bossSpawnerId;

    public OpenBossDossierPacket(RegistryFriendlyByteBuf buf) {
        this.drops = (List)ITEM_CODEC.decode((Object)buf);
        this.bossSpawnerId = buf.readInt();
    }

    public OpenBossDossierPacket(BossSpawnerEntity bossSpawner) {
        EntityType<? extends BossSpawnerContextAssignable> bossEntityType = bossSpawner.getBossEntityType();
        this.bossSpawnerId = bossSpawner.getId();
        LivingEntity fakeEntity = (LivingEntity)bossEntityType.create(bossSpawner.level());
        ResourceKey lootTable = fakeEntity.getLootTable();
        MinecraftServer server = ((ServerLevel)bossSpawner.level()).getServer();
        List<Item> items = BossUtil.getItemsFromLootTable(server, (ResourceKey<LootTable>)lootTable);
        this.drops = items;
    }

    public void write(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
        ITEM_CODEC.encode((Object)registryFriendlyByteBuf, this.drops);
        registryFriendlyByteBuf.writeInt(this.bossSpawnerId);
    }

    public void clientAction(IPayloadContext iPayloadContext) {
        BossClientPackets.openBossDossierScreen(this.bossSpawnerId, this.drops);
    }

    public void serverAction(IPayloadContext iPayloadContext) {
    }
}

