/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDBlockEntityRenderer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDBlockRenderLayerOptions;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDFreeBERenderer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.IBERenderOffScreen;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.IShouldBERender;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FDBlockEntityRendererBuilder<T extends BlockEntity> {
    private List<FDBlockRenderLayerOptions<T>> layers = new ArrayList<FDBlockRenderLayerOptions<T>>();
    private IShouldBERender<T> shouldRender = (tile, v) -> true;
    private IBERenderOffScreen<T> shouldRenderOffScreen = tile -> false;
    private FDFreeBERenderer<T> freeRender = null;

    public static <E extends BlockEntity> FDBlockEntityRendererBuilder<E> builder() {
        return new FDBlockEntityRendererBuilder();
    }

    public FDBlockEntityRendererBuilder<T> addLayer(FDBlockRenderLayerOptions<T> layer) {
        this.layers.add(layer);
        return this;
    }

    public FDBlockEntityRendererBuilder<T> shouldRender(IShouldBERender<T> shouldRender) {
        this.shouldRender = shouldRender;
        return this;
    }

    public FDBlockEntityRendererBuilder<T> shouldRenderOffScreen(IBERenderOffScreen<T> shouldRender) {
        this.shouldRenderOffScreen = shouldRender;
        return this;
    }

    public FDBlockEntityRendererBuilder<T> freeRender(FDFreeBERenderer<T> freeRender) {
        this.freeRender = freeRender;
        return this;
    }

    public BlockEntityRendererProvider<T> build() {
        return context -> new FDBlockEntityRenderer<T>(context, this.shouldRender, this.shouldRenderOffScreen, this.layers, this.freeRender);
    }
}

