/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.particle;

import com.finderfeed.fdlib.systems.particle.FDParticleProcessors;
import com.finderfeed.fdlib.systems.particle.ParticleProcessorType;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public interface ParticleProcessor<T extends ParticleProcessor<T>> {
    public static final Codec<ResourceLocation> RL_CODEC = ResourceLocation.f_135803_.fieldOf("type").codec();
    public static final Codec<ParticleProcessor<?>> CODEC = new Codec<ParticleProcessor<?>>(){

        public <D> DataResult<Pair<ParticleProcessor<?>, D>> decode(DynamicOps<D> ops, D input) {
            DataResult result = RL_CODEC.decode(ops, input);
            ResourceLocation location = (ResourceLocation)((Pair)result.getOrThrow(false, s -> {})).getFirst();
            ParticleProcessorType<?> type = FDParticleProcessors.getType(location);
            Codec<?> particleProcessorCodec = type.codec();
            DataResult processorResult = particleProcessorCodec.decode(ops, input);
            return processorResult;
        }

        public <D> DataResult<D> encode(ParticleProcessor<?> value, DynamicOps<D> ops, D prefix) {
            ParticleProcessorType<?> type = value.type();
            Codec<?> codec = type.codec();
            DataResult result = RL_CODEC.encode((Object)type.id(), ops, prefix).flatMap(f -> codec.encode((Object)value, ops, f));
            return result;
        }
    };
    public static final NetworkCodec<ParticleProcessor<?>> STREAM_CODEC = new NetworkCodec<ParticleProcessor<?>>(){

        @Override
        public ParticleProcessor<?> fromNetwork(FriendlyByteBuf buf) {
            ResourceLocation location = buf.m_130281_();
            ParticleProcessorType<?> type = FDParticleProcessors.getType(location);
            NetworkCodec<?> codec = type.networkCodec();
            return (ParticleProcessor)codec.fromNetwork(buf);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, ParticleProcessor<?> processor) {
            buf.m_130085_(processor.type().id());
            ParticleProcessor.hackyEncode(buf, processor, processor.type().networkCodec());
        }
    };

    public ParticleProcessorType<T> type();

    public void processParticle(Particle var1);

    public void init(Particle var1);

    private static <T extends ParticleProcessor<T>> void hackyEncode(FriendlyByteBuf buf, ParticleProcessor<?> processor, NetworkCodec<T> encoder) {
        encoder.toNetwork(buf, processor);
    }
}

