/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.options.IConfigValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndInvSettingScreen
extends Screen {
    private static final int CONFIG_ENTRY_Y_OFFSET = 17;
    private static final int CONFIG_ENTRY_X_OFFSET = 10;
    private static final int ENTRY_HEIGHT = 20;
    private static final int MAX_ENTRY_COUNT = 7;
    private static final int WIDGET_X_OFFSET = 165;
    private static final int WIDGET_X_SIZE = 60;
    private static final int WIDGET_Y_SIZE = 18;
    private final Screen back;
    private int leftPos;
    private int topPos;
    private final int imageWidth = 248;
    private final int imageHeight = 166;
    private int pageIndex = 0;
    private int entryOffset = 0;
    private double scrollOffset = 0.0;
    public final List<EntryBuilder> entries = new ArrayList<EntryBuilder>();
    public final EntryBuilder[] renderingEntries = new EntryBuilder[7];
    @Nullable
    private EditBox typingEditBox;

    public EndInvSettingScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"title.endinv.settings"));
        this.back = lastScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.switchPage();
    }

    private void switchPage() {
        this.entries.clear();
        Arrays.fill(this.renderingEntries, null);
        this.m_169413_();
        this.addPageSwitchButton();
        if (this.pageIndex == 1) {
            this.addInfoEntry((Component)Component.m_237115_((String)"endinv.info.accessibility"), CachedSrcInv.INSTANCE::getAccessibility);
            this.addInfoEntry((Component)Component.m_237115_((String)"endinv.info.owner_uuid"), CachedSrcInv.INSTANCE::getOwnerUUID);
            this.addInfoEntry((Component)Component.m_237115_((String)"endinv.info.white_list_size"), () -> "Size :" + CachedSrcInv.INSTANCE.white_list.size());
        } else {
            this.addConfigEntry("endinv.setting.rows", ClientModInfo.getClientConfig().rows());
            this.addConfigEntry("endinv.setting.columns", ClientModInfo.getClientConfig().columns());
            this.addConfigEntry("endinv.setting.auto_suit", ClientModInfo.getClientConfig().autoSuitColumn());
            this.addConfigEntry("endinv.setting.attaching", ClientModInfo.getClientConfig().attaching());
            this.addConfigEntry("endinv.setting.texture", ClientModInfo.getClientConfig().textureMode());
            this.addConfigEntry("endinv.setting.max_page_bar", ClientModInfo.getClientConfig().maxPageBarCount());
            this.addConfigEntry((Component)Component.m_237113_((String)"Screen debug"), ClientModInfo.getClientConfig().screenDebugging());
        }
        this.scrollTo();
    }

    private void scrollTo() {
        for (int i = 0; i < Math.min(7, this.entries.size()); ++i) {
            assert (this.entryOffset < this.entries.size() - i);
            this.renderingEntries[i] = this.entries.get(i + this.entryOffset);
        }
        for (EntryBuilder entry : this.renderingEntries) {
            if (entry == null) continue;
            entry.build();
            entry.syncConfig();
        }
    }

    private void pageSwitched(int index) {
        this.pageIndex = index;
        this.switchPage();
    }

    private <T> void addConfigEntry(String key, IConfigValue<T> configValue) {
        this.addConfigEntry((Component)Component.m_237115_((String)key), configValue);
    }

    private <T> void addConfigEntry(Component tip, IConfigValue<T> configValue) {
        this.entries.add(new ConfigEntry<T>(this.entries.size(), tip, configValue.get(), configValue));
    }

    private void addInfoEntry(Component tip, Supplier<Object> info) {
        this.entries.add(new InfoEntry(this.entries.size(), tip, info));
    }

    private void addPageSwitchButton() {
        Button left = Button.m_253074_((Component)Component.m_237113_((String)"<"), btn -> this.pageSwitched(Mth.m_14045_((int)(this.pageIndex - 1), (int)0, (int)1))).m_252794_(this.leftPos - 20, this.topPos).m_253046_(20, 20).m_253136_();
        Button right = Button.m_253074_((Component)Component.m_237113_((String)">"), btn -> this.pageSwitched(Mth.m_14045_((int)(this.pageIndex + 1), (int)0, (int)1))).m_252794_(this.leftPos + 248 + 1, this.topPos).m_253046_(20, 20).m_253136_();
        this.m_142416_((GuiEventListener)left);
        this.m_142416_((GuiEventListener)right);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280273_(guiGraphics);
        for (EntryBuilder entry : this.renderingEntries) {
            if (entry == null) continue;
            entry.render(guiGraphics, partialTick, mouseX, mouseY);
        }
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -100.0f);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 248, this.topPos + 166, -2004318072);
        guiGraphics.m_280168_().m_85849_();
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.back);
        ClientModInfo.getClientConfig().save();
    }

    public boolean m_5534_(char code, int modifiers) {
        if (super.m_5534_(code, modifiers)) {
            EditBox editBox;
            GuiEventListener guiEventListener = this.m_7222_();
            this.typingEditBox = guiEventListener instanceof EditBox ? (editBox = (EditBox)guiEventListener) : null;
        }
        return false;
    }

    public void m_86600_() {
        boolean flag;
        super.m_86600_();
        boolean bl = flag = this.m_7222_() == null || !this.m_7222_().m_93696_() || this.m_7222_() != this.typingEditBox;
        if (flag && this.typingEditBox != null) {
            for (EntryBuilder entry : this.entries) {
                entry.getEditBox().ifPresent(editBox -> {
                    if (editBox == this.typingEditBox) {
                        entry.applyChanges();
                        this.typingEditBox = null;
                    }
                });
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.m_7222_() != null) {
            this.m_7222_().m_93692_(false);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_7222_() != null || button == 1) {
            this.m_7222_().m_93692_(false);
            this.m_7522_(null);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.entries.size() > 7) {
            if (this.scrollOffset < 1.0 && scrollY < 0.0) {
                this.scrollOffset = Mth.m_14008_((double)(this.scrollOffset + scrollY), (double)0.0, (double)1.0);
            }
            if (this.scrollOffset > 0.0 && scrollY > 0.0) {
                this.scrollOffset = Mth.m_14008_((double)(this.scrollOffset - scrollY), (double)0.0, (double)1.0);
            }
            this.entryOffset = (int)Math.floor(this.scrollOffset * (double)(this.entries.size() - 7));
            this.scrollTo();
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color) {
        int i = font.m_92852_((FormattedText)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.m_137550_() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.m_14139_((double)d2, (double)0.0, (double)l);
            guiGraphics.m_280588_(minX, minY, maxX, maxY);
            guiGraphics.m_280430_(font, text, minX - (int)d3, j, color);
            guiGraphics.m_280618_();
        } else {
            guiGraphics.m_280653_(font, text, (minX + maxX) / 2, j, color);
        }
    }

    public static interface EntryBuilder {
        public void build();

        public void render(GuiGraphics var1, float var2, int var3, int var4);

        public void syncConfig();

        public void applyChanges();

        default public Optional<EditBox> getEditBox() {
            return Optional.empty();
        }
    }

    public class ConfigEntry<T>
    implements EntryBuilder {
        public final int index;
        private final Component tip;
        private final IConfigValue<T> configValue;
        private final T initialValue;
        private AbstractWidget configWidget;
        int widgetX;
        int widgetY;

        public ConfigEntry(int index, Component tip, T initialValue, IConfigValue<T> configValue) {
            this.index = index;
            this.tip = tip;
            this.configValue = configValue;
            this.initialValue = initialValue;
            this.widgetX = EndInvSettingScreen.this.leftPos + 165;
            this.widgetY = EndInvSettingScreen.this.topPos + 17 + index * 20 + 1;
        }

        @Override
        public void build() {
            if (this.initialValue instanceof Boolean) {
                IConfigValue booleanValue = this.configValue;
                CycleButton button = CycleButton.m_168916_((boolean)((Boolean)this.initialValue)).m_168929_().m_168936_(this.widgetX, this.widgetY, 60, 18, (Component)Component.m_237119_(), (btn, value) -> booleanValue.set(value));
                this.configWidget = button;
                EndInvSettingScreen.this.m_142416_((GuiEventListener)button);
            } else if (this.initialValue instanceof Enum) {
                IConfigValue enumValue = this.configValue;
                CycleButton button = new CycleButton.Builder(e -> Component.m_237115_((String)("endinv.setting.entry." + e.name()))).m_168961_((Object[])((Enum[])this.initialValue.getClass().getEnumConstants())).m_168948_((Object)((Enum)this.initialValue)).m_168929_().m_168936_(this.widgetX, this.widgetY, 60, 18, (Component)Component.m_237119_(), (btn, value) -> enumValue.set(value));
                this.configWidget = button;
                EndInvSettingScreen.this.m_142416_((GuiEventListener)button);
            } else if (this.initialValue instanceof Integer) {
                EditBox editBox = new EditBox(EndInvSettingScreen.this.f_96547_, this.widgetX, this.widgetY, 60, 18, this.tip);
                this.configWidget = editBox;
                EndInvSettingScreen.this.m_142416_((GuiEventListener)editBox);
            } else {
                EndInvSettingScreen self = EndInvSettingScreen.this;
                self.m_169394_((guiGraphics, i, i1, v) -> guiGraphics.m_280488_(self.f_96547_, "Error", this.widgetX, this.widgetY, -51401));
            }
        }

        @Override
        public void render(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            guiGraphics.m_280430_(EndInvSettingScreen.this.f_96547_, this.tip, EndInvSettingScreen.this.leftPos + 10, this.widgetY, -256);
        }

        @Override
        public void syncConfig() {
            AbstractWidget abstractWidget = this.configWidget;
            if (abstractWidget instanceof CycleButton) {
                CycleButton button = (CycleButton)abstractWidget;
                button.m_168892_(this.configValue.get());
            } else {
                abstractWidget = this.configWidget;
                if (abstractWidget instanceof EditBox) {
                    EditBox editBox = (EditBox)abstractWidget;
                    editBox.m_94144_(String.valueOf(this.configValue.get()));
                }
            }
        }

        @Override
        public void applyChanges() {
            AbstractWidget abstractWidget = this.configWidget;
            if (abstractWidget instanceof EditBox) {
                EditBox editBox = (EditBox)abstractWidget;
                T parsed = this.parse(editBox.m_94155_());
                if (parsed == null) {
                    return;
                }
                this.configValue.set(parsed);
            }
        }

        @Override
        public Optional<EditBox> getEditBox() {
            Optional<EditBox> optional;
            AbstractWidget abstractWidget = this.configWidget;
            if (abstractWidget instanceof EditBox) {
                EditBox box = (EditBox)abstractWidget;
                optional = Optional.of(box);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        private T parse(String s) {
            try {
                return (T)Integer.valueOf(s);
            }
            catch (Exception e) {
                ((EditBox)this.configWidget).m_94144_(String.valueOf(this.configValue.get()));
                return null;
            }
        }

        public Component getTip() {
            return this.tip;
        }

        public IConfigValue<?> getConfigValue() {
            return this.configValue;
        }
    }

    public class InfoEntry
    implements EntryBuilder {
        private final Component tip;
        private final Supplier<Object> info;
        int widgetMidX;
        int widgetY;

        public InfoEntry(int index, Component tip, Supplier<Object> info) {
            this.tip = tip;
            this.info = info;
            this.widgetMidX = EndInvSettingScreen.this.leftPos + 165 + 30 - 40;
            this.widgetY = EndInvSettingScreen.this.topPos + 17 + index * 20 + 1;
        }

        @Override
        public void build() {
        }

        @Override
        public void render(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            Font font = EndInvSettingScreen.this.f_96547_;
            guiGraphics.m_280430_(font, this.tip, EndInvSettingScreen.this.leftPos + 10, this.widgetY, -256);
            MutableComponent v = Component.m_237113_((String)(this.info.get() != null ? this.info.get().toString() : "null"));
            int infoLength = Math.min(font.m_92724_(v.m_7532_()), 100);
            EndInvSettingScreen.renderScrollingString(guiGraphics, font, (Component)v, this.widgetMidX - infoLength / 2, this.widgetY, this.widgetMidX + infoLength / 2, this.widgetY + 7, -16711681);
        }

        @Override
        public void syncConfig() {
        }

        @Override
        public void applyChanges() {
        }
    }

    public class EnumAttributeEntry<E extends Enum<?>>
    extends AttributeEntry<Enum<?>> {
        E e;

        public EnumAttributeEntry(int index, Component tip, Supplier<Enum<?>> attributeGetter, Consumer<Enum<?>> attributeSetter) {
            super(index, tip, attributeGetter, attributeSetter);
        }

        @Override
        Enum<?> parse(String s) {
            try {
                return Enum.valueOf(this.e.getClass(), s);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public class IntAttributeEntry
    extends AttributeEntry<Integer> {
        public IntAttributeEntry(int index, Component tip, Supplier<Integer> attributeGetter, Consumer<Integer> attributeSetter) {
            super(index, tip, attributeGetter, attributeSetter);
        }

        @Override
        Integer parse(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public class StringAttributeEntry
    extends AttributeEntry<String> {
        public StringAttributeEntry(int index, Component tip, Supplier<String> attributeGetter, Consumer<String> attributeSetter) {
            super(index, tip, attributeGetter, attributeSetter);
        }

        @Override
        String parse(String s) {
            return s;
        }
    }

    public abstract class AttributeEntry<T>
    implements EntryBuilder {
        public final int index;
        private final Component tip;
        private final Supplier<T> attributeGetter;
        private final Consumer<T> attributeSetter;
        private EditBox editBox;
        int widgetX;
        int widgetY;

        public AttributeEntry(int index, Component tip, Supplier<T> attributeGetter, Consumer<T> attributeSetter) {
            this.index = index;
            this.tip = tip;
            this.attributeGetter = attributeGetter;
            this.attributeSetter = attributeSetter;
            this.widgetX = EndInvSettingScreen.this.leftPos + 165;
            this.widgetY = EndInvSettingScreen.this.topPos + 17 + index * 20 + 1;
        }

        @Override
        public void build() {
            EditBox editBox = new EditBox(EndInvSettingScreen.this.f_96547_, this.widgetX, this.widgetY, 60, 18, (Component)Component.m_237119_());
            EndInvSettingScreen.this.m_142416_((GuiEventListener)editBox);
            this.editBox = editBox;
        }

        @Override
        public void render(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            guiGraphics.m_280430_(EndInvSettingScreen.this.f_96547_, this.tip, EndInvSettingScreen.this.leftPos + 10, this.widgetY, -256);
        }

        @Override
        public void syncConfig() {
            this.editBox.m_94144_(this.attributeGetter.get().toString());
        }

        @Override
        public void applyChanges() {
            T t = this.parse(this.editBox.m_94155_());
            if (t == null) {
                this.editBox.m_94144_(this.attributeGetter.get().toString());
            } else {
                this.attributeSetter.accept(t);
            }
        }

        abstract T parse(String var1);

        @Override
        public Optional<EditBox> getEditBox() {
            return Optional.of(this.editBox);
        }
    }
}

