/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.DestinyManager;
import net.conczin.mca.KeyBindings;
import net.conczin.mca.MCA;
import net.conczin.mca.client.gui.SkinLibraryScreen;
import net.conczin.mca.client.tts.SpeechManager;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.ConfigRequest;
import net.conczin.mca.network.c2s.PlayerDataRequest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class MCAClient {
    public static final Map<UUID, VillagerLike<?>> playerData = new HashMap();
    public static final Set<UUID> playerDataRequests = new HashSet<UUID>();
    private static final DestinyManager destinyManager = new DestinyManager();
    public static VillagerEntityMCA fallbackVillager;

    public static DestinyManager getDestinyManager() {
        return destinyManager;
    }

    public static void onLogin() {
        playerDataRequests.clear();
        Network.sendToServer(new ConfigRequest());
    }

    public static Optional<VillagerLike<?>> getPlayerData(UUID uuid) {
        if (MCAClient.isPlayerRendererAllowed()) {
            if (!playerDataRequests.contains(uuid) && Minecraft.getInstance().getConnection() != null) {
                playerDataRequests.add(uuid);
                Network.sendToServer(new PlayerDataRequest(uuid));
            }
            if (playerData.containsKey(uuid)) {
                return Optional.of(playerData.get(uuid));
            }
        }
        return Optional.empty();
    }

    public static boolean useExpandedPersonalityTranslations() {
        boolean isTTSPackActive = Minecraft.getInstance().getResourceManager().listPacks().anyMatch(pack -> pack.packId().contains("MCAVoices"));
        return !isTTSPackActive && Minecraft.getInstance().options.languageCode.equals("en_us") && !Config.getInstance().enableOnlineTTS;
    }

    public static boolean useGeneticsRenderer(UUID uuid) {
        return MCAClient.getPlayerData(uuid).filter(f -> f.getPlayerModel() != VillagerLike.PlayerModel.VANILLA).isPresent();
    }

    public static boolean useVillagerRenderer(UUID uuid) {
        return MCAClient.useGeneticsRenderer(uuid) && playerData.get(uuid).getPlayerModel() == VillagerLike.PlayerModel.VILLAGER;
    }

    public static boolean renderArms(UUID uuid, String key) {
        return MCAClient.useVillagerRenderer(uuid) && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("arms") || ((String)entry.getValue()).equals(key)).noneMatch(entry -> MCA.platformHelper.isModLoaded((String)entry.getKey()));
    }

    public static void tickClient(Minecraft client) {
        destinyManager.tick(client);
        if (KeyBindings.SKIN_LIBRARY.consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new SkinLibraryScreen());
        }
        SpeechManager.INSTANCE.tick(client);
    }

    public static void addPlayerData(UUID uuid, VillagerEntityMCA villager) {
        playerData.put(uuid, villager);
        Minecraft client = Minecraft.getInstance();
        if (client.player != null) {
            client.player.refreshDimensions();
        }
    }

    public static boolean isPlayerRendererAllowed() {
        return Config.getInstance().enableVillagerPlayerModel && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("all") || ((String)entry.getValue()).equals("block_player")).noneMatch(entry -> MCA.platformHelper.isModLoaded((String)entry.getKey()));
    }

    public static boolean isVillagerRendererAllowed() {
        return !Config.getInstance().forceVillagerPlayerModel && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("all") || ((String)entry.getValue()).equals("block_villager")).noneMatch(entry -> MCA.platformHelper.isModLoaded((String)entry.getKey()));
    }

    public static boolean areShadersAllowed(String key) {
        return Config.getInstance().enablePlayerShaders && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("shaders") || ((String)entry.getValue()).equals(key)).noneMatch(entry -> MCA.platformHelper.isModLoaded((String)entry.getKey()));
    }

    public static boolean areShadersAllowed() {
        return MCAClient.areShadersAllowed("shaders");
    }
}

