/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class FamilyCriterion
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player) {
        FamilyTreeNode familyTree = FamilyTree.get(player.serverLevel()).getOrCreate((Entity)player);
        long c = familyTree.getRelatives(0, 1).count();
        long gc = familyTree.getRelatives(0, 2).count() - c;
        this.trigger(player, condition -> condition.test((int)c, (int)gc));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints children, MinMaxBounds.Ints grandchildren) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("children", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::children), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("grandchildren", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::grandchildren)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> family(MinMaxBounds.Ints children, MinMaxBounds.Ints grandchildren) {
            return CriterionMCA.FAMILY.createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), children, grandchildren));
        }

        public boolean test(int c, int gc) {
            return this.children.matches(c) && this.grandchildren.matches(gc);
        }
    }
}

