/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.conczin.mca.client.gui.MCAButton;
import net.conczin.mca.client.gui.MCAScreens;
import net.conczin.mca.client.resources.Icon;
import net.conczin.mca.entity.interaction.Constraint;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractDynamicScreen
extends Screen {
    protected static final float iconScale = 1.5f;
    private String activeScreen = "main";
    private int mouseX;
    private int mouseY;
    private Set<Constraint> constraints = new HashSet<Constraint>();

    protected AbstractDynamicScreen(Component title) {
        super(title);
    }

    public String getActiveScreen() {
        return this.activeScreen;
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Set<Constraint> constraints) {
        this.constraints = constraints;
        this.setLayout(this.activeScreen);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    protected abstract void buttonPressed(MCAButton var1);

    protected void disableButton(String id) {
        this.children().forEach(b -> {
            if (b instanceof ButtonEx && ((ButtonEx)((Object)b)).getApiButton().identifier().equals(id)) {
                ((ButtonEx)b).active = false;
            }
        });
    }

    protected void disableAllButtons() {
        this.children().forEach(b -> {
            if (b instanceof AbstractWidget) {
                if (b instanceof ButtonEx) {
                    if (!((ButtonEx)((Object)b)).getApiButton().identifier().equals("gui.button.backarrow")) {
                        ((AbstractWidget)b).active = false;
                    }
                } else {
                    ((AbstractWidget)b).active = false;
                }
            }
        });
    }

    public void setLayout(String guiKey) {
        this.activeScreen = guiKey;
        this.clearWidgets();
        MCAScreens.getInstance().getScreen(guiKey).ifPresent(buttons -> {
            for (MCAButton b : buttons) {
                this.addRenderableWidget((GuiEventListener)new ButtonEx(b, this));
            }
        });
    }

    protected void drawIcon(GuiGraphics context, ResourceLocation texture, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        context.blit(texture, (int)((float)icon.x() / 1.5f), (int)((float)icon.y() / 1.5f), icon.u(), icon.v(), 16, 16);
    }

    protected void drawHoveringIconText(GuiGraphics context, Component text, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        context.renderTooltip(this.font, text, icon.x() + 16, icon.y() + 20);
    }

    protected void drawHoveringIconText(GuiGraphics context, List<Component> text, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        context.renderComponentTooltip(this.font, text, icon.x() + 16, icon.y() + 20);
    }

    protected boolean hoveringOverIcon(String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        return this.hoveringOver(icon.x(), icon.y(), 24, 24);
    }

    protected boolean hoveringOver(int x, int y, int w, int h) {
        return this.mouseX > x && this.mouseX < x + w && this.mouseY > y && this.mouseY < y + h;
    }

    private static class ButtonEx
    extends Button {
        private final MCAButton apiButton;

        public ButtonEx(MCAButton apiButton, AbstractDynamicScreen screen) {
            super((int)((float)screen.width * Alignment.alignments.get((Object)apiButton.align()).h + (float)apiButton.x()), (int)((float)screen.height * Alignment.alignments.get((Object)apiButton.align()).v + (float)apiButton.y()), apiButton.width(), apiButton.height(), (Component)Component.translatable((String)apiButton.identifier()), a -> screen.buttonPressed(apiButton), DEFAULT_NARRATION);
            this.apiButton = apiButton;
            if (!apiButton.isValidForConstraint(screen.getConstraints())) {
                if (apiButton.hideOnFail()) {
                    this.visible = false;
                }
                this.active = false;
            }
        }

        public MCAButton getApiButton() {
            return this.apiButton;
        }
    }

    private static enum Alignment {
        TOP_LEFT(0.0f, 0.0f),
        TOP(0.5f, 0.0f),
        TOP_RIGHT(1.0f, 0.0f),
        RIGHT(1.0f, 0.5f),
        BOTTOM_RIGHT(1.0f, 1.0f),
        BOTTOM(0.5f, 1.0f),
        BOTTOM_LEFT(0.0f, 1.0f),
        LEFT(0.0f, 0.5f),
        CENTER(0.5f, 0.5f);

        static final Map<String, Alignment> alignments;
        final float h;
        final float v;

        private Alignment(float h, float v) {
            this.h = h;
            this.v = v;
        }

        static {
            alignments = new HashMap<String, Alignment>();
            for (Alignment a : Alignment.values()) {
                alignments.put(a.name().toLowerCase(Locale.ENGLISH), a);
            }
        }
    }
}

